/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.pool;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;

public class ConnectionPool {
    private static BasicDataSource pool;

    private static void init() {
        SilverTrace.debug("util", "ConnectionPool.getConnection", "No more free connection : we need to create a new one.");
        ResourceLocator resources = new ResourceLocator("org.silverpeas.beans.admin.admin", "");
        pool = new BasicDataSource();
        pool.setPassword(resources.getString("WaProductionPswd"));
        pool.setUsername(resources.getString("WaProductionUser"));
        pool.setDriverClassName(resources.getString("AdminDBDriver"));
        pool.setUrl(resources.getString("WaProductionDb"));
        pool.setRemoveAbandoned(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnections() throws SQLException {
        SilverTrace.debug("util", "ConnectionPool.releaseConnections", "start");
        Class<ConnectionPool> clazz = ConnectionPool.class;
        synchronized (ConnectionPool.class) {
            pool.close();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection() throws SQLException {
        SilverTrace.debug("util", "ConnectionPool.getConnection", "start");
        Class<ConnectionPool> clazz = ConnectionPool.class;
        synchronized (ConnectionPool.class) {
            if (pool.isClosed()) {
                ConnectionPool.init();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return pool.getConnection();
        }
    }

    private ConnectionPool() {
    }

    static {
        ConnectionPool.init();
    }
}

