/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.repository;

import com.silverpeas.jcrutil.BasicDaoFactory;
import com.silverpeas.util.ArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class BinaryInputStream
extends InputStream {
    private final Binary binary;
    private final InputStream in;
    private final Session session;

    public BinaryInputStream(String path) throws IOException {
        try {
            this.session = BasicDaoFactory.getSystemSession();
            String relativePath = path;
            if (path.startsWith("/")) {
                relativePath = path.substring(1);
            }
            Node rootNode = this.session.getRootNode();
            if (this.session.itemExists(path) && this.session.itemExists(path + '/' + "{http://www.jcp.org/jcr/1.0}content")) {
                Node contentNode = rootNode.getNode(relativePath + '/' + "{http://www.jcp.org/jcr/1.0}content");
                this.binary = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary();
                this.in = this.binary.getStream();
            } else {
                this.binary = null;
                this.in = new ByteArrayInputStream(ArrayUtil.EMPTY_BYTE_ARRAY);
            }
        }
        catch (RepositoryException rex) {
            throw new IOException(rex);
        }
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            if (this.binary != null) {
                this.binary.dispose();
            }
            BasicDaoFactory.logout(this.session);
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

