/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.util;

import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.comparator.AbstractComplexComparator;
import com.silverpeas.util.i18n.I18NHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.silverpeas.attachment.model.SimpleDocument;

public class SimpleDocumentList<SIMPLE_DOCUMENT extends SimpleDocument>
extends ArrayList<SIMPLE_DOCUMENT> {
    private static final long serialVersionUID = 4986827710138035170L;
    private static final String[] ALL_LANGUAGES_BY_PRIORITY = I18NHelper.getAllSupportedLanguages().toArray(new String[I18NHelper.getNumberOfLanguages()]);
    private String queryLanguage = null;

    public SimpleDocumentList(int initialCapacity) {
        super(initialCapacity);
    }

    public SimpleDocumentList() {
    }

    public SimpleDocumentList(Collection<? extends SIMPLE_DOCUMENT> c) {
        super(c);
    }

    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    public SimpleDocumentList<SIMPLE_DOCUMENT> setQueryLanguage(String queryLanguage) {
        this.queryLanguage = StringUtil.isDefined(queryLanguage) ? queryLanguage : null;
        return this;
    }

    public SimpleDocumentList<SIMPLE_DOCUMENT> removeLanguageFallbacks() {
        String language;
        if (!this.isEmpty() && (language = I18NHelper.checkLanguage(this.getQueryLanguage())).equals(this.getQueryLanguage())) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                SimpleDocument document = (SimpleDocument)it.next();
                if (language.equals(document.getLanguage())) continue;
                it.remove();
            }
        }
        return this;
    }

    public SimpleDocumentList<SIMPLE_DOCUMENT> orderByLanguageAndLastUpdate(String ... languageOrderedByPriority) {
        if (this.size() > 1) {
            Collections.sort(this, new LanguageAndLastUpdateComparator(languageOrderedByPriority, new ORDER_BY[]{ORDER_BY.LANGUAGE_PRIORITY_DESC, ORDER_BY.LAST_UPDATE_DATE_DESC}));
        }
        return this;
    }

    private class LanguageAndLastUpdateComparator
    extends AbstractComplexComparator<SIMPLE_DOCUMENT> {
        private Map<String, Integer> languagePriorityCache = new HashMap<String, Integer>(I18NHelper.getNumberOfLanguages());
        private final ORDER_BY[] orderBies;

        private LanguageAndLastUpdateComparator(String[] languageOrderedByPriority, ORDER_BY ... orderBies) {
            this.orderBies = orderBies;
            if (ArrayUtil.contains((Object[])orderBies, (Object)((Object)ORDER_BY.LANGUAGE_PRIORITY_DESC))) {
                for (String language : ALL_LANGUAGES_BY_PRIORITY) {
                    this.languagePriorityCache.put(language, this.languagePriorityCache.size() + ALL_LANGUAGES_BY_PRIORITY.length + 1);
                }
                int i = 0;
                for (String language : languageOrderedByPriority) {
                    this.languagePriorityCache.put(language, i++);
                }
                this.languagePriorityCache.put(null, this.languagePriorityCache.size() + ALL_LANGUAGES_BY_PRIORITY.length + 1);
            }
        }

        @Override
        protected AbstractComplexComparator.ValueBuffer getValuesToCompare(SIMPLE_DOCUMENT simpleDocument) {
            AbstractComplexComparator.ValueBuffer valueBuffer = new AbstractComplexComparator.ValueBuffer(this);
            block4: for (ORDER_BY orderBy : this.orderBies) {
                switch (orderBy) {
                    case LANGUAGE_PRIORITY_DESC: {
                        valueBuffer.append(this.getLanguagePriorityIndex(simpleDocument), orderBy.isAscending());
                        continue block4;
                    }
                    case LAST_UPDATE_DATE_DESC: {
                        valueBuffer.append(((SimpleDocument)simpleDocument).getUpdated() != null ? ((SimpleDocument)simpleDocument).getUpdated() : ((SimpleDocument)simpleDocument).getCreated(), orderBy.isAscending());
                        continue block4;
                    }
                    default: {
                        throw new NotImplementedException();
                    }
                }
            }
            return valueBuffer;
        }

        private int getLanguagePriorityIndex(SIMPLE_DOCUMENT simpleDocument) {
            return this.languagePriorityCache.get(((SimpleDocument)simpleDocument).getLanguage()) * -1;
        }
    }

    private static enum ORDER_BY {
        LANGUAGE_PRIORITY_DESC(false),
        LAST_UPDATE_DATE_DESC(false);

        private final boolean ascending;

        private ORDER_BY(boolean ascending) {
            this.ascending = ascending;
        }

        public boolean isAscending() {
            return this.ascending;
        }
    }
}

