/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.webdav.impl;

import com.silverpeas.jcrutil.converter.ConverterUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.webdav.WebdavRepository;

@Named(value="webdavRepository")
public class WebdavDocumentRepository
implements WebdavRepository {
    @Override
    public void createAttachmentNode(Session session, SimpleDocument attachment) throws RepositoryException, IOException {
        String lang;
        Node rootNode = session.getRootNode();
        Node attachmentFolder = this.addFolder(rootNode, "webdav");
        attachmentFolder = this.addFolder(attachmentFolder, DocumentType.attachment.getFolderName());
        Node contextFolder = this.addFolder(attachmentFolder, attachment.getInstanceId());
        if (attachment.getId() != null) {
            contextFolder = this.addFolder(contextFolder, attachment.getId());
        }
        if (!StringUtil.isDefined(lang = attachment.getLanguage())) {
            lang = I18NHelper.defaultLanguage;
        }
        contextFolder = this.addExclusiveFolder(contextFolder, lang);
        this.addFile(contextFolder, attachment);
    }

    @Override
    public void updateNodeAttachment(Session session, SimpleDocument attachment) throws RepositoryException, IOException {
        Node rootNode = session.getRootNode();
        try {
            Node fileNode = rootNode.getNode(attachment.getWebdavJcrPath());
            this.setContent(fileNode, attachment);
        }
        catch (PathNotFoundException pex) {
            this.createAttachmentNode(session, attachment);
        }
    }

    @Override
    public void moveNodeAttachment(Session session, SimpleDocument attachment, String targetComponentInstanceId) throws RepositoryException, IOException {
        Node nodeToMove;
        if (attachment.getPk() != null && StringUtil.isDefined(targetComponentInstanceId) && !attachment.getInstanceId().equals(targetComponentInstanceId) && (nodeToMove = this.getDocumentIdentifierNode(session, attachment)) != null) {
            Node nodeToPurge = nodeToMove.getParent();
            Node rootNode = session.getRootNode();
            Node webdavNode = this.addFolder(rootNode, "webdav");
            Node documentTypeNode = this.addFolder(webdavNode, DocumentType.attachment.getFolderName());
            Node destinationNode = this.addFolder(documentTypeNode, targetComponentInstanceId);
            session.save();
            session.getWorkspace().move(nodeToMove.getPath(), destinationNode.getPath() + "/" + attachment.getId());
            this.purgeWebdavFromNode(nodeToPurge);
        }
    }

    protected Node getDocumentIdentifierNode(Session session, SimpleDocument attachment) throws RepositoryException {
        return this.getDocumentNode(session, attachment, null);
    }

    protected Node getDocumentContentLanguageNode(Session session, SimpleDocument attachment, String language) throws RepositoryException {
        Node documentContentLanguageNode = null;
        if (StringUtil.isDefined(language)) {
            documentContentLanguageNode = this.getDocumentNode(session, attachment, "/" + language);
        }
        return documentContentLanguageNode;
    }

    private Node getDocumentNode(Session session, SimpleDocument attachment, String suffixPathPattern) throws RepositoryException {
        if (StringUtil.isDefined(attachment.getId())) {
            Pattern pattern = Pattern.compile(".*/" + attachment.getId() + StringUtil.defaultStringIfNotDefined(suffixPathPattern, ""));
            Matcher matcher = pattern.matcher(attachment.getWebdavJcrPath());
            if (!matcher.find()) {
                return null;
            }
            String webdavPath = matcher.group();
            try {
                Node rootNode = session.getRootNode();
                return rootNode.getNode(webdavPath);
            }
            catch (PathNotFoundException pex) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void deleteAttachmentNode(Session session, SimpleDocument attachment) throws RepositoryException {
        Node rootNode = session.getRootNode();
        try {
            Node fileNode = this.getDocumentIdentifierNode(session, attachment);
            if (fileNode == null) {
                fileNode = rootNode.getNode(attachment.getWebdavJcrPath());
            }
            Node parentNode = fileNode.getParent();
            fileNode.remove();
            this.purgeWebdavFromNode(parentNode);
        }
        catch (PathNotFoundException pex) {
            // empty catch block
        }
    }

    @Override
    public void deleteAttachmentContentNode(Session session, SimpleDocument attachment, String language) throws RepositoryException {
        Node fileNode = this.getDocumentContentLanguageNode(session, attachment, language);
        if (fileNode != null) {
            Node parentNode = fileNode.getParent();
            fileNode.remove();
            this.purgeWebdavFromNode(parentNode);
        }
    }

    private void purgeWebdavFromNode(Node parentNodeOfDeletedOne) throws RepositoryException {
        Node currentNode = parentNodeOfDeletedOne;
        if (currentNode != null) {
            while (!currentNode.hasNodes() && !"webdav".equals(currentNode.getName())) {
                Node nodeToRemove = currentNode;
                currentNode = currentNode.getParent();
                nodeToRemove.remove();
            }
            if (!currentNode.hasNodes()) {
                currentNode.remove();
            }
        }
    }

    @Override
    public boolean isNodeLocked(Session session, SimpleDocument attachment) throws RepositoryException {
        Node rootNode = session.getRootNode();
        try {
            Node fileNode = rootNode.getNode(attachment.getWebdavJcrPath());
            return fileNode.isLocked();
        }
        catch (PathNotFoundException pex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAttachmentBinaryContent(Session session, SimpleDocument attachment) throws RepositoryException, IOException {
        Node rootNode = session.getRootNode();
        Node webdavFileNode = rootNode.getNode(attachment.getWebdavJcrPath());
        Binary webdavBinary = webdavFileNode.getNode("{http://www.jcp.org/jcr/1.0}content").getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary();
        InputStream in = webdavBinary.getStream();
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream((File)new File(attachment.getAttachmentPath()));
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly((InputStream)in);
            webdavBinary.dispose();
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)in);
        webdavBinary.dispose();
    }

    protected Node addFolder(Node parent, String name) throws RepositoryException {
        try {
            return parent.getNode(name);
        }
        catch (PathNotFoundException pnfex) {
            return parent.addNode(name, "nt:folder");
        }
    }

    protected Node addExclusiveFolder(Node parent, String name) throws RepositoryException {
        try {
            NodeIterator nodeIt = parent.getNodes();
            while (nodeIt.hasNext()) {
                Node currentNode = nodeIt.nextNode();
                if (currentNode.getName().equals(name)) continue;
                currentNode.remove();
            }
            return parent.getNode(name);
        }
        catch (PathNotFoundException pnfex) {
            return parent.addNode(name, "nt:folder");
        }
    }

    protected Node addFile(Node folder, SimpleDocument attachment) throws RepositoryException, IOException {
        NodeIterator fileNodeIt = folder.getNodes();
        while (fileNodeIt.hasNext()) {
            fileNodeIt.nextNode().remove();
        }
        String escapedName = ConverterUtil.escapeIllegalJcrChars(attachment.getFilename());
        Node fileNode = folder.addNode(escapedName, "nt:file");
        if (attachment.getEditedBy() != null) {
            fileNode.addMixin("slv:ownable");
            fileNode.setProperty("slv:owner", attachment.getEditedBy());
        }
        Node contentNode = fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "nt:resource");
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", attachment.getContentType());
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}encoding", "");
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", Calendar.getInstance());
        this.setContent(fileNode, attachment);
        return fileNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContent(Node fileNode, SimpleDocument attachment) throws RepositoryException, IOException {
        FileInputStream in = FileUtils.openInputStream((File)new File(attachment.getAttachmentPath()));
        try {
            Binary attachmentBinary = fileNode.getSession().getValueFactory().createBinary((InputStream)in);
            fileNode.getNode("{http://www.jcp.org/jcr/1.0}content").setProperty("{http://www.jcp.org/jcr/1.0}data", attachmentBinary);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public String getContentEditionLanguage(Session session, SimpleDocument attachment) throws RepositoryException {
        Pattern pattern;
        Matcher matcher;
        String contentEditionLanguage = null;
        if (StringUtil.isDefined(attachment.getId()) && (matcher = (pattern = Pattern.compile("(?i).*/" + attachment.getId() + "/")).matcher(attachment.getWebdavJcrPath())).find()) {
            Node rootNode = session.getRootNode();
            try {
                Node webdavNode = rootNode.getNode(matcher.group());
                NodeIterator webdavNodeIt = webdavNode.getNodes();
                Date creationDate = null;
                while (webdavNodeIt.hasNext()) {
                    Node currentLanguageNode = webdavNodeIt.nextNode();
                    Node currentFileNode = currentLanguageNode.getNodes().nextNode();
                    if (creationDate != null && !creationDate.before(currentFileNode.getProperty("{http://www.jcp.org/jcr/1.0}created").getDate().getTime())) continue;
                    creationDate = currentFileNode.getProperty("{http://www.jcp.org/jcr/1.0}created").getDate().getTime();
                    contentEditionLanguage = currentLanguageNode.getName();
                }
            }
            catch (PathNotFoundException pex) {
                // empty catch block
            }
        }
        return contentEditionLanguage;
    }

    @Override
    public long getContentEditionSize(Session session, SimpleDocument attachment) throws RepositoryException {
        String currentLanguage = attachment.getLanguage();
        String webDavJcrPath = attachment.getWebdavJcrPath().replaceFirst("/[^/]+$", "");
        String languageInWebDav = this.getContentEditionLanguage(session, attachment);
        if (languageInWebDav != null) {
            if (!currentLanguage.equals(languageInWebDav)) {
                String before = attachment.getId() + "/" + currentLanguage;
                String after = attachment.getId() + "/" + languageInWebDav;
                webDavJcrPath = webDavJcrPath.replace(before, after);
            }
            try {
                Node rootNode = session.getRootNode();
                Node webdavFileNode = rootNode.getNode(webDavJcrPath).getNodes().nextNode();
                Binary webdavBinary = webdavFileNode.getNode("{http://www.jcp.org/jcr/1.0}content").getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary();
                return webdavBinary.getSize();
            }
            catch (PathNotFoundException pex) {
                // empty catch block
            }
        }
        return -1L;
    }
}

