/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.silverpeas.authentication.Authentication;
import org.silverpeas.authentication.AuthenticationConnection;
import org.silverpeas.authentication.AuthenticationCredential;
import org.silverpeas.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.exception.AuthenticationHostException;

public class AuthenticationCAS
extends Authentication {
    protected String jdbcUrl;
    protected String jdbcLogin;
    protected String jdbcPasswd;
    protected String jdbcDriver;
    protected String loginTableName;
    protected String loginColumnName;
    private String loginQuery;

    @Override
    public void loadProperties(ResourceLocator settings) {
        String serverName = this.getServerName();
        this.jdbcUrl = settings.getString(serverName + ".SQLJDBCUrl");
        this.jdbcLogin = settings.getString(serverName + ".SQLAccessLogin");
        this.jdbcPasswd = settings.getString(serverName + ".SQLAccessPasswd");
        this.jdbcDriver = settings.getString(serverName + ".SQLDriverClass");
        this.loginTableName = settings.getString(serverName + ".SQLUserTableName");
        this.loginColumnName = settings.getString(serverName + ".SQLUserLoginColumnName");
        this.loginQuery = "SELECT " + this.loginColumnName + " FROM " + this.loginTableName + " WHERE " + this.loginColumnName + " = ?";
    }

    protected AuthenticationConnection<Connection> openConnection() throws AuthenticationException {
        Properties info = new Properties();
        Driver driverSQL = null;
        try {
            info.setProperty("user", this.jdbcLogin);
            info.setProperty("password", this.jdbcPasswd);
            driverSQL = (Driver)Class.forName(this.jdbcDriver).newInstance();
        }
        catch (InstantiationException ex) {
            throw new AuthenticationHostException("AuthenticationCAS.openConnection()", 4, "root.EX_CANT_INSTANCIATE_DB_DRIVER", "Driver=" + this.jdbcDriver, ex);
        }
        catch (IllegalAccessException ex) {
            throw new AuthenticationHostException("AuthenticationCAS.openConnection()", 4, "root.EX_CANT_INSTANCIATE_DB_DRIVER", "Driver=" + this.jdbcDriver, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new AuthenticationHostException("AuthenticationCAS.openConnection()", 4, "root.EX_CANT_INSTANCIATE_DB_DRIVER", "Driver=" + this.jdbcDriver, ex);
        }
        try {
            Connection connection = driverSQL.connect(this.jdbcUrl, info);
            return new AuthenticationConnection<Connection>(connection);
        }
        catch (SQLException ex) {
            throw new AuthenticationHostException("AuthenticationCAS.openConnection()", 4, "root.EX_CONNECTION_OPEN_FAILED", "JDBCUrl=" + this.jdbcUrl, ex);
        }
    }

    protected void doAuthentication(AuthenticationConnection connection, AuthenticationCredential credential) throws AuthenticationException {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = AuthenticationCAS.getSQLConnection(connection).prepareStatement(this.loginQuery);
            stmt.setString(1, credential.getLogin());
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new AuthenticationBadCredentialException("AuthenticationCAS.doAuthentication()", 4, "authentication.EX_USER_NOT_FOUND", "User=" + credential.getLogin());
            }
            SilverTrace.info("authentication", "AuthenticationCAS.doAuthentication()", "authentication.MSG_USER_AUTHENTIFIED", "User=" + credential.getLogin());
        }
        catch (SQLException ex) {
            try {
                throw new AuthenticationHostException("AuthenticationCAS.doAuthentication()", 4, "authentication.EX_SQL_ACCESS_ERROR", ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, stmt);
                throw throwable;
            }
        }
        DBUtil.close(rs, stmt);
    }

    protected void closeConnection(AuthenticationConnection connection) throws AuthenticationException {
        DBUtil.close(AuthenticationCAS.getSQLConnection(connection));
    }

    private static Connection getSQLConnection(AuthenticationConnection<Connection> connection) {
        return connection.getConnector();
    }
}

