/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.silverpeas.authentication.AuthenticationCredential;
import org.silverpeas.authentication.AuthenticationServer;
import org.silverpeas.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.exception.AuthenticationHostException;
import org.silverpeas.authentication.exception.AuthenticationPasswordExpired;
import org.silverpeas.authentication.exception.AuthenticationPasswordMustBeChangedAtNextLogon;
import org.silverpeas.authentication.exception.AuthenticationPasswordMustBeChangedOnFirstLogin;
import org.silverpeas.authentication.exception.AuthenticationPwdNotAvailException;
import org.silverpeas.authentication.exception.AuthenticationUserAccountBlockedException;
import org.silverpeas.authentication.exception.AuthenticationUserAccountDeactivatedException;
import org.silverpeas.authentication.verifier.AuthenticationUserVerifierFactory;

public class AuthenticationService {
    private static final String module = "authentication";
    protected static final String m_JDBCUrl;
    protected static final String m_AccessLogin;
    protected static final String m_AccessPasswd;
    protected static final String m_DriverClass;
    protected static final String m_DomainTableName;
    protected static final String m_DomainIdColumnName;
    protected static final String m_DomainNameColumnName;
    protected static final String m_DomainAuthenticationServerColumnName;
    protected static final String m_KeyStoreTableName;
    protected static final String m_KeyStoreKeyColumnName;
    protected static final String m_KeyStoreLoginColumnName;
    protected static final String m_KeyStoreDomainIdColumnName;
    protected static final String m_UserTableName;
    protected static final String m_UserIdColumnName;
    protected static final String m_UserLoginColumnName;
    protected static final String m_UserDomainColumnName;
    protected static int m_AutoInc;
    private static final String ERROR_PREFIX = "Error";
    public static final String ERROR_PWD_EXPIRED = "Error_PwdExpired";
    public static final String ERROR_PWD_MUST_BE_CHANGED = "Error_PwdMustBeChanged";
    public static final String ERROR_INCORRECT_LOGIN_PWD = "Error_1";
    public static final String ERROR_AUTHENTICATION_FAILURE = "Error_2";
    public static final String ERROR_PASSWORD_NOT_AVAILABLE = "Error_5";
    public static final String ERROR_INCORRECT_LOGIN_PWD_DOMAIN = "Error_6";

    private static Connection openConnection() throws AuthenticationException {
        Connection con;
        Driver driverSQL;
        Properties info = new Properties();
        try {
            info.setProperty("user", m_AccessLogin);
            info.setProperty("password", m_AccessPasswd);
            driverSQL = (Driver)Class.forName(m_DriverClass).newInstance();
        }
        catch (Exception iex) {
            throw new AuthenticationHostException("AuthenticationService.openConnection()", 4, "root.EX_CANT_INSTANCIATE_DB_DRIVER", "Driver=" + m_DriverClass, iex);
        }
        try {
            con = driverSQL.connect(m_JDBCUrl, info);
        }
        catch (SQLException ex) {
            throw new AuthenticationHostException("AuthenticationService.openConnection()", 4, "root.EX_CONNECTION_OPEN_FAILED", "JDBCUrl=" + m_JDBCUrl, ex);
        }
        return con;
    }

    private static void closeConnection(Connection con) {
        DBUtil.close(con);
    }

    public List<Domain> getAllDomains() {
        List<Domain> domains;
        try {
            domains = Arrays.asList(AdminReference.getAdminService().getAllDomains());
        }
        catch (AdminException e) {
            SilverTrace.error(module, "AuthenticationService", "Problem to retrieve all the domains", e);
            domains = Collections.emptyList();
        }
        return domains;
    }

    public String authenticate(AuthenticationCredential userCredential) {
        String key = null;
        if (userCredential.getLogin() != null) {
            try {
                key = userCredential.isPasswordSet() ? this.authenticateByLoginAndPasswordAndDomain(userCredential) : this.authenticateByLoginAndDomain(userCredential);
            }
            catch (AuthenticationException ex) {
                SilverTrace.error(module, "AuthenticationService.authenticate()", "authentication.EX_USER_REJECTED", "DomainId=" + userCredential.getDomainId() + ";User=" + userCredential.getLogin(), ex);
                String errorCause = ERROR_AUTHENTICATION_FAILURE;
                Exception nested = ex.getNested();
                if (nested != null && nested instanceof AuthenticationException) {
                    ex = (AuthenticationException)nested;
                }
                if (ex instanceof AuthenticationBadCredentialException) {
                    List<Domain> listDomain = this.getAllDomains();
                    errorCause = listDomain != null && listDomain.size() > 1 ? ERROR_INCORRECT_LOGIN_PWD_DOMAIN : ERROR_INCORRECT_LOGIN_PWD;
                } else if (ex instanceof AuthenticationHostException) {
                    errorCause = ERROR_AUTHENTICATION_FAILURE;
                } else if (ex instanceof AuthenticationPwdNotAvailException) {
                    errorCause = ERROR_PASSWORD_NOT_AVAILABLE;
                } else if (ex instanceof AuthenticationPasswordExpired) {
                    errorCause = ERROR_PWD_EXPIRED;
                } else if (ex instanceof AuthenticationPasswordMustBeChangedAtNextLogon) {
                    errorCause = ERROR_PWD_MUST_BE_CHANGED;
                } else if (ex instanceof AuthenticationPasswordMustBeChangedOnFirstLogin) {
                    errorCause = "Error_PwdMustBeChangedOnFirstLogin";
                } else if (ex instanceof AuthenticationUserAccountBlockedException) {
                    errorCause = "Error_UserAccountBlocked";
                } else if (ex instanceof AuthenticationUserAccountDeactivatedException) {
                    errorCause = "Error_UserAccountDeactivated";
                }
                return errorCause;
            }
        }
        return key;
    }

    public boolean isInError(String authenticationKey) {
        return StringUtil.isNotDefined(authenticationKey) || authenticationKey.startsWith(ERROR_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String authenticateByLoginAndPasswordAndDomain(AuthenticationCredential credential) throws AuthenticationException {
        String login = credential.getLogin();
        String password = credential.getPassword();
        String domainId = credential.getDomainId();
        if (login == null || password == null || domainId == null) {
            return null;
        }
        AuthenticationUserVerifierFactory.getUserCanLoginVerifier(credential).verify();
        Connection connection = null;
        try {
            connection = AuthenticationService.openConnection();
            AuthenticationServer authenticationServer = this.getAuthenticationServer(connection, domainId);
            credential.getCapabilities().put("Svp_Password_Change_Allowed", authenticationServer.isPasswordChangeAllowed() ? "yes" : "no");
            authenticationServer.authenticate(credential);
            String string = this.getAuthenticationKey(login, domainId);
            return string;
        }
        finally {
            AuthenticationService.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String authenticateByLoginAndDomain(AuthenticationCredential credential) throws AuthenticationException {
        String login = credential.getLogin();
        String domainId = credential.getDomainId();
        if (login == null || domainId == null) {
            return null;
        }
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        Connection connection = null;
        boolean authenticationOK = false;
        try {
            connection = AuthenticationService.openConnection();
            String query = "SELECT " + m_UserIdColumnName + " FROM " + m_UserTableName + " WHERE " + m_UserLoginColumnName + " = ? AND " + m_UserDomainColumnName + " = ?";
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, login);
            prepStmt.setInt(2, Integer.parseInt(domainId));
            resultSet = prepStmt.executeQuery();
            authenticationOK = resultSet.next();
            DBUtil.close(resultSet, prepStmt);
        }
        catch (Exception ex) {
            SilverTrace.warn(module, "AuthenticationService.authenticate()", "authentication.EX_USER_REJECTED", "DomainId=" + domainId + ";User=" + login, ex);
            String string = ERROR_AUTHENTICATION_FAILURE;
            return string;
        }
        finally {
            DBUtil.close(resultSet, prepStmt);
            AuthenticationService.closeConnection(connection);
        }
        AuthenticationService.closeConnection(connection);
        String key = null;
        if (authenticationOK) {
            AuthenticationUserVerifierFactory.getUserCanLoginVerifier(credential).verify();
            try {
                key = this.getAuthenticationKey(login, domainId);
            }
            catch (Exception e) {
                SilverTrace.warn(module, "AuthenticationService.authenticate()", "authentication.EX_CANT_GET_AUTHENTICATION_KEY", "DomainId=" + domainId + ";User=" + login, e);
                return ERROR_AUTHENTICATION_FAILURE;
            }
        }
        return key;
    }

    public void changePassword(AuthenticationCredential credential, String newPassword) throws AuthenticationException {
        this.changePasswordAndEmail(credential, newPassword, null);
    }

    public void changePasswordAndEmail(AuthenticationCredential credential, String newPassword, String email) throws AuthenticationException {
        String login = credential.getLogin();
        String oldPassword = credential.getPassword();
        String domainId = credential.getDomainId();
        if (login == null || oldPassword == null || domainId == null || newPassword == null) {
            throw new AuthenticationBadCredentialException("AuthenticationService.changePassword", 4, "authentication.EX_NULL_VALUE_DETECTED");
        }
        AuthenticationUserVerifierFactory.getUserCanLoginVerifier(credential).verify();
        Connection connection = null;
        try {
            connection = AuthenticationService.openConnection();
            AuthenticationServer authenticationServer = this.getAuthenticationServer(connection, domainId);
            authenticationServer.changePassword(credential, newPassword);
        }
        catch (AuthenticationException ex) {
            SilverTrace.error(module, "AuthenticationService.changePassword()", "authentication.EX_USER_REJECTED", "DomainId=" + domainId + ";User=" + login, ex);
            throw ex;
        }
        finally {
            AuthenticationService.closeConnection(connection);
        }
        this.onPasswordAndEmailChanged(credential, email);
    }

    public String getAuthenticationKey(String login, String domainId) throws AuthenticationException {
        String authKey = this.computeGenerationKey(login);
        this.storeAuthenticationKey(login, domainId, authKey);
        return authKey;
    }

    private String getAuthenticationServerName(Connection con, String domainId) throws AuthenticationException {
        ResultSet rs;
        Statement stmt;
        block6: {
            stmt = null;
            rs = null;
            String query = "SELECT " + m_DomainAuthenticationServerColumnName + " FROM " + m_DomainTableName + " WHERE " + m_DomainIdColumnName + " = " + domainId + "";
            SilverTrace.info(module, "AuthenticationService.getAuthenticationServerName()", "root.MSG_GEN_PARAM_VALUE", "query=" + query);
            stmt = con.createStatement();
            rs = stmt.executeQuery(query);
            if (!rs.next()) break block6;
            String serverName = rs.getString(m_DomainAuthenticationServerColumnName);
            if (!StringUtil.isDefined(serverName)) {
                throw new AuthenticationException("AuthenticationService.getAuthenticationServerName()", 4, "authentication.EX_SERVER_NOT_FOUND", "DomainId=" + domainId);
            }
            String string = serverName;
            DBUtil.close(rs, stmt);
            return string;
        }
        try {
            try {
                throw new AuthenticationException("AuthenticationService.getAuthenticationServerName()", 4, "authentication.EX_DOMAIN_NOT_FOUND", "DomainId=" + domainId);
            }
            catch (SQLException ex) {
                throw new AuthenticationException("AuthenticationService.getAuthenticationServerName()", 4, "authentication.EX_DOMAIN_INFO_ERROR", "DomainId=" + domainId);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
    }

    private String computeGenerationKey(String login) {
        long nStart = (long)login.hashCode() * new Date().getTime() * (long)m_AutoInc++;
        Random rand = new Random(nStart);
        int key = rand.nextInt();
        return String.valueOf(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeAuthenticationKey(String login, String domainId, String sKey) throws AuthenticationException {
        PreparedStatement stmt = null;
        String query = "INSERT INTO " + m_KeyStoreTableName + "(" + m_KeyStoreKeyColumnName + ", " + m_KeyStoreLoginColumnName + ", " + m_KeyStoreDomainIdColumnName + ")" + " VALUES (?, ?, ?)";
        Connection m_Connection = null;
        try {
            m_Connection = AuthenticationService.openConnection();
            stmt = m_Connection.prepareStatement(query);
            stmt.setInt(1, Integer.parseInt(sKey));
            stmt.setString(2, login);
            stmt.setInt(3, Integer.parseInt(domainId));
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                SilverTrace.error(module, "AuthenticationService.storeAuthenticationKey()", "authentication.EX_WRITE_KEY_ERROR", "User=" + login + " exception=" + ex.getSQLState());
            }
            catch (Throwable throwable) {
                DBUtil.close(stmt);
                AuthenticationService.closeConnection(m_Connection);
                throw throwable;
            }
            DBUtil.close(stmt);
            AuthenticationService.closeConnection(m_Connection);
        }
        DBUtil.close(stmt);
        AuthenticationService.closeConnection(m_Connection);
    }

    public void resetPassword(AuthenticationCredential credential, String newPassword) throws AuthenticationException {
        String login = credential.getLogin();
        String domainId = credential.getDomainId();
        if (login == null || domainId == null || newPassword == null) {
            throw new AuthenticationBadCredentialException("AuthenticationService.resetPassword", 4, "authentication.EX_NULL_VALUE_DETECTED");
        }
        AuthenticationUserVerifierFactory.getUserCanLoginVerifier(credential).verify();
        Connection connection = null;
        try {
            connection = AuthenticationService.openConnection();
            AuthenticationServer authenticationServer = this.getAuthenticationServer(connection, domainId);
            authenticationServer.resetPassword(login, newPassword);
        }
        catch (AuthenticationException ex) {
            SilverTrace.error(module, "AuthenticationService.resetPassword()", "authentication.EX_USER_REJECTED", "DomainId=" + domainId + ";User=" + login, ex);
            throw ex;
        }
        finally {
            AuthenticationService.closeConnection(connection);
        }
        this.onPasswordAndEmailChanged(credential, null);
    }

    private void onPasswordAndEmailChanged(AuthenticationCredential credential, String email) throws AuthenticationException {
        AdminController admin = new AdminController(null);
        UserDetail user = UserDetail.getById(admin.getUserIdByLoginAndDomain(credential.getLogin(), credential.getDomainId()));
        AuthenticationUserVerifierFactory.getUserMustChangePasswordVerifier(user).notifyPasswordChange();
        UserFull userFull = admin.getUserFull(user.getId());
        userFull.setNbSuccessfulLoginAttempts(0);
        userFull.setLastLoginCredentialUpdateDate(new Date());
        if (StringUtil.isDefined(email)) {
            userFull.seteMail(email);
        }
        try {
            admin.updateUserFull(userFull);
        }
        catch (AdminException e) {
            throw new AuthenticationException("AuthenticationService.onPasswordAndEmailChanged", 4, "authentication.EX_CANT_UPDATE_USERFULL", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPasswordChangeAllowed(String domainId) {
        Connection connection = null;
        try {
            connection = AuthenticationService.openConnection();
            AuthenticationServer authenticationServer = this.getAuthenticationServer(connection, domainId);
            boolean bl = authenticationServer.isPasswordChangeAllowed();
            return bl;
        }
        catch (AuthenticationException ex) {
            SilverTrace.error(module, "AuthenticationService.isPasswordChangeAllowed()", "authentication.EX_AUTHENTICATION_STATUS_ERROR", "DomainId=" + domainId + " exception=" + ex.getMessage());
        }
        finally {
            AuthenticationService.closeConnection(connection);
        }
        return false;
    }

    private AuthenticationServer getAuthenticationServer(Connection con, String domainId) throws AuthenticationException {
        String authenticationServerName = this.getAuthenticationServerName(con, domainId);
        return AuthenticationServer.getAuthenticationServer(authenticationServerName);
    }

    static {
        m_AutoInc = 1;
        ResourceLocator propFile = new ResourceLocator("com.stratelia.silverpeas.authentication.domains", "");
        m_JDBCUrl = propFile.getString("SQLDomainJDBCUrl");
        m_AccessLogin = propFile.getString("SQLDomainAccessLogin");
        m_AccessPasswd = propFile.getString("SQLDomainAccessPasswd");
        m_DriverClass = propFile.getString("SQLDomainDriverClass");
        m_DomainTableName = propFile.getString("SQLDomainTableName");
        m_DomainIdColumnName = propFile.getString("SQLDomainIdColumnName");
        m_DomainNameColumnName = propFile.getString("SQLDomainNameColumnName");
        m_DomainAuthenticationServerColumnName = propFile.getString("SQLDomainAuthenticationServerColumnName");
        m_KeyStoreTableName = propFile.getString("SQLKeyStoreTableName");
        m_KeyStoreKeyColumnName = propFile.getString("SQLKeyStoreKeyColumnName");
        m_KeyStoreLoginColumnName = propFile.getString("SQLKeyStoreLoginColumnName");
        m_KeyStoreDomainIdColumnName = propFile.getString("SQLKeyStoreDomainIdColumnName");
        m_UserTableName = propFile.getString("SQLUserTableName");
        m_UserIdColumnName = propFile.getString("SQLUserIdColumnName");
        m_UserLoginColumnName = propFile.getString("SQLUserLoginColumnName");
        m_UserDomainColumnName = propFile.getString("SQLUserDomainColumnName");
    }
}

