/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.file;

import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.file.AbstractSilverpeasFileProcessor;
import org.silverpeas.file.ImageCache;
import org.silverpeas.file.SilverpeasFile;
import org.silverpeas.file.SilverpeasFileProcessor;
import org.silverpeas.image.ImageTool;
import org.silverpeas.image.ImageToolDirective;
import org.silverpeas.image.option.DimensionOption;

@Named(value="imageResizingProcessor")
public class ImageResizingProcessor
extends AbstractSilverpeasFileProcessor {
    protected static final String IMAGE_CACHE_PATH = FileRepositoryManager.getAbsolutePath("cache");
    @Inject
    private ImageTool imageTool;

    @Override
    public String processBefore(String path, SilverpeasFileProcessor.ProcessingContext context) {
        String imagePath = path;
        if (context == SilverpeasFileProcessor.ProcessingContext.GETTING) {
            imagePath = this.resizeImage(path);
        }
        return imagePath;
    }

    @Override
    public SilverpeasFile processAfter(SilverpeasFile file, SilverpeasFileProcessor.ProcessingContext context) {
        if (context == SilverpeasFileProcessor.ProcessingContext.DELETION || context == SilverpeasFileProcessor.ProcessingContext.MOVING) {
            this.removeResizedImagesOf(file);
        }
        return file;
    }

    private ResizingParameters computeResizingParameters(File image) {
        ResizingParameters parameters = ResizingParameters.NO_RESIZING;
        String parent = image.getParentFile().getName();
        if (parent.contains("x")) {
            String[] size = parent.split("x");
            Integer width = null;
            Integer height = null;
            try {
                File imageSource;
                if (StringUtil.isDefined(size[0])) {
                    width = Integer.valueOf(size[0]);
                }
                if (size.length == 2) {
                    height = Integer.valueOf(size[1]);
                }
                if ((imageSource = new File(image.getParentFile().getParent() + File.separator + image.getName())).exists() && (width != null || height != null)) {
                    File imageDestination = new File(IMAGE_CACHE_PATH + parent + File.separator + imageSource.getName());
                    parameters = new ResizingParameters(imageSource, imageDestination, width, height);
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return parameters;
    }

    private void removeResizedImagesOf(File originaImage) {
        List<String> resizedImagePaths = ImageCache.getImages(originaImage.getAbsolutePath());
        for (String resizedImage : resizedImagePaths) {
            if (new File(resizedImage).delete()) continue;
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.WARNING, "The resized image {0} for the in deletion original image {1} cannot be deleted!", new String[]{resizedImage, originaImage.getAbsolutePath()});
        }
    }

    private String resizeImage(String path) {
        ResizingParameters parameters;
        File sourceImage;
        String imagePath = path;
        if (FileUtil.isImage(imagePath) && !(sourceImage = new File(imagePath)).exists() && (parameters = this.computeResizingParameters(sourceImage)).isDefined()) {
            sourceImage = parameters.getSourceImage();
            File resizedImage = parameters.getDestinationImage();
            imagePath = resizedImage.getPath();
            if (sourceImage.exists() && (!resizedImage.exists() || sourceImage.lastModified() >= resizedImage.lastModified())) {
                if (!resizedImage.getParentFile().exists()) {
                    resizedImage.getParentFile().mkdirs();
                }
                DimensionOption dimension = DimensionOption.widthAndHeight(parameters.getWidth(), parameters.getHeight());
                this.imageTool.convert(sourceImage, resizedImage, dimension, ImageToolDirective.GEOMETRY_SHRINK);
                ImageCache.putImage(sourceImage.getAbsolutePath(), resizedImage.getAbsolutePath());
            }
        }
        return imagePath;
    }

    private static class ResizingParameters {
        private static ResizingParameters NO_RESIZING = new ResizingParameters(null, null, -1, -1);
        private Integer width;
        private Integer height;
        private File sourceImage;
        private File destinationImage;

        public ResizingParameters(File sourceImage, File destinationImage, Integer width, Integer height) {
            this.height = height;
            this.width = width;
            this.sourceImage = sourceImage;
            this.destinationImage = destinationImage;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Integer getHeight() {
            return this.height;
        }

        public File getSourceImage() {
            return this.sourceImage;
        }

        public File getDestinationImage() {
            return this.destinationImage;
        }

        public boolean isDefined() {
            return this != NO_RESIZING;
        }
    }
}

