/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.mail.engine;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.text.MessageFormat;
import javax.mail.Address;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import org.silverpeas.mail.MailToSend;

public class SmtpMailSendReportListener
implements TransportListener {
    private final MailToSend mailToSend;

    public SmtpMailSendReportListener(MailToSend mailToSend) {
        this.mailToSend = mailToSend;
    }

    public void messageDelivered(TransportEvent e) {
        String logMessage = MessageFormat.format("Mail with subject ''{0}'' has been successfully delivered.", this.mailToSend.getSubject());
        SilverTrace.debug("mail", "SmtpMailSendReportListener.messageDelivered()", "root.MSG_GEN_PARAM_VALUE", logMessage);
        this.report(e);
    }

    public void messageNotDelivered(TransportEvent e) {
        String message = MessageFormat.format("Mail with subject ''{0}'' has not been delivered.", this.mailToSend.getSubject());
        SilverTrace.error("mail", "SmtpMailSendReportListener.messageDelivered()", "root.MSG_GEN_PARAM_VALUE", message);
        this.report(e);
    }

    public void messagePartiallyDelivered(TransportEvent e) {
        String message = MessageFormat.format("Mail with subject ''{0}'' has been partially delivered.", this.mailToSend.getSubject());
        SilverTrace.error("mail", "SmtpMailSendReportListener.messageDelivered()", "root.MSG_GEN_PARAM_VALUE", message);
        this.report(e);
    }

    private void report(TransportEvent e) {
        StringBuilder logMessage;
        if (e.getValidSentAddresses() != null && e.getValidSentAddresses().length > 0) {
            logMessage = new StringBuilder(1000).append(MessageFormat.format("Mail with subject ''{0}'' - delivered successfully to emails:\n", this.mailToSend.getSubject()));
            for (Address address : e.getValidSentAddresses()) {
                logMessage.append("\t").append(address).append("\n");
            }
            SilverTrace.debug("mail", "SmtpMailSendReportListener.messageDelivered()", "root.MSG_GEN_PARAM_VALUE", logMessage.toString());
        }
        if (e.getValidUnsentAddresses() != null && e.getValidUnsentAddresses().length > 0) {
            logMessage = new StringBuilder(1000).append(MessageFormat.format("Mail with subject ''{0}'' - has not been delivered to emails:\n", this.mailToSend.getSubject()));
            for (Address address : e.getValidUnsentAddresses()) {
                logMessage.append("\t").append(address).append("\n");
            }
            SilverTrace.error("mail", "SmtpMailSendReportListener.messageDelivered()", "root.MSG_GEN_PARAM_VALUE", logMessage.toString());
        }
        if (e.getInvalidAddresses() != null && e.getInvalidAddresses().length > 0) {
            logMessage = new StringBuilder(1000).append(MessageFormat.format("Mail with subject ''{0}'' - has not been delivered to emails:\n", this.mailToSend.getSubject()));
            for (Address address : e.getInvalidAddresses()) {
                logMessage.append("\t").append(address).append("\n");
            }
            SilverTrace.error("mail", "SmtpMailSendReportListener.messageDelivered()", "root.MSG_GEN_PARAM_VALUE", logMessage.toString());
        }
    }
}

