/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.password.rule;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.silverpeas.password.constant.PasswordRuleType;
import org.silverpeas.password.rule.PasswordRule;

public abstract class AbstractPasswordRule
implements PasswordRule {
    protected static final int DEFAULT_LENGTH = 8;
    protected static ResourceLocator settings = new ResourceLocator("org.silverpeas.password.settings.password", "");
    private static final Map<String, ResourceLocator> multilang = new HashMap<String, ResourceLocator>();
    private PasswordRuleType passwordRuleType;

    protected AbstractPasswordRule(PasswordRuleType passwordRuleType) {
        this.passwordRuleType = passwordRuleType;
    }

    @Override
    public PasswordRuleType getType() {
        return this.passwordRuleType;
    }

    @Override
    public String getDescription(String language) {
        Object value = this.getValue();
        return this.getString(this.getType().getBundleKey(), language, value instanceof Boolean ? null : String.valueOf(value));
    }

    @Override
    public boolean isRequired() {
        Object value = this.getValue();
        if (value instanceof String) {
            return StringUtil.isDefined((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() > 0.0;
        }
        return value != null;
    }

    @Override
    public boolean isCombined() {
        return false;
    }

    protected int random(int maxValue) {
        return (int)((double)maxValue * Math.random());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getString(String key, String language, String ... params) {
        ResourceLocator messages = multilang.get(language);
        if (messages == null) {
            Map<String, ResourceLocator> map = multilang;
            synchronized (map) {
                messages = new ResourceLocator("org.silverpeas.password.multilang.passwordBundle", language);
                multilang.put(language, messages);
            }
        }
        return params != null && params.length > 0 ? messages.getStringWithParams(key, params) : messages.getString(key, "");
    }

    protected Integer getIntegerFromSettings(String key, Integer defaultValue) {
        Integer value = 0;
        try {
            value = settings.getInteger(key, 0);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return value >= 0 ? value : 0;
    }

    protected int countRegexOccur(String text, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(text);
        int occur = 0;
        while (matcher.find()) {
            ++occur;
        }
        return occur;
    }
}

