/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.persistence.repository.jpa;

import com.silverpeas.util.CollectionUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.silverpeas.persistence.repository.Parameters;
import org.silverpeas.persistence.repository.jpa.DateCollectionNamedParameter;
import org.silverpeas.persistence.repository.jpa.DateNamedParameter;
import org.silverpeas.persistence.repository.jpa.EnumCollectionNamedParameter;
import org.silverpeas.persistence.repository.jpa.EnumNamedParameter;
import org.silverpeas.persistence.repository.jpa.NamedParameter;
import org.silverpeas.persistence.repository.jpa.ObjectNamedParameter;

public class NamedParameters
implements Parameters {
    private String lastParameterName;
    final Map<String, NamedParameter<?, ?>> namedParameters = new LinkedHashMap();

    NamedParameters() {
    }

    public String getLastParameterName() {
        return this.lastParameterName;
    }

    @Override
    public NamedParameters add(String name, Object value) {
        return this.add(name, value, null);
    }

    public NamedParameters add(String name, Object value, TemporalType temporalType) {
        if (value instanceof Object[] && ((Object[])value)[0] instanceof Date && temporalType != null) {
            this.namedParameters.put(name, new DateCollectionNamedParameter(name, CollectionUtil.asSet((Date[])value), temporalType));
        } else if (value instanceof Collection && ((Collection)value).iterator().next() instanceof Date && temporalType != null) {
            this.namedParameters.put(name, new DateCollectionNamedParameter(name, (Set<Date>)new HashSet<Date>((Collection)value), temporalType));
        } else if (value instanceof Date && temporalType != null) {
            this.namedParameters.put(name, new DateNamedParameter(name, (Date)value, temporalType));
        } else if (value instanceof Object[] && ((Object[])value)[0] instanceof Enum) {
            this.namedParameters.put(name, new EnumCollectionNamedParameter(name, CollectionUtil.asSet((Enum[])value)));
        } else if (value instanceof Collection && ((Collection)value).iterator().next() instanceof Enum) {
            this.namedParameters.put(name, new EnumCollectionNamedParameter(name, new HashSet<Enum>((Collection)value)));
        } else if (value instanceof Enum) {
            this.namedParameters.put(name, new EnumNamedParameter(name, (Enum)value));
        } else {
            this.namedParameters.put(name, new ObjectNamedParameter(name, value));
        }
        this.lastParameterName = name;
        return this;
    }

    public <E extends Query> E applyTo(E query) {
        for (NamedParameter<?, ?> namedParameter : this.namedParameters.values()) {
            if (namedParameter instanceof DateNamedParameter) {
                DateNamedParameter dateParameter = (DateNamedParameter)namedParameter;
                query.setParameter(dateParameter.getName(), (Date)dateParameter.getValue(), dateParameter.getTemporalType());
                continue;
            }
            query.setParameter(namedParameter.getName(), namedParameter.getValue());
        }
        return query;
    }
}

