/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.process.io.file;

import com.silverpeas.util.MapUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.silverpeas.process.io.IOAccess;
import org.silverpeas.process.io.file.DummyHandledFile;
import org.silverpeas.process.io.file.FileBasePath;
import org.silverpeas.process.io.file.exception.FileHandlerException;
import org.silverpeas.process.session.ProcessSession;

public abstract class AbstractFileHandler {
    private static final Set<FileBasePath> handledBasePath = new HashSet<FileBasePath>();
    private final String SESSION_TEMP_NODE = "@#@work@#@";
    private final File sessionRootPath = new File(FileRepositoryManager.getTemporaryPath());
    private final ProcessSession session;
    private final Map<FileBasePath, Set<File>> toDelete = new HashMap<FileBasePath, Set<File>>();
    private final Map<String, Set<DummyHandledFile>> dummyHandledFiles = new HashMap<String, Set<DummyHandledFile>>();
    private IOAccess ioAccess = IOAccess.READ_ONLY;

    protected AbstractFileHandler(ProcessSession session) {
        this.session = session;
    }

    private ProcessSession getSession() {
        return this.session;
    }

    protected boolean markToDelete(FileBasePath basePath, File file) throws Exception {
        if (this.isHandledPath(basePath) && (file = this.translateToRealPath(basePath, file)).exists()) {
            if (this.getIoAccess().equals((Object)IOAccess.READ_ONLY)) {
                this.setIoAccess(IOAccess.DELETE_ONLY);
            }
            Set<File> filesMarkedToBeDeleted = this.getMarkedToDelete(basePath);
            boolean markedToDelete = false;
            if (file.isFile()) {
                boolean addOk = true;
                for (File curFile : filesMarkedToBeDeleted) {
                    if (!curFile.isDirectory() || !FileUtils.directoryContains((File)curFile, (File)file)) continue;
                    addOk = false;
                    break;
                }
                if (addOk) {
                    markedToDelete = filesMarkedToBeDeleted.add(file);
                }
            } else {
                Iterator<File> it = filesMarkedToBeDeleted.iterator();
                while (it.hasNext()) {
                    File curFile = it.next();
                    if (!FileUtils.directoryContains((File)file, (File)curFile)) continue;
                    it.remove();
                }
                markedToDelete = filesMarkedToBeDeleted.add(file);
            }
            return markedToDelete;
        }
        return false;
    }

    protected boolean isMarkedToDelete(FileBasePath basePath, File file) {
        if (this.isHandledPath(basePath)) {
            file = this.translateToRealPath(basePath, file);
            for (File fileToDelete : this.getMarkedToDelete(basePath)) {
                if (!file.getPath().startsWith(fileToDelete.getPath())) continue;
                return true;
            }
        }
        return false;
    }

    Set<File> getMarkedToDelete(FileBasePath basePath) {
        Set<File> toDeleteContainer = this.toDelete.get((Object)basePath);
        if (toDeleteContainer == null) {
            toDeleteContainer = new HashSet<File>();
            this.toDelete.put(basePath, toDeleteContainer);
        }
        return toDeleteContainer;
    }

    protected File translateToRealPath(FileBasePath basePath, File file) {
        if (this.isHandledPath(basePath)) {
            File sessionPath = this.getSessionPath(basePath);
            if (file.getPath().startsWith(sessionPath.getPath())) {
                String endOfFileName = file.getPath().substring(sessionPath.getPath().length());
                file = new File(basePath.getPath() + endOfFileName);
            }
        }
        return file;
    }

    protected File translateToSessionPath(FileBasePath basePath, File file) {
        if (this.isHandledPath(basePath) && file.getPath().startsWith(basePath.getPath())) {
            String endOfFileName = file.getPath().substring(basePath.getPath().length());
            file = new File(this.getSessionPath(basePath).getPath() + endOfFileName);
        }
        return file;
    }

    protected File getExistingFile(FileBasePath basePath, File file) {
        File sessionFile = this.translateToSessionPath(basePath, file);
        File realFile = this.translateToRealPath(basePath, file);
        return !sessionFile.exists() && realFile.exists() && !this.isMarkedToDelete(basePath, realFile) ? realFile : sessionFile;
    }

    protected File getFileForWriting(FileBasePath basePath, File file) throws Exception {
        return this.getFileForWriting(basePath, file, false);
    }

    protected File getFileForWriting(FileBasePath basePath, File file, boolean append) throws Exception {
        File realFile;
        File sessionFile = this.translateToSessionPath(basePath, file);
        if (append && !this.isMarkedToDelete(basePath, file) && (realFile = this.translateToRealPath(basePath, file)).exists()) {
            FileUtils.copyFile((File)realFile, (File)sessionFile);
        }
        this.markToDelete(basePath, file);
        this.setIoAccess(IOAccess.READ_WRITE);
        return sessionFile;
    }

    File getSessionPath(FileBasePath basePath) {
        if (!this.isHandledPath(basePath)) {
            throw new FileHandlerException("EX_GETTING_SESSION_PATH_IS_NOT_POSSIBLE");
        }
        return FileUtils.getFile((File)this.sessionRootPath, (String[])new String[]{this.getSession().getId(), basePath.getHandledNodeName()});
    }

    File getSessionTemporaryPath() {
        return FileUtils.getFile((File)this.sessionRootPath, (String[])new String[]{this.getSession().getId(), "@#@work@#@"});
    }

    public long sizeOfSessionWorkingPath(String ... relativeRootPath) {
        long size = 0L;
        for (FileBasePath basePath : handledBasePath) {
            size += this.sizeOfSessionWorkingPath(basePath, relativeRootPath);
        }
        HashSet<String> componentInstanceIds = new HashSet<String>();
        if (relativeRootPath != null) {
            Collections.addAll(componentInstanceIds, relativeRootPath);
        }
        if (componentInstanceIds.isEmpty()) {
            componentInstanceIds.addAll(this.dummyHandledFiles.keySet());
        }
        for (String componentInstanceId : componentInstanceIds) {
            Set<DummyHandledFile> dummyHandledFilesOfCurrentComponentInstanceId = this.dummyHandledFiles.get(componentInstanceId);
            if (dummyHandledFilesOfCurrentComponentInstanceId == null) continue;
            for (DummyHandledFile dummyHandledFile : dummyHandledFilesOfCurrentComponentInstanceId) {
                if (dummyHandledFile.isDeleted()) {
                    size -= dummyHandledFile.getSize();
                    continue;
                }
                size += dummyHandledFile.getSize();
            }
        }
        return size;
    }

    protected long sizeOfSessionWorkingPath(FileBasePath basePath, String ... relativeRootPath) {
        File rootPath;
        ArrayList<String> rootPathParts = new ArrayList<String>();
        rootPathParts.add(this.getSession().getId());
        rootPathParts.add(basePath.getHandledNodeName());
        if (relativeRootPath != null) {
            rootPathParts.addAll(Arrays.asList(relativeRootPath));
        }
        long size = (rootPath = FileUtils.getFile((File)this.sessionRootPath, (String[])rootPathParts.toArray(new String[rootPathParts.size()]))).exists() ? FileUtils.sizeOf((File)rootPath) : 0L;
        String realRootPath = this.translateToRealPath(basePath, rootPath).getPath();
        for (Map.Entry<FileBasePath, Set<File>> entry : this.toDelete.entrySet()) {
            for (File fileToDelete : entry.getValue()) {
                if (!fileToDelete.getPath().startsWith(realRootPath) || !fileToDelete.exists()) continue;
                size -= FileUtils.sizeOf((File)fileToDelete);
            }
        }
        return size;
    }

    public Collection<String> getSessionHandledRootPathNames() {
        return this.getSessionHandledRootPathNames(false);
    }

    public Collection<String> getSessionHandledRootPathNames(boolean skipDeleted) {
        HashSet<String> rootPathNames = new HashSet<String>();
        for (FileBasePath basePath : handledBasePath) {
            rootPathNames.addAll(this.getSessionHandledRootPathNames(basePath, skipDeleted));
        }
        rootPathNames.addAll(this.dummyHandledFiles.keySet());
        return rootPathNames;
    }

    protected Collection<String> getSessionHandledRootPathNames(FileBasePath basePath, boolean skipDeleted) {
        HashSet<String> rootPathNames = new HashSet<String>();
        if (this.isHandledPath(basePath)) {
            String[] directories = this.getSessionPath(basePath).list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
            if (directories != null) {
                rootPathNames.addAll(Arrays.asList(directories));
            }
            if (!skipDeleted) {
                for (File deleted : this.getMarkedToDelete(basePath)) {
                    String[] deletedFileNameParts;
                    if (!deleted.getPath().startsWith(basePath.getPath()) || (deletedFileNameParts = FilenameUtils.separatorsToUnix((String)deleted.getPath().substring(basePath.getPath().length())).replaceAll("^/", "").split("/")) == null || deletedFileNameParts.length <= 0) continue;
                    rootPathNames.add(deletedFileNameParts[0]);
                }
            }
            rootPathNames.remove("@#@work@#@");
            rootPathNames.remove(null);
            rootPathNames.remove("");
        }
        return rootPathNames;
    }

    public Collection<File> listAllSessionHandledRootPathFiles() {
        HashSet<File> rootPathFiles = new HashSet<File>();
        for (FileBasePath basePath : handledBasePath) {
            rootPathFiles.addAll(this.listAllSessionHandledRootPathFiles(basePath));
        }
        return rootPathFiles;
    }

    protected Collection<File> listAllSessionHandledRootPathFiles(FileBasePath basePath) {
        File[] directories;
        HashSet<File> rootPathNames = new HashSet<File>();
        if (this.isHandledPath(basePath) && (directories = this.getSessionPath(basePath).listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) != null) {
            rootPathNames.addAll(Arrays.asList(directories));
        }
        return rootPathNames;
    }

    protected void deleteSessionWorkingPath() {
        FileUtils.deleteQuietly((File)FileUtils.getFile((File)this.sessionRootPath, (String[])new String[]{this.getSession().getId()}));
        this.toDelete.clear();
    }

    protected void checkinSessionWorkingPath() throws Exception {
        File[] files;
        for (Map.Entry<FileBasePath, Set<File>> entry : this.toDelete.entrySet()) {
            for (File fileToDelete : entry.getValue()) {
                if (!fileToDelete.exists()) continue;
                FileUtils.deleteQuietly((File)fileToDelete);
            }
        }
        this.toDelete.clear();
        for (FileBasePath basePath : handledBasePath) {
            this.copyFiles(basePath, this.getSessionPath(basePath));
        }
        File sessionPath = FileUtils.getFile((File)this.sessionRootPath, (String[])new String[]{this.getSession().getId()});
        if (sessionPath.exists() && (files = sessionPath.listFiles()) != null) {
            for (File file : files) {
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    private void copyFiles(FileBasePath basePath, File file) throws IOException {
        if (file.exists()) {
            File currentFile;
            LinkedList<File> fifo = new LinkedList<File>();
            fifo.add(file);
            while ((currentFile = (File)fifo.poll()) != null) {
                if (currentFile.isDirectory()) {
                    File[] files = currentFile.listFiles();
                    if (files == null) continue;
                    Collections.addAll(fifo, files);
                    continue;
                }
                FileUtils.copyFile((File)currentFile, (File)this.translateToRealPath(basePath, currentFile));
            }
        }
    }

    protected void verify(FileBasePath basePath, File file) {
        this.verify(basePath, file, false);
    }

    protected void verify(FileBasePath basePath, File file, boolean isReadOnly) {
        if (basePath == null || !isReadOnly && this.isHandledPath(basePath)) {
            if (basePath != null && (file.getPath().startsWith(this.getSessionPath(basePath).getPath()) || file.getPath().startsWith(basePath.getPath()))) {
                return;
            }
            throw new FileHandlerException("EX_VERIFY_ERROR");
        }
    }

    protected static boolean exists(File file) {
        return file.exists();
    }

    protected boolean isHandledPath(FileBasePath basePath) {
        return handledBasePath.contains((Object)basePath);
    }

    public IOAccess getIoAccess() {
        return this.ioAccess;
    }

    private void setIoAccess(IOAccess ioAccess) {
        this.ioAccess = ioAccess;
    }

    public void addDummyHandledFile(DummyHandledFile dummyHandledFile) {
        this.setIoAccess(IOAccess.READ_WRITE);
        MapUtil.putAddSet(this.dummyHandledFiles, dummyHandledFile.getComponentInstanceId(), dummyHandledFile);
    }

    public void removeDummyHandledFile(DummyHandledFile dummyHandledFile) {
        MapUtil.removeValueSet(this.dummyHandledFiles, dummyHandledFile.getComponentInstanceId(), dummyHandledFile);
    }

    public Set<DummyHandledFile> getDummyHandledFiles(String componentInstanceId) {
        Set result = this.dummyHandledFiles.get(componentInstanceId);
        if (result == null) {
            result = Collections.EMPTY_SET;
        }
        return result;
    }

    static {
        handledBasePath.add(FileBasePath.UPLOAD_PATH);
    }
}

