/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.silverpeas.search.indexEngine.model.IndexEntryPK;

public class IndexEntry
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4817004188601716658L;
    private IndexEntryPK pk;
    private String lang = null;
    private String creationDate = null;
    private String creationUser = null;
    private String lastModificationDate = null;
    private String lastModificationUser = null;
    private String startDate = null;
    private String endDate = null;
    private boolean indexId = false;
    private String thumbnail = null;
    private String thumbnailMimeType = null;
    private String thumbnailDirectory = null;
    private Map<String, String> titles = null;
    private Map<String, String> previews = null;
    private Map<String, String> keywordsI18N = null;
    private String serverName = null;
    private String filename = null;
    private List<String> paths = null;
    private boolean alias = false;
    public static final String STARTDATE_DEFAULT = "0000/00/00";
    public static final String ENDDATE_DEFAULT = "9999/99/99";

    public IndexEntry(WAPrimaryKey key) {
        this(new IndexEntryPK(key.componentName, "", key.id));
    }

    public IndexEntry(WAPrimaryKey key, String type) {
        this(new IndexEntryPK(key.componentName, type, key.id));
    }

    public IndexEntry(String space, String component, String objectType, String objectId) {
        this(new IndexEntryPK(space, component, objectType, objectId));
    }

    public IndexEntry(String component, String objectType, String objectId) {
        this(new IndexEntryPK(component, objectType, objectId));
    }

    public IndexEntry(IndexEntryPK pk) {
        this.pk = pk;
    }

    public String toString() {
        return this.pk == null ? "" : this.pk.toString();
    }

    public IndexEntryPK getPK() {
        return this.pk;
    }

    public String getComponent() {
        return this.pk.getComponent();
    }

    public String getObjectType() {
        return this.pk.getObjectType();
    }

    public String getObjectId() {
        return this.pk.getObjectId();
    }

    public void setTitle(String title) {
        this.setTitle(title, null);
    }

    public void setTitle(String title, String lang) {
        if (title != null) {
            this.getTitles().put(I18NHelper.checkLanguage(lang), title);
        }
    }

    public String getTitle() {
        if (this.getTitle(null) != null) {
            return this.getTitle(null);
        }
        return "";
    }

    public String getTitle(String lang) {
        String title = this.getTitles().get(I18NHelper.checkLanguage(lang));
        if (!StringUtil.isDefined(title)) {
            Set<String> languages = I18NHelper.getAllSupportedLanguages();
            for (String language : languages) {
                title = this.getTitles().get(language);
                if (!StringUtil.isDefined(title)) continue;
                return title;
            }
        }
        return title;
    }

    public void setKeyWords(String keywords) {
        this.setKeywords(keywords, null);
    }

    public void setKeywords(String keywords, String lang) {
        if (keywords != null) {
            this.getKeywords().put(I18NHelper.checkLanguage(lang), keywords);
        }
    }

    public String getKeyWords() {
        if (this.getKeywords(null) != null) {
            return this.getKeywords(null);
        }
        return "";
    }

    public String getKeywords(String lang) {
        String keywords = this.getKeywords().get(I18NHelper.checkLanguage(lang));
        if (!StringUtil.isDefined(keywords)) {
            Set<String> languages = I18NHelper.getAllSupportedLanguages();
            for (String language : languages) {
                keywords = this.getKeywords().get(language);
                if (!StringUtil.isDefined(keywords)) continue;
                return keywords;
            }
        }
        return keywords;
    }

    public void setPreView(String preview) {
        this.setPreview(preview, null);
    }

    public void setPreview(String preview, String lang) {
        if (preview != null) {
            this.getPreviews().put(I18NHelper.checkLanguage(lang), preview);
        }
    }

    public String getPreView() {
        if (this.getPreview(null) != null) {
            return this.getPreview(null);
        }
        return "";
    }

    public String getPreview(String lang) {
        String preview = this.getPreviews().get(I18NHelper.checkLanguage(lang));
        if (!StringUtil.isDefined(preview)) {
            Set<String> languages = I18NHelper.getAllSupportedLanguages();
            for (String language : languages) {
                preview = this.getPreviews().get(language);
                if (!StringUtil.isDefined(preview)) continue;
                return preview;
            }
        }
        return preview;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getLang() {
        if (this.lang != null) {
            return this.lang;
        }
        return "";
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = DateUtil.date2SQLDate(creationDate);
    }

    public String getCreationDate() {
        if (this.creationDate != null) {
            return this.creationDate;
        }
        return DateUtil.date2SQLDate(new Date());
    }

    public void setCreationUser(String creationUser) {
        this.creationUser = creationUser;
    }

    public String getCreationUser() {
        if (this.creationUser != null) {
            return this.creationUser;
        }
        return "";
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getStartDate() {
        if (this.startDate != null) {
            return this.startDate;
        }
        return STARTDATE_DEFAULT;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getEndDate() {
        if (this.endDate != null) {
            return this.endDate;
        }
        return ENDDATE_DEFAULT;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexEntry) {
            IndexEntry e = (IndexEntry)o;
            return this.getPK().equals(e.getPK());
        }
        return false;
    }

    public int hashCode() {
        return this.getPK().hashCode();
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getThumbnailDirectory() {
        return this.thumbnailDirectory;
    }

    public void setThumbnailDirectory(String thumbnailDirectory) {
        this.thumbnailDirectory = thumbnailDirectory;
    }

    public String getThumbnailMimeType() {
        return this.thumbnailMimeType;
    }

    public void setThumbnailMimeType(String thumbnailMimeType) {
        this.thumbnailMimeType = thumbnailMimeType;
    }

    private Map<String, String> getTitles() {
        if (this.titles == null) {
            this.titles = new HashMap<String, String>();
        }
        return this.titles;
    }

    private Map<String, String> getPreviews() {
        if (this.previews == null) {
            this.previews = new HashMap<String, String>();
        }
        return this.previews;
    }

    private Map<String, String> getKeywords() {
        if (this.keywordsI18N == null) {
            this.keywordsI18N = new HashMap<String, String>();
        }
        return this.keywordsI18N;
    }

    public Iterator<String> getLanguages() {
        return this.getTitles().keySet().iterator();
    }

    public boolean isIndexId() {
        return this.indexId;
    }

    public void setIndexId(boolean indexId) {
        this.indexId = indexId;
    }

    public String getLastModificationDate() {
        if (!StringUtil.isDefined(this.lastModificationDate)) {
            return this.getCreationDate();
        }
        return this.lastModificationDate;
    }

    public void setLastModificationDate(String lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
    }

    public void setLastModificationDate(Date lastModificationDate) {
        this.lastModificationDate = DateUtil.date2SQLDate(lastModificationDate);
    }

    public String getLastModificationUser() {
        if (!StringUtil.isDefined(this.lastModificationUser)) {
            return this.getCreationUser();
        }
        return this.lastModificationUser;
    }

    public void setLastModificationUser(String lastModificationUser) {
        this.lastModificationUser = lastModificationUser;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPK(IndexEntryPK pk) {
        this.pk = pk;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    public IndexEntry clone() {
        IndexEntry clone;
        try {
            clone = (IndexEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            clone = null;
        }
        return clone;
    }
}

