/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.apache.lucene.analysis.ASCIIFoldingFilter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fr.ElisionFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.util.Version;
import org.silverpeas.search.indexEngine.analysis.SilverTokenizer;

public final class WAAnalyzer
extends Analyzer {
    private static final Map<String, Analyzer> languageMap = new HashMap<String, Analyzer>();
    private static final ResourceLocator settings = new ResourceLocator("org.silverpeas.util.indexEngine.IndexEngine", "");
    private String stemmer = null;
    private boolean snowballUsed = false;
    private String language = null;
    private Set<String> stopWords = null;

    public static Analyzer getAnalyzer(String language) {
        Analyzer analyzer = languageMap.get(language);
        if (analyzer == null) {
            analyzer = new WAAnalyzer(language);
            languageMap.put(language, analyzer);
        }
        return analyzer;
    }

    public TokenStream tokenStream(Reader reader) {
        SilverTokenizer result = new SilverTokenizer(reader);
        result = new StandardFilter(Version.LUCENE_36, (TokenStream)result);
        result = new LowerCaseFilter(Version.LUCENE_36, (TokenStream)result);
        result = new StopFilter(Version.LUCENE_36, (TokenStream)result, this.stopWords);
        result = new ElisionFilter(Version.LUCENE_36, (TokenStream)result);
        if (this.snowballUsed) {
            result = new SnowballFilter((TokenStream)result, this.stemmer);
        }
        result = new ASCIIFoldingFilter((TokenStream)result);
        return result;
    }

    public TokenStream tokenStream(String arg0, Reader reader) {
        return this.tokenStream(reader);
    }

    private WAAnalyzer(String lang) {
        this.language = !StringUtil.isDefined(lang) || lang.length() != 2 ? settings.getString("analyzer.language.default", "fr") : lang;
        this.getStopWords(this.language);
        this.stemmer = this.getStemmer();
        this.snowballUsed = settings.getBoolean("snowball.active", false);
    }

    private void getStopWords(String language) {
        this.stopWords = new HashSet<String>();
        String currentLanguage = language;
        try {
            if (!StringUtil.isDefined(currentLanguage)) {
                currentLanguage = I18NHelper.defaultLanguage;
            }
            ResourceLocator resource = new ResourceLocator("org.silverpeas.search.indexEngine.StopWords", currentLanguage);
            Enumeration<String> stopWord = resource.getKeys();
            while (stopWord.hasMoreElements()) {
                this.stopWords.add(stopWord.nextElement());
            }
        }
        catch (MissingResourceException e) {
            SilverTrace.warn("indexEngine", "WAAnalyzer", "indexEngine.MSG_MISSING_STOPWORDS_DEFINITION");
        }
    }

    private String getStemmer() {
        return settings.getString("snowball.stemmer." + this.language, "French");
    }

    public String getLanguage() {
        return this.language;
    }
}

