/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.parser.excelParser;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.silverpeas.search.indexEngine.parser.PipedParser;

public class ExcelParser
extends PipedParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outPutContent(Writer out, String path, String encoding) throws IOException {
        FileInputStream file = new FileInputStream(path);
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)file);
            HSSFWorkbook workbook = new HSSFWorkbook(fs);
            HSSFSheet sheet = null;
            for (int nbSheet = 0; nbSheet < workbook.getNumberOfSheets(); ++nbSheet) {
                out.write(workbook.getSheetName(nbSheet));
                SilverTrace.debug("indexEngine", "ExcelParser.outputContent", "root.MSG_GEN_PARAM_VALUE", "sheetName = " + workbook.getSheetName(nbSheet));
                sheet = workbook.getSheetAt(nbSheet);
                Iterator rows = sheet.rowIterator();
                while (rows.hasNext()) {
                    Row row = (Row)rows.next();
                    Iterator cells = row.cellIterator();
                    while (cells.hasNext()) {
                        Cell cell = (Cell)cells.next();
                        if (cell.getCellType() != 1) continue;
                        out.write(cell.getStringCellValue());
                        out.write(32);
                        SilverTrace.debug("indexEngine", "ExcelParser.outputContent", "root.MSG_GEN_PARAM_VALUE", "cellValue = " + cell.getStringCellValue());
                    }
                }
            }
        }
        catch (IOException ioe) {
            SilverTrace.error("indexEngine", "ExcelParser.outPutContent()", "indexEngine.MSG_IO_ERROR_WHILE_READING", path, ioe);
        }
        finally {
            IOUtils.closeQuietly((InputStream)file);
        }
    }
}

