/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.termsOfService.constant;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.DateUtil;
import java.util.Date;
import org.silverpeas.date.Period;
import org.silverpeas.date.PeriodType;

public enum TermsOfServiceAcceptanceFrequency {
    NEVER(null),
    ONE(null),
    DAILY(PeriodType.day),
    WEEKLY(PeriodType.week),
    MONTHLY(PeriodType.month),
    YEARLY(PeriodType.year),
    ALWAYS(null);

    private PeriodType periodeType;

    private TermsOfServiceAcceptanceFrequency(PeriodType periodeType) {
        this.periodeType = periodeType;
    }

    public boolean isActivated() {
        return this != NEVER;
    }

    public boolean isAcceptanceDateExpired(Date tosAcceptanceDate, String locale) {
        return this.isAcceptanceDateExpired(DateUtil.getNow(), tosAcceptanceDate, locale);
    }

    protected boolean isAcceptanceDateExpired(Date referenceDate, Date tosAcceptanceDate, String locale) {
        switch (this) {
            case NEVER: {
                return false;
            }
            case ALWAYS: {
                return true;
            }
            case ONE: {
                if (tosAcceptanceDate == null) break;
                return false;
            }
            default: {
                if (tosAcceptanceDate == null) break;
                Period validPeriod = Period.from(referenceDate, this.periodeType, locale);
                return !validPeriod.contains(tosAcceptanceDate);
            }
        }
        return true;
    }

    public static TermsOfServiceAcceptanceFrequency decode(String tosAcceptanceFrequency) {
        if (StringUtil.isDefined(tosAcceptanceFrequency)) {
            for (TermsOfServiceAcceptanceFrequency current : TermsOfServiceAcceptanceFrequency.values()) {
                if (!current.name().equalsIgnoreCase(tosAcceptanceFrequency)) continue;
                return current;
            }
        }
        return NEVER;
    }
}

