/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.upload;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.upload.UploadSession;

public class UploadSessionFile {
    private UploadSession uploadSession;
    private String fullPath;
    private File serverFile;

    UploadSessionFile(UploadSession uploadSession, String fullPath, File serverFile) {
        this.uploadSession = uploadSession;
        this.fullPath = fullPath;
        this.serverFile = serverFile;
    }

    public UploadSession getUploadSession() {
        return this.uploadSession;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public File getServerFile() {
        return this.serverFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream uploadedInputStream) throws IOException {
        this.getUploadSession().markFileWritingInProgress(this);
        try {
            FileOutputStream fOS = FileUtils.openOutputStream((File)this.getServerFile());
            try {
                IOUtils.copy((InputStream)uploadedInputStream, (OutputStream)fOS);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fOS);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)uploadedInputStream);
            this.getUploadSession().markFileWritingDone(this);
        }
    }
}

