/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util;

import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.silverpeas.util.FileUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PdfUtil {
    public static void stamp(File pdfSource, File stampImage, File pdfDestination) {
        PdfUtil.addImageOnEachPage(pdfSource, stampImage, pdfDestination, false);
    }

    public static void stamp(InputStream pdfSource, File stampImage, OutputStream pdfDestination) {
        PdfUtil.addImageOnEachPage(pdfSource, stampImage, pdfDestination, false);
    }

    public static void watermark(File pdfSource, File watermarkImage, File pdfDestination) {
        PdfUtil.addImageOnEachPage(pdfSource, watermarkImage, pdfDestination, true);
    }

    public static void watermark(InputStream pdfSource, File watermarkImage, OutputStream pdfDestination) {
        PdfUtil.addImageOnEachPage(pdfSource, watermarkImage, pdfDestination, true);
    }

    private static void addImageOnEachPage(File pdfSource, File image, File pdfDestination, boolean isBackground) {
        if (pdfSource == null || !pdfSource.isFile()) {
            throw new RuntimeException("The pdf source file doesn't exist");
        }
        if (!FileUtil.isPdf(pdfSource.getPath())) {
            throw new RuntimeException("The source is not a pdf file");
        }
        if (pdfDestination == null) {
            throw new RuntimeException("The pdf destination file is unknown");
        }
        FileInputStream pdfSourceIS = null;
        FileOutputStream pdfDestinationIS = null;
        try {
            pdfSourceIS = FileUtils.openInputStream((File)pdfSource);
            pdfDestinationIS = FileUtils.openOutputStream((File)pdfDestination);
            PdfUtil.addImageOnEachPage(pdfSourceIS, image, pdfDestinationIS, isBackground);
        }
        catch (IOException e) {
            throw new RuntimeException("Pdf source file cannot be opened or pdf destination file cannot be created", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)pdfSourceIS);
            IOUtils.closeQuietly((OutputStream)pdfDestinationIS);
        }
    }

    private static void addImageOnEachPage(InputStream pdfSource, File imageToAdd, OutputStream pdfDestination, boolean isBackground) {
        if (imageToAdd == null || !imageToAdd.isFile()) {
            throw new RuntimeException("The image file doesn't exist");
        }
        if (!FileUtil.isImage(imageToAdd.getPath())) {
            throw new RuntimeException("The picture to add is not an image file");
        }
        PdfReader reader = null;
        try {
            reader = new PdfReader(pdfSource);
            int pdfNbPages = reader.getNumberOfPages();
            PdfStamper stamper = new PdfStamper(reader, pdfDestination);
            Image image = Image.getInstance((String)imageToAdd.getPath());
            float imageWidth = image.getWidth();
            float imageHeigth = image.getHeight();
            for (int i = 1; i <= pdfNbPages; ++i) {
                Rectangle rectangle = reader.getPageSize(i);
                float scale = Math.min(100.0f, rectangle.getWidth() / imageWidth * 100.0f);
                image.scalePercent(Math.min(scale, rectangle.getHeight() / imageHeigth * 100.0f));
                image.setAbsolutePosition(PdfUtil.computeImageCenterPosition(rectangle.getWidth(), image.getScaledWidth()), PdfUtil.computeImageCenterPosition(rectangle.getHeight(), image.getScaledHeight()));
                PdfContentByte imageContainer = isBackground ? stamper.getUnderContent(i) : stamper.getOverContent(i);
                imageContainer.addImage(image);
            }
            stamper.close();
        }
        catch (Exception e) {
            SilverTrace.error("util", "PdfUtil.stamp", "EX_ERROR_PDF_ADD_WATERWARK", e);
            throw new RuntimeException("A problem has occured during the adding of an image into a pdf file", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static float computeImageCenterPosition(float documentSize, float imageSize) {
        float differenceSize = documentSize - imageSize;
        return differenceSize / 2.0f;
    }
}

