/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.silverpeas.util.BiFunction;
import org.silverpeas.util.Function;

public class PrefixedNotationExpressionEngine<R> {
    private final Function<String, R> converter;
    private final Map<String, OperatorFunction<R>> operatorFunctions = new HashMap<String, OperatorFunction<R>>();
    private final Pattern operandPattern;

    public static <R> PrefixedNotationExpressionEngine<R> from(Function<String, R> converter, OperatorFunction<R> ... operationFunctions) {
        return new PrefixedNotationExpressionEngine<R>(converter, operationFunctions);
    }

    private PrefixedNotationExpressionEngine(Function<String, R> converter, OperatorFunction<R> ... operationFunctions) {
        this.converter = converter;
        StringBuilder operators = new StringBuilder();
        for (OperatorFunction<R> operationFunction : operationFunctions) {
            this.operatorFunctions.put(operationFunction.getOperator(), operationFunction);
            if (operators.length() > 0) {
                operators.append("|");
            }
            String operator = operationFunction.getOperator();
            for (int i = 0; i < operator.length(); ++i) {
                operators.append("[").append(operator.charAt(i)).append("]");
            }
        }
        this.operandPattern = Pattern.compile("(?i)^\\s*(" + operators.toString() + ")?\\s*(.+)\\s*$");
    }

    public R evaluate(String expression) {
        return this.parse(expression);
    }

    private R parse(String expression) {
        R computed = this.converter.apply(null);
        Matcher matcher = this.operandPattern.matcher(expression);
        if (matcher.find()) {
            OperatorFunction<R> operator = this.operatorFunctions.get(matcher.group(1));
            String operands = matcher.group(2);
            List<String> operandsAsList = this.readOperands(operands);
            if (operandsAsList.isEmpty()) {
                operator = null;
            }
            if (operator != null) {
                for (String element : operandsAsList) {
                    computed = operator.getFunction().apply(computed, this.parse(element));
                }
            } else {
                if (operandsAsList.size() > 1) {
                    throw new IllegalArgumentException("expression.operation.operator.none");
                }
                computed = operandsAsList.size() == 1 ? this.parse(operandsAsList.get(0)) : this.converter.apply(this.escapeExpression(expression).trim());
            }
        }
        return computed;
    }

    public boolean detectOperator(String expression) {
        OperatorFunction<R> operator;
        Matcher matcher = this.operandPattern.matcher(expression != null ? expression : "");
        return matcher.find() && (operator = this.operatorFunctions.get(matcher.group(1))) != null;
    }

    private List<String> readOperands(String operation) {
        ArrayList<String> operands = new ArrayList<String>();
        StringBuilder operand = new StringBuilder();
        int nbOpening = 0;
        block5: for (int i = 0; i < operation.length(); ++i) {
            char nextChar;
            char currentChar = operation.charAt(i);
            if (currentChar == '\\' && i + 1 < operation.length() && ('(' == (nextChar = operation.charAt(i + 1)) || ')' == nextChar)) {
                if (nbOpening > 0) {
                    operand.append('\\');
                }
                operand.append(nextChar);
                ++i;
                continue;
            }
            switch (currentChar) {
                case '(': {
                    if (++nbOpening == 1) {
                        if (operand.length() <= 0) continue block5;
                        throw new IllegalArgumentException("expression.operation.malformed");
                    }
                    operand.append(currentChar);
                    continue block5;
                }
                case ')': {
                    if (nbOpening == 0) {
                        throw new IllegalArgumentException("expression.operation.operand.parentheses.missing.open");
                    }
                    if (nbOpening == 1) {
                        operands.add(operand.toString());
                        operand.setLength(0);
                    } else {
                        operand.append(currentChar);
                    }
                    --nbOpening;
                    continue block5;
                }
                case ' ': {
                    if (nbOpening == 0 && operand.length() == 0) continue block5;
                }
                default: {
                    if (nbOpening == 0 && !operands.isEmpty()) {
                        throw new IllegalArgumentException("expression.operation.operand.parentheses.missing.open");
                    }
                    operand.append(currentChar);
                }
            }
        }
        if (nbOpening > 0) {
            throw new IllegalArgumentException("expression.operation.operand.parentheses.missing.close");
        }
        return operands;
    }

    private String escapeExpression(String expression) {
        StringBuilder escapedExpression = new StringBuilder();
        for (int i = 0; i < expression.length(); ++i) {
            char nextChar;
            char currentChar = expression.charAt(i);
            if (currentChar == '\\' && i + 1 < expression.length() && ('(' == (nextChar = expression.charAt(i + 1)) || ')' == nextChar)) continue;
            escapedExpression.append(currentChar);
        }
        return escapedExpression.toString();
    }

    public static class OperatorFunction<T> {
        private final String operator;
        private final BiFunction<T, T, T> function;

        public OperatorFunction(String operator, BiFunction<T, T, T> function) {
            this.operator = operator;
            this.function = function;
        }

        public String getOperator() {
            return this.operator;
        }

        public BiFunction<T, T, T> getFunction() {
            return this.function;
        }
    }
}

