/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.crypto;

import java.io.FileNotFoundException;
import java.util.Collection;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OutputEncryptor;
import org.silverpeas.util.Charsets;
import org.silverpeas.util.crypto.Cipher;
import org.silverpeas.util.crypto.CipherKey;
import org.silverpeas.util.crypto.CryptoException;
import org.silverpeas.util.crypto.CryptographicAlgorithmName;
import org.silverpeas.util.crypto.PKS12KeyStore;
import org.silverpeas.util.crypto.PKS12KeyStoreWallet;

public class CMSCipher
implements Cipher {
    protected CMSCipher() {
    }

    @Override
    public CryptographicAlgorithmName getAlgorithmName() {
        return CryptographicAlgorithmName.CMS;
    }

    @Override
    public byte[] encrypt(String data, CipherKey keyFilePath) throws CryptoException {
        try {
            byte[] buffer = this.stringToByteArray(data);
            CMSEnvelopedDataGenerator gen = new CMSEnvelopedDataGenerator();
            if (!keyFilePath.isInFile()) {
                throw new FileNotFoundException("The PKS#12 file '" + keyFilePath + "' doesn't exist!");
            }
            PKS12KeyStoreWallet wallet = PKS12KeyStoreWallet.getInstance();
            PKS12KeyStore keyStore = wallet.getKeyStore(keyFilePath.getKeyFilePath());
            JceKeyTransRecipientInfoGenerator generator = new JceKeyTransRecipientInfoGenerator(keyStore.getCertificate()).setProvider("BC");
            gen.addRecipientInfoGenerator((RecipientInfoGenerator)generator);
            OutputEncryptor encryptor = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider("BC").build();
            CMSEnvelopedData envData = gen.generate((CMSTypedData)new CMSProcessableByteArray(buffer), encryptor);
            return envData.getEncoded();
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException("The encryption failed!", e);
        }
    }

    @Override
    public String decrypt(byte[] encryptedData, CipherKey keyFilePath) throws CryptoException {
        try {
            CMSEnvelopedData ced = new CMSEnvelopedData(encryptedData);
            Collection recip = ced.getRecipientInfos().getRecipients();
            KeyTransRecipientInformation rinfo = (KeyTransRecipientInformation)recip.iterator().next();
            if (!keyFilePath.isInFile()) {
                throw new FileNotFoundException("The PKS#12 file '" + keyFilePath + "' doesn't exist!");
            }
            PKS12KeyStoreWallet wallet = PKS12KeyStoreWallet.getInstance();
            PKS12KeyStore keyStore = wallet.getKeyStore(keyFilePath.getKeyFilePath());
            byte[] contents = rinfo.getContent((Recipient)new JceKeyTransEnvelopedRecipient(keyStore.getPrivatekey()));
            return this.byteArrayToString(contents);
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException("The decryption failed!", e);
        }
    }

    private String byteArrayToString(byte[] bArray) {
        return new String(bArray, Charsets.UTF_8);
    }

    private byte[] stringToByteArray(String theString) {
        return theString.getBytes(Charsets.UTF_8);
    }

    @Override
    public CipherKey generateCipherKey() throws CryptoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

