/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.data;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.silverpeas.util.SerializationUtil;
import org.silverpeas.util.data.LastModifiedDateFileThread;

public class TemporaryWorkspaceTranslation {
    private static final String TRANSLATION_ID = "__sptrans_id";
    private static final String SILVERPEAS_TRANSLATION_PREFIX = "__sptrans_";
    private final File descriptor;
    private File workspace;
    private Map<String, String> descriptorContent = new HashMap<String, String>();

    public static boolean startWithTranslationDescriptorPrefix(String path) {
        return StringUtil.isDefined(path) && path.replaceAll("^/", "").startsWith(SILVERPEAS_TRANSLATION_PREFIX);
    }

    public static TemporaryWorkspaceTranslation from(String identifier) {
        return new TemporaryWorkspaceTranslation(identifier);
    }

    private TemporaryWorkspaceTranslation(String id) {
        this.descriptor = new File(FileRepositoryManager.getTemporaryPath(), SILVERPEAS_TRANSLATION_PREFIX + id);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        String string = SILVERPEAS_TRANSLATION_PREFIX;
        synchronized (SILVERPEAS_TRANSLATION_PREFIX) {
            if (this.descriptor.isFile() && this.descriptor.length() > 30L) {
                try {
                    for (String line : FileUtils.readLines((File)this.descriptor, (Charset)Charsets.UTF_8)) {
                        int splitIndex = line.indexOf("=");
                        if (splitIndex <= 0) continue;
                        this.descriptorContent.put(line.substring(0, splitIndex), line.substring(splitIndex + 1));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.descriptorContent.put(TRANSLATION_ID, UUID.randomUUID().toString());
            }
            this.workspace = new File(FileRepositoryManager.getTemporaryPath(), this.descriptorContent.get(TRANSLATION_ID));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove() {
        String string = SILVERPEAS_TRANSLATION_PREFIX;
        synchronized (SILVERPEAS_TRANSLATION_PREFIX) {
            boolean result = FileUtils.deleteQuietly((File)this.workspace) && FileUtils.deleteQuietly((File)this.descriptor);
            this.initialize();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        String string = SILVERPEAS_TRANSLATION_PREFIX;
        synchronized (SILVERPEAS_TRANSLATION_PREFIX) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.descriptor.isFile() && this.descriptor.length() > 30L && this.workspace.exists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastModified() {
        String string = SILVERPEAS_TRANSLATION_PREFIX;
        synchronized (SILVERPEAS_TRANSLATION_PREFIX) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.exists() ? this.descriptor.lastModified() : 0L;
        }
    }

    public void updateLastModifiedDate() {
        LastModifiedDateFileThread.addFile(this.descriptor);
        LastModifiedDateFileThread.addFile(this.workspace);
    }

    public File getRootPath() {
        return this.workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() {
        String string = SILVERPEAS_TRANSLATION_PREFIX;
        synchronized (SILVERPEAS_TRANSLATION_PREFIX) {
            if (!this.exists()) {
                this.workspace.mkdirs();
                this.saveDescriptor();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDescriptor() {
        String string = SILVERPEAS_TRANSLATION_PREFIX;
        synchronized (SILVERPEAS_TRANSLATION_PREFIX) {
            try {
                if (this.descriptorContent.containsKey(TRANSLATION_ID)) {
                    StringBuilder content = new StringBuilder();
                    for (Map.Entry<String, String> line : this.descriptorContent.entrySet()) {
                        if (content.length() > 0) {
                            content.append("\n");
                        }
                        content.append(line.getKey()).append("=").append(line.getValue());
                    }
                    FileUtils.writeStringToFile((File)this.descriptor, (String)content.toString(), (Charset)Charsets.UTF_8);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    public TemporaryWorkspaceTranslation put(String key, Serializable value) {
        if (value == null) {
            this.descriptorContent.remove(key);
        } else {
            this.descriptorContent.put(key, SerializationUtil.serializeAsString(value));
        }
        if (this.exists()) {
            this.saveDescriptor();
        }
        return this;
    }

    public <T extends Serializable> T get(String key) {
        try {
            String value = this.descriptorContent.get(key);
            if (value == null) {
                return null;
            }
            return SerializationUtil.deserializeFromString(this.descriptorContent.get(key));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.descriptor.getName() + " -> " + this.workspace.getName();
    }
}

