/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.time;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.silverpeas.util.UnitUtil;
import org.silverpeas.util.time.TimeUnit;

public class TimeData {
    private static List<TimeUnit> orderedUnits = new ArrayList<TimeUnit>(EnumSet.allOf(TimeUnit.class));
    private static BigDecimal ONE = new BigDecimal("1");
    private final BigDecimal time;

    public TimeData(long time) {
        this.time = new BigDecimal(String.valueOf(time));
    }

    public TimeData(BigDecimal time) {
        this.time = time;
    }

    public static BigDecimal convertTo(BigDecimal value, TimeUnit from, TimeUnit to) {
        int toIndex;
        int fromIndex = orderedUnits.indexOf((Object)from);
        int offsetIndex = fromIndex - (toIndex = orderedUnits.indexOf((Object)to));
        if (offsetIndex > 0) {
            return value.multiply(from.getMultiplier(to)).setScale(15, 1);
        }
        if (offsetIndex < 0) {
            return value.divide(from.getMultiplier(to), 15, 1);
        }
        return value;
    }

    public BigDecimal getTime() {
        return this.getTimeConverted(TimeUnit.MILLI);
    }

    public Long getTimeAsLong() {
        return this.getTimeConverted(TimeUnit.MILLI).longValue();
    }

    public BigDecimal getRoundedTimeConverted(TimeUnit to) {
        BigDecimal convertedSize = this.getTimeConverted(to);
        int nbMaximumFractionDigits = 2;
        if (TimeUnit.MILLI == to || TimeUnit.SEC == to) {
            nbMaximumFractionDigits = 3;
        }
        return convertedSize.setScale(nbMaximumFractionDigits, 1);
    }

    public BigDecimal getTimeConverted(TimeUnit to) {
        return TimeData.convertTo(this.time, TimeUnit.MILLI, to);
    }

    public TimeUnit getBestUnit() {
        for (int i = 1; i < orderedUnits.size(); ++i) {
            TimeUnit nextUnit = orderedUnits.get(i);
            TimeUnit currentUnit = orderedUnits.get(i - 1);
            BigDecimal nextUnitLimit = TimeData.convertTo(ONE, nextUnit, TimeUnit.MILLI);
            if (this.time.compareTo(nextUnitLimit) >= 0) continue;
            return currentUnit;
        }
        return orderedUnits.get(orderedUnits.size() - 1);
    }

    public BigDecimal getBestValue() {
        TimeUnit bestUnit = this.getBestUnit();
        return this.getRoundedTimeConverted(bestUnit);
    }

    private String getBestDisplayValue(boolean valueOnly) {
        return this.getFormattedValue(this.getBestUnit(), valueOnly);
    }

    public String getBestDisplayValueOnly() {
        return this.getBestDisplayValue(true);
    }

    public String getBestDisplayValue() {
        return this.getBestDisplayValue(false);
    }

    private String getFormattedValue(TimeUnit to, boolean valueOnly) {
        BigDecimal bestDisplayValue = this.getRoundedTimeConverted(to);
        StringBuilder sb = new StringBuilder();
        sb.append(new DecimalFormat().format(bestDisplayValue));
        if (!valueOnly) {
            sb.append(" ");
            sb.append(to.getLabel());
        }
        return sb.toString();
    }

    public String getFormattedValueOnly(TimeUnit to) {
        return this.getFormattedValue(to, true);
    }

    public String getFormattedValue(TimeUnit to) {
        return this.getFormattedValue(to, false);
    }

    public String getFormattedDurationAsHMSM() {
        return this.getFormattedDuration("HH:mm:ss.SSS");
    }

    public String getFormattedDurationAsHMS() {
        TimeData roundedTimeData = UnitUtil.getTimeData(this.getRoundedTimeConverted(TimeUnit.SEC).setScale(0, 5), TimeUnit.SEC);
        return roundedTimeData.getFormattedDuration("HH:mm:ss");
    }

    public String getFormattedDuration(String format) {
        return DurationFormatUtils.formatDuration((long)this.getTimeAsLong(), (String)format);
    }
}

