/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer;

import com.silverpeas.util.ImageUtil;
import com.stratelia.webactiv.util.FileServerUtils;
import java.io.File;
import org.silverpeas.viewer.Preview;

public abstract class AbstractPreview
implements Preview {
    private static final long serialVersionUID = 3597757215012779572L;
    private final String originalFileName;
    private final File physicalFile;
    private String[] widthAndHeight = null;

    @Override
    public String getDisplayLicenseKey() {
        return "";
    }

    protected AbstractPreview(String originalFileName, File physicalFile) {
        this.originalFileName = originalFileName;
        this.physicalFile = physicalFile;
    }

    @Override
    public String getOriginalFileName() {
        return this.originalFileName;
    }

    @Override
    public File getPhysicalFile() {
        return this.physicalFile;
    }

    @Override
    public String getWidth() {
        return this.getWidthAndHeight()[0];
    }

    @Override
    public String getHeight() {
        return this.getWidthAndHeight()[1];
    }

    @Override
    public String getURLAsString() {
        return FileServerUtils.getUrlToTempDir(this.getPhysicalFile().getParentFile().getName() + "/" + this.getPhysicalFile().getName());
    }

    private String[] getWidthAndHeight() {
        if (this.widthAndHeight == null) {
            this.widthAndHeight = ImageUtil.getWidthAndHeight(this.physicalFile);
        }
        return this.widthAndHeight;
    }
}

