/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer.util;

import com.silverpeas.util.StringUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.exec.ExternalExecution;
import org.silverpeas.exec.ExternalExecutionException;
import org.silverpeas.viewer.SwfToolManager;
import org.silverpeas.viewer.exception.ViewerException;
import org.silverpeas.viewer.util.DocumentInfo;

public class SwfUtil
extends ExternalExecution {
    public static final String SWF_DOCUMENT_EXTENSION = "swf";
    public static final String PAGE_FILENAME_SEPARATOR = "-";
    private static final String OUTPUT_COMMAND = "-o";
    private static final String TO_SWF_ENDING_COMMAND = "-f -T 9 -t -s storeallcharacters";

    public static boolean isPdfToSwfActivated() {
        return SwfToolManager.isActivated();
    }

    public static boolean isPdfToImageActivated() {
        return SwfUtil.isPdfToSwfActivated() && SwfToolManager.isSwfRenderActivated();
    }

    public static void fromPdfToImage(File fileIn, File fileOut) {
        File swfFile = SwfUtil.changeFileExtension(fileOut, SWF_DOCUMENT_EXTENSION);
        SwfUtil.fromPdfToSwf(fileIn, swfFile, false, "-p 1-1");
        SwfUtil.fromSwfToImage(swfFile, fileOut);
        FileUtils.deleteQuietly((File)swfFile);
    }

    private static void fromSwfToImage(File fileIn, File fileOut) {
        try {
            SwfUtil.exec(SwfUtil.buildSwfToImageCommandLine(fileIn, fileOut));
        }
        catch (ExternalExecutionException e) {
            throw new ViewerException(e);
        }
    }

    public static void fromPdfToSwf(File fileIn, File fileOut) {
        SwfUtil.fromPdfToSwf(fileIn, fileOut, false);
    }

    public static void fromPdfToSwf(File fileIn, File fileOut, boolean oneFilePerPage) {
        SwfUtil.fromPdfToSwf(fileIn, fileOut, oneFilePerPage, null);
    }

    public static void fromPdfToSwf(File fileIn, File fileOut, boolean oneFilePerPage, String endingCommand) {
        File outputFile = fileOut;
        if (oneFilePerPage) {
            StringBuilder onePageFile = new StringBuilder(512);
            onePageFile.append(FilenameUtils.getFullPath((String)fileOut.getPath()));
            onePageFile.append(FilenameUtils.getBaseName((String)fileOut.getPath()));
            onePageFile.append(PAGE_FILENAME_SEPARATOR);
            onePageFile.append("%.");
            onePageFile.append(FilenameUtils.getExtension((String)fileOut.getPath()));
            outputFile = new File(onePageFile.toString());
        }
        try {
            SwfUtil.exec(SwfUtil.buildPdfToSwfCommandLine(endingCommand, fileIn, outputFile));
        }
        catch (ExternalExecutionException e) {
            throw new ViewerException(e);
        }
    }

    public static DocumentInfo getPdfDocumentInfo(File pdfFile) {
        List<String> execResult = null;
        try {
            execResult = SwfUtil.exec(SwfUtil.buildPdfDocumentInfoCommandLine(pdfFile));
        }
        catch (ExternalExecutionException e) {
            throw new ExternalExecutionException(e);
        }
        return new DocumentInfo().addFromSwfToolsOutput(execResult);
    }

    private static File changeFileExtension(File file, String fileExtension) {
        return new File(FilenameUtils.getFullPath((String)file.getPath()) + FilenameUtils.getBaseName((String)file.getPath()) + '.' + fileExtension);
    }

    static CommandLine buildPdfToSwfCommandLine(String endingCommand, File inputFile, File outputFile) {
        HashMap<String, File> files = new HashMap<String, File>(2);
        files.put("inputFile", inputFile);
        files.put("outputFile", outputFile);
        CommandLine commandLine = new CommandLine("pdf2swf");
        commandLine.addArgument("${inputFile}", false);
        commandLine.addArgument(OUTPUT_COMMAND);
        commandLine.addArgument("${outputFile}", false);
        commandLine.addArguments(TO_SWF_ENDING_COMMAND, false);
        if (StringUtil.isDefined(endingCommand)) {
            commandLine.addArguments(endingCommand, false);
        }
        commandLine.setSubstitutionMap(files);
        return commandLine;
    }

    static CommandLine buildPdfDocumentInfoCommandLine(File file) {
        HashMap<String, File> files = new HashMap<String, File>(1);
        files.put("file", file);
        CommandLine commandLine = new CommandLine("pdf2swf");
        commandLine.addArgument("-qq");
        commandLine.addArgument("${file}", false);
        commandLine.addArgument("--info");
        commandLine.setSubstitutionMap(files);
        return commandLine;
    }

    static CommandLine buildSwfToImageCommandLine(File inputFile, File outputFile) {
        HashMap<String, File> files = new HashMap<String, File>(2);
        files.put("inputFile", inputFile);
        files.put("outputFile", outputFile);
        CommandLine commandLine = new CommandLine("swfrender");
        commandLine.addArgument("${inputFile}", false);
        commandLine.addArgument(OUTPUT_COMMAND);
        commandLine.addArgument("${outputFile}", false);
        commandLine.setSubstitutionMap(files);
        return commandLine;
    }
}

