/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.calendar;

import java.util.Calendar;
import java.util.Date;
import net.fortuna.ical4j.model.WeekDay;

public enum DayOfWeek {
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY,
    SUNDAY;


    public WeekDay toICal4J() {
        switch (this) {
            case MONDAY: {
                return WeekDay.MO;
            }
            case TUESDAY: {
                return WeekDay.TU;
            }
            case WEDNESDAY: {
                return WeekDay.WE;
            }
            case THURSDAY: {
                return WeekDay.TH;
            }
            case FRIDAY: {
                return WeekDay.FR;
            }
            case SATURDAY: {
                return WeekDay.SA;
            }
            case SUNDAY: {
                return WeekDay.SU;
            }
        }
        return null;
    }

    public static DayOfWeek fromDate(Date aDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(aDate);
        return DayOfWeek.fromDayOfWeekNumber(calendar.get(7));
    }

    public static DayOfWeek fromDayOfWeekNumber(int dayOfWeekNumber) {
        switch (dayOfWeekNumber) {
            case 2: {
                return MONDAY;
            }
            case 3: {
                return TUESDAY;
            }
            case 4: {
                return WEDNESDAY;
            }
            case 5: {
                return THURSDAY;
            }
            case 6: {
                return FRIDAY;
            }
            case 7: {
                return SATURDAY;
            }
            case 1: {
                return SUNDAY;
            }
        }
        return null;
    }
}

