/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.converter.openoffice;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.silverpeas.converter.DocumentFormat;
import com.silverpeas.converter.DocumentFormatConversion;
import com.silverpeas.converter.DocumentFormatConversionException;
import com.silverpeas.converter.DocumentFormatException;
import com.silverpeas.converter.openoffice.SilverpeasOpenOfficeDocumentConverter;
import com.silverpeas.converter.option.FilterOption;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;

public abstract class OpenOfficeConverter
implements DocumentFormatConversion {
    private static final ResourceLocator settings = new ResourceLocator("org.silverpeas.converter.openoffice", "");
    private static final String OPENOFFICE_PORT = "openoffice.port";
    private static final String OPENOFFICE_HOST = "openoffice.host";

    public abstract boolean isDocumentSupported(File var1);

    @Override
    public File convert(File source, DocumentFormat inFormat, FilterOption ... options) {
        String fileName = FilenameUtils.getBaseName((String)source.getName()) + '.' + inFormat.name();
        File destination = new File(FileRepositoryManager.getTemporaryPath() + fileName);
        return this.convert(source, destination, inFormat, options);
    }

    @Override
    public File convert(File source, File destination, DocumentFormat inFormat, FilterOption ... options) {
        if (!this.isFormatSupported(inFormat)) {
            throw new DocumentFormatException("The conversion of the file to the format " + inFormat.toString() + " isn't supported");
        }
        if (!this.isDocumentSupported(source)) {
            throw new DocumentFormatException("The format of the file " + source.getName() + " isn't " + "supported by this converter");
        }
        OpenOfficeConnection connection = null;
        try {
            connection = this.openConnection();
            this.convert(this.getOpenOfficeDocumentConverterFrom(connection), source, destination, options);
        }
        catch (Exception e) {
            throw new DocumentFormatConversionException(e.getMessage(), e);
        }
        finally {
            this.closeConnection(connection);
        }
        return destination;
    }

    @Override
    public void convert(InputStream source, DocumentFormat inFormat, OutputStream destination, DocumentFormat outFormat, FilterOption ... options) {
        if (!this.isFormatSupported(outFormat)) {
            throw new DocumentFormatException("The conversion of the stream to the format " + outFormat.toString() + " isn't supported");
        }
        OpenOfficeConnection connection = null;
        try {
            connection = this.openConnection();
            this.convert(this.getOpenOfficeDocumentConverterFrom(connection), source, inFormat, destination, outFormat, options);
        }
        catch (Exception e) {
            throw new DocumentFormatConversionException(e.getMessage(), e);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    protected void convert(SilverpeasOpenOfficeDocumentConverter documentConverter, File source, File destination, FilterOption ... options) {
        this.applyFilterOptions(documentConverter, options);
        documentConverter.convert(source, destination);
    }

    protected void convert(SilverpeasOpenOfficeDocumentConverter documentConverter, InputStream source, DocumentFormat inFormat, OutputStream destination, DocumentFormat outFormat, FilterOption ... options) {
        this.applyFilterOptions(documentConverter, options);
        documentConverter.convert(source, inFormat, destination, outFormat, new FilterOption[0]);
    }

    private void applyFilterOptions(SilverpeasOpenOfficeDocumentConverter documentConverter, FilterOption ... options) {
        if (options != null) {
            for (FilterOption option : options) {
                documentConverter.addFilterData(option);
            }
        }
    }

    protected OpenOfficeConnection openConnection() throws ConnectException {
        String host = settings.getString(OPENOFFICE_HOST, "localhost");
        int port = settings.getInteger(OPENOFFICE_PORT, 8100);
        SocketOpenOfficeConnection connection = new SocketOpenOfficeConnection(host, port);
        connection.connect();
        return connection;
    }

    protected void closeConnection(OpenOfficeConnection connection) {
        if (connection != null && connection.isConnected()) {
            connection.disconnect();
        }
    }

    protected SilverpeasOpenOfficeDocumentConverter getOpenOfficeDocumentConverterFrom(OpenOfficeConnection connection) {
        return new SilverpeasOpenOfficeDocumentConverter(connection);
    }

    private boolean isFormatSupported(DocumentFormat format) {
        return Arrays.asList(this.getSupportedFormats()).contains((Object)format);
    }
}

