/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.domains.silverpeasdriver;

import com.silverpeas.annotation.Service;
import com.silverpeas.domains.silverpeasdriver.SPGroup;
import com.silverpeas.domains.silverpeasdriver.SPGroupDao;
import com.silverpeas.domains.silverpeasdriver.SPUser;
import com.silverpeas.domains.silverpeasdriver.SPUserDao;
import com.silverpeas.domains.silverpeasdriver.SilverpeasDomainDriver;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.AbstractDomainDriver;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.DomainProperty;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.exception.UtilException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.silverpeas.authentication.encryption.PasswordEncryption;
import org.silverpeas.authentication.encryption.PasswordEncryptionFactory;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SilverpeasDriver
extends AbstractDomainDriver
implements SilverpeasDomainDriver {
    @Inject
    private SPUserDao userDao;
    @Inject
    private SPGroupDao groupDao;

    @Override
    public void initFromProperties(ResourceLocator rs) throws Exception {
    }

    @Override
    public UserDetail[] getAllChangedUsers(String fromTimeStamp, String toTimeStamp) throws Exception {
        return new UserDetail[0];
    }

    @Override
    public Group[] getAllChangedGroups(String fromTimeStamp, String toTimeStamp) throws Exception {
        return new Group[0];
    }

    @Override
    public UserDetail importUser(String userLogin) throws Exception {
        return null;
    }

    @Override
    public void removeUser(String userId) throws Exception {
    }

    @Override
    public UserDetail synchroUser(String userId) throws Exception {
        return null;
    }

    @Override
    public String createUser(UserDetail ud) {
        try {
            SPUser user = this.convertToSPUser(ud, new SPUser());
            int id = DBUtil.getNextId("domainsp_user", "id");
            user.setId(id);
            user = (SPUser)this.userDao.saveAndFlush(user);
            return String.valueOf(id);
        }
        catch (UtilException ex) {
            Logger.getLogger(SilverpeasDriver.class.getName()).log(Level.SEVERE, null, ex);
            return "-1";
        }
    }

    @Override
    public void deleteUser(String userId) {
        if (StringUtil.isInteger(userId)) {
            SPUser user = (SPUser)this.userDao.findOne(Integer.valueOf(userId));
            if (user.getGroups() != null) {
                for (SPGroup group : user.getGroups()) {
                    group.getUsers().remove(user);
                    this.groupDao.saveAndFlush(group);
                }
            }
            this.userDao.delete(user);
        }
    }

    @Override
    public void updateUserFull(UserFull userFull) throws UtilException {
        SPUser oldUser = (SPUser)this.userDao.findOne(Integer.valueOf(userFull.getSpecificId()));
        oldUser.setFirstname(userFull.getFirstName());
        oldUser.setLastname(userFull.getLastName());
        oldUser.setLogin(userFull.getLogin());
        oldUser.setEmail(userFull.geteMail());
        oldUser.setTitle(userFull.getValue("title"));
        oldUser.setCompany(userFull.getValue("company"));
        oldUser.setPosition(userFull.getValue("position"));
        oldUser.setBoss(userFull.getValue("boss"));
        oldUser.setPhone(userFull.getValue("phone"));
        oldUser.setHomephone(userFull.getValue("homePhone"));
        oldUser.setFax(userFull.getValue("fax"));
        oldUser.setCellphone(userFull.getValue("cellularPhone"));
        oldUser.setAddress(userFull.getValue("address"));
        oldUser.setLoginmail("");
        if (StringUtil.isDefined(userFull.getPassword()) && !userFull.getPassword().equals(oldUser.getPassword())) {
            oldUser.setPassword(this.encrypt(userFull.getPassword()));
        }
        oldUser.setPasswordValid(userFull.isPasswordValid());
        this.userDao.saveAndFlush(oldUser);
    }

    @Override
    public void updateUserDetail(UserDetail ud) {
        SPUser user;
        if (StringUtil.isInteger(ud.getSpecificId()) && (user = (SPUser)this.userDao.findOne(Integer.valueOf(ud.getSpecificId()))) != null) {
            this.userDao.save(this.convertToSPUser(ud, user));
        }
    }

    @Override
    public UserDetail getUser(String userId) {
        if (!StringUtil.isInteger(userId)) {
            return null;
        }
        SPUser spUser = (SPUser)this.userDao.findOne(Integer.valueOf(Integer.parseInt(userId)));
        return this.convertToUser(spUser, new UserDetail());
    }

    @Override
    public UserFull getUserFull(String userId) {
        if (!StringUtil.isInteger(userId)) {
            return null;
        }
        SPUser user = (SPUser)this.userDao.findOne(Integer.valueOf(userId));
        UserFull userFull = new UserFull(this);
        if (user != null) {
            userFull.setFirstName(user.getFirstname());
            userFull.setLastName(user.getLastname());
            userFull.setValue("title", user.getTitle());
            userFull.setValue("company", user.getCompany());
            userFull.setValue("position", user.getPosition());
            userFull.setValue("boss", user.getBoss());
            userFull.setValue("phone", user.getPhone());
            userFull.setValue("homePhone", user.getHomephone());
            userFull.setValue("fax", user.getFax());
            userFull.setValue("cellularPhone", user.getCellphone());
            userFull.setValue("address", user.getAddress());
            userFull.setLogin(user.getLogin());
            userFull.seteMail(user.getEmail());
            userFull.setPassword(user.getPassword());
            userFull.setPasswordValid(user.isPasswordValid());
            userFull.setPasswordAvailable(true);
        }
        return userFull;
    }

    @Override
    public String[] getUserMemberGroupIds(String userId) throws Exception {
        return new String[0];
    }

    @Override
    public UserDetail[] getAllUsers() {
        List users = this.userDao.findAll();
        ArrayList<UserDetail> details = new ArrayList<UserDetail>(users.size());
        for (SPUser sPUser : users) {
            details.add(this.convertToUser(sPUser, new UserDetail()));
        }
        return details.toArray(new UserDetail[details.size()]);
    }

    @Override
    public UserDetail[] getUsersBySpecificProperty(String propertyName, String propertyValue) throws Exception {
        DomainProperty property = this.getProperty(propertyName);
        if (property == null) {
            return null;
        }
        List<Object> users = new ArrayList();
        if ("title".equalsIgnoreCase(propertyName)) {
            users = this.userDao.findByTitle(propertyValue);
        } else if ("company".equalsIgnoreCase(propertyName)) {
            users = this.userDao.findByCompany(propertyValue);
        } else if ("position".equalsIgnoreCase(propertyName)) {
            users = this.userDao.findByPosition(propertyValue);
        } else if ("phone".equalsIgnoreCase(propertyName)) {
            users = this.userDao.findByPhone(propertyValue);
        } else if ("homePhone".equalsIgnoreCase(propertyName)) {
            users = this.userDao.findByHomephone(propertyValue);
        } else if ("fax".equalsIgnoreCase(propertyName)) {
            users = this.userDao.findByFax(propertyValue);
        } else if ("cellularPhone".equalsIgnoreCase(propertyName)) {
            users = this.userDao.findByCellphone(propertyValue);
        } else if ("address".equalsIgnoreCase(propertyName)) {
            users = this.userDao.findByAddress(propertyValue);
        }
        ArrayList<UserDetail> userDetails = new ArrayList<UserDetail>(users.size());
        for (SPUser spUser : users) {
            userDetails.add(this.convertToUser(spUser, new UserDetail()));
        }
        return userDetails.toArray(new UserDetail[userDetails.size()]);
    }

    @Override
    public UserDetail[] getUsersByQuery(Map<String, String> query) throws Exception {
        return new UserDetail[0];
    }

    @Override
    public Group importGroup(String groupName) throws Exception {
        return null;
    }

    @Override
    public void removeGroup(String groupId) throws Exception {
    }

    @Override
    public Group synchroGroup(String groupId) throws Exception {
        return null;
    }

    @Override
    public String createGroup(Group group) {
        try {
            String[] userIds;
            SPGroup spGroup = new SPGroup();
            int id = DBUtil.getNextId("domainsp_group", "id");
            spGroup.setId(id);
            group.setId(String.valueOf(id));
            spGroup.setDescription(group.getDescription());
            spGroup.setName(group.getName());
            if (StringUtil.isInteger(group.getSuperGroupId())) {
                SPGroup parent = (SPGroup)this.groupDao.findOne(Integer.valueOf(group.getSuperGroupId()));
                spGroup.setParent(parent);
            }
            for (String userId : userIds = group.getUserIds()) {
                SPUser user = (SPUser)this.userDao.findOne(Integer.valueOf(userId));
                spGroup.getUsers().add(user);
                user.getGroups().add(spGroup);
            }
            spGroup = (SPGroup)this.groupDao.saveAndFlush(spGroup);
            return String.valueOf(spGroup.getId());
        }
        catch (UtilException ex) {
            Logger.getLogger(SilverpeasDriver.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    @Override
    public void deleteGroup(String groupId) {
        SPGroup group = (SPGroup)this.groupDao.findOne(Integer.valueOf(groupId));
        if (group != null) {
            for (SPGroup subGroup : new ArrayList<SPGroup>(group.getSubGroups())) {
                this.deleteGroup(String.valueOf(subGroup.getId()));
            }
            SPGroup reloadedGroup = (SPGroup)this.groupDao.findOne(Integer.valueOf(groupId));
            for (SPUser user : new ArrayList<SPUser>(reloadedGroup.getUsers())) {
                user.getGroups().remove(reloadedGroup);
            }
            SPGroup parent = reloadedGroup.getParent();
            if (parent != null) {
                parent.getSubGroups().remove(reloadedGroup);
                this.groupDao.saveAndFlush(parent);
            }
            this.groupDao.delete(reloadedGroup);
            this.groupDao.flush();
        }
    }

    @Override
    public void updateGroup(Group group) throws AdminException {
        String[] userIds;
        HashSet<SPUser> addedUsers = new HashSet<SPUser>();
        if (group == null || !StringUtil.isDefined(group.getName()) || !StringUtil.isDefined(group.getId())) {
            throw new AdminException("SilverpeasDriver.updateGroup", 4, "admin.EX_ERR_INVALID_GROUP");
        }
        SPGroup gr = (SPGroup)this.groupDao.findOne(Integer.valueOf(group.getSpecificId()));
        gr = this.convertToSPGroup(group, gr);
        Set<SPUser> users = gr.getUsers();
        HashMap<String, SPUser> existingUsers = new HashMap<String, SPUser>(users.size());
        for (SPUser user : users) {
            existingUsers.put(String.valueOf(user.getId()), user);
        }
        for (String userId : userIds = group.getUserIds()) {
            if (existingUsers.containsKey(userId)) {
                addedUsers.add((SPUser)existingUsers.get(userId));
                existingUsers.remove(userId);
                continue;
            }
            SPUser newUser = (SPUser)this.userDao.findOne(Integer.valueOf(userId));
            addedUsers.add(newUser);
        }
        gr.setUsers(addedUsers);
        this.groupDao.saveAndFlush(gr);
    }

    @Override
    public Group getGroup(String groupId) {
        SPGroup gr = (SPGroup)this.groupDao.findOne(Integer.valueOf(groupId));
        return this.convertToGroup(gr);
    }

    @Override
    public Group getGroupByName(String groupName) throws Exception {
        return null;
    }

    @Override
    public Group[] getGroups(String groupId) {
        SPGroup gr = (SPGroup)this.groupDao.findOne(Integer.valueOf(groupId));
        Set<SPGroup> subGroups = gr.getSubGroups();
        ArrayList<Group> groups = new ArrayList<Group>(subGroups.size());
        for (SPGroup spGroup : subGroups) {
            groups.add(this.convertToGroup(spGroup));
        }
        return groups.toArray(new Group[groups.size()]);
    }

    @Override
    public Group[] getAllGroups() {
        List groups = this.groupDao.findAll();
        ArrayList<Group> result = new ArrayList<Group>(groups.size());
        for (SPGroup spGroup : groups) {
            result.add(this.convertToGroup(spGroup));
        }
        return result.toArray(new Group[result.size()]);
    }

    @Override
    public Group[] getAllRootGroups() {
        List<SPGroup> groups = this.groupDao.listAllRootGroups("toto");
        ArrayList<Group> result = new ArrayList<Group>(groups.size());
        for (SPGroup spGroup : groups) {
            result.add(this.convertToGroup(spGroup));
        }
        return result.toArray(new Group[result.size()]);
    }

    @Override
    public String[] getGroupMemberGroupIds(String groupId) throws Exception {
        return new String[0];
    }

    @Override
    public void startTransaction(boolean bAutoCommit) {
    }

    @Override
    public void commit() throws Exception {
    }

    @Override
    public void rollback() throws Exception {
    }

    public void addUserInGroup(String userId, String groupId) throws Exception {
        SPUser user = (SPUser)this.userDao.findOne(Integer.valueOf(userId));
        SPGroup group = (SPGroup)this.groupDao.findOne(Integer.valueOf(groupId));
        user.getGroups().add(group);
        group.getUsers().add(user);
        this.groupDao.saveAndFlush(group);
    }

    public void removeUserFromGroup(String userId, String groupId) {
        SPUser user = (SPUser)this.userDao.findOne(Integer.valueOf(userId));
        SPGroup group = (SPGroup)this.groupDao.findOne(Integer.valueOf(groupId));
        user.getGroups().remove(group);
        group.getUsers().remove(user);
        this.groupDao.saveAndFlush(group);
    }

    SPGroup convertToSPGroup(Group group, SPGroup spGroup) {
        if (StringUtil.isDefined(group.getSpecificId()) && StringUtil.isInteger(group.getSpecificId())) {
            spGroup.setId(Integer.valueOf(group.getSpecificId()));
        }
        if (StringUtil.isDefined(group.getSuperGroupId()) && StringUtil.isInteger(group.getSuperGroupId())) {
            SPGroup parent = (SPGroup)this.groupDao.findOne(Integer.valueOf(group.getSuperGroupId()));
            spGroup.setParent(parent);
        }
        spGroup.setName(group.getName());
        spGroup.setDescription(group.getDescription());
        return spGroup;
    }

    Group convertToGroup(SPGroup gr) {
        Group group = new Group();
        group.setSpecificId(String.valueOf(gr.getId()));
        group.setName(gr.getName());
        group.setDescription(gr.getDescription());
        if (gr.getParent() != null) {
            group.setSuperGroupId(String.valueOf(gr.getParent().getId()));
        }
        Set<SPUser> users = gr.getUsers();
        ArrayList<String> userIds = new ArrayList<String>(users.size());
        for (SPUser user : users) {
            userIds.add(String.valueOf(user.getId()));
        }
        group.setUserIds(userIds.toArray(new String[userIds.size()]));
        return group;
    }

    @Override
    public List<String> getUserAttributes() throws Exception {
        return null;
    }

    SPUser convertToSPUser(UserDetail detail, SPUser user) {
        if (StringUtil.isDefined(detail.getSpecificId()) && StringUtil.isInteger(detail.getSpecificId())) {
            user.setId(Integer.valueOf(detail.getId()));
        }
        user.setFirstname(detail.getFirstName());
        user.setLastname(detail.getLastName());
        user.setLogin(detail.getLogin());
        user.setEmail(detail.geteMail());
        return user;
    }

    UserDetail convertToUser(SPUser user, UserDetail detail) {
        detail.setSpecificId(String.valueOf(user.getId()));
        detail.setFirstName(user.getFirstname());
        detail.setLastName(user.getLastname());
        detail.setLogin(user.getLogin());
        detail.seteMail(user.getEmail());
        return detail;
    }

    @Override
    public void resetPassword(UserDetail userDetail, String password) throws Exception {
        SPUser user = (SPUser)this.userDao.findOne(Integer.valueOf(userDetail.getId()));
        user.setPassword(this.encrypt(password));
        user.setPasswordValid(true);
        this.userDao.saveAndFlush(user);
    }

    private String encrypt(String password) {
        PasswordEncryptionFactory factory = PasswordEncryptionFactory.getFactory();
        PasswordEncryption encryption = factory.getDefaultPasswordEncryption();
        return encryption.encrypt(password);
    }

    @Override
    public void resetEncryptedPassword(UserDetail userDetail, String encryptedPassword) throws Exception {
        SPUser user = (SPUser)this.userDao.findOne(Integer.valueOf(userDetail.getId()));
        user.setPassword(encryptedPassword);
        user.setPasswordValid(true);
        this.userDao.saveAndFlush(user);
    }
}

