/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.export;

import com.silverpeas.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ImportExportDescriptor {
    public static final String NO_FORMAT = "";
    private String format = "";
    private Map<String, Serializable> parameters = new HashMap<String, Serializable>();

    public String getFormat() {
        return this.format;
    }

    public <O extends ImportExportDescriptor> O inFormat(String format) {
        if (!StringUtil.isDefined(format)) {
            this.format = NO_FORMAT;
        }
        this.format = format;
        return (O)this;
    }

    public <T extends Serializable, O extends ImportExportDescriptor> O withParameter(String name, T value) {
        this.parameters.put(name, value);
        return (O)this;
    }

    public <T extends Serializable> void setParameter(String name, T value) {
        this.parameters.put(name, value);
    }

    public <O extends ImportExportDescriptor> O withoutParameter(String name) {
        this.parameters.remove(name);
        return (O)this;
    }

    public <T> T getParameter(String name) {
        return (T)this.parameters.get(name);
    }

    public List<String> getParameters() {
        return new ArrayList<String>(this.parameters.keySet());
    }

    public boolean isParameterSet(String name) {
        return this.parameters.containsKey(name);
    }
}

