/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.export.ical;

import com.silverpeas.export.ExportDescriptor;
import com.silverpeas.export.ExportException;
import com.silverpeas.export.Exporter;
import com.silverpeas.export.NoDataToExportException;
import com.silverpeas.export.ical.ExportableCalendar;
import com.silverpeas.export.ical.ICalCodec;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ICalExporter
implements Exporter<ExportableCalendar> {
    @Inject
    private ICalCodec iCalCodec;

    @Override
    public void export(ExportDescriptor descriptor, ExportableCalendar calendar) throws ExportException {
        if (calendar.isEmpty()) {
            throw new NoDataToExportException("To export to iCal, the calendar should have at least one event");
        }
        Writer writer = descriptor.getWriter();
        try {
            String iCalCalendar = this.getICalCodec().encode(calendar.getEvents());
            writer.write(iCalCalendar);
            writer.close();
        }
        catch (Exception e) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception ex) {
                SilverTrace.error("export.ical", this.getClass().getSimpleName() + ".exportInICal()", "root.EX_NO_MESSAGES", ex);
            }
            SilverTrace.error("export.ical", this.getClass().getSimpleName() + ".exportInICal()", "roor.EX_NO_MESSAGES", e);
            throw new ExportException(e.getMessage(), e);
        }
    }

    protected ICalCodec getICalCodec() {
        return this.iCalCodec;
    }

    private ICalExporter() {
    }
}

