/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.UserField;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UserFieldDisplayer
extends AbstractFieldDisplayer<UserField> {
    public String[] getManagedTypes() {
        return new String[]{"user"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) {
        String language = pagesContext.getLanguage();
        if (!"user".equals(template.getTypeName())) {
            SilverTrace.info("form", "TextFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "user");
        }
        if (template.isMandatory() && pagesContext.useMandatory()) {
            out.println("   if (isWhitespace(stripInitialWhitespace(field.value))) {");
            out.println("      errorMsg+=\"  - '" + EncodeHelper.javaStringToJsString(template.getLabel(language)) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n\";");
            out.println("      errorNb++;");
            out.println("   }");
        }
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, UserField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        SilverTrace.info("form", "UserFieldDisplayer.display", "root.MSG_GEN_ENTER_METHOD", "fieldName = " + template.getFieldName() + ", value = " + field.getValue() + ", fieldType = " + field.getTypeName());
        String language = pageContext.getLanguage();
        String selectUserImg = Util.getIcon("userPanel");
        String selectUserLab = Util.getString("userPanel", language);
        String deleteUserImg = Util.getIcon("delete");
        String deleteUserLab = Util.getString("clearUser", language);
        String userName = "";
        String userId = "";
        String html = "";
        String fieldName = template.getFieldName();
        if (!field.getTypeName().equals("user")) {
            SilverTrace.info("form", "UserFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "user");
        } else {
            userId = field.getUserId();
        }
        if (!field.isNull()) {
            userName = field.getValue();
        }
        html = html + "<input type=\"hidden\" id=\"" + fieldName + "\" name=\"" + fieldName + "\" value=\"" + EncodeHelper.javaStringToHtmlString(userId) + "\"/>";
        if (!template.isHidden()) {
            html = html + "<input type=\"text\" disabled=\"disabled\" size=\"50\" id=\"" + fieldName + "_name\" name=\"" + fieldName + "$$name\" value=\"" + EncodeHelper.javaStringToHtmlString(userName) + "\"/>";
        }
        if (!(template.isHidden() || template.isDisabled() || template.isReadOnly())) {
            Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
            String roles = parameters.get("roles");
            boolean usersOfInstanceOnly = StringUtil.getBooleanValue(parameters.get("usersOfInstanceOnly"));
            if (StringUtil.isDefined(roles)) {
                usersOfInstanceOnly = true;
            }
            html = html + "&nbsp;<a href=\"#\" onclick=\"javascript:SP_openWindow('" + URLManager.getApplicationURL() + "/RselectionPeasWrapper/jsp/open" + "?formName=" + pageContext.getFormName() + "&elementId=" + fieldName + "&elementName=" + fieldName + "_name" + "&selectedUser=" + (userId == null ? "" : userId);
            if (usersOfInstanceOnly) {
                html = html + "&instanceId=" + pageContext.getComponentId();
            }
            if (StringUtil.isDefined(roles)) {
                html = html + "&roles=" + roles;
            }
            html = html + "','selectUser',800,600,'');return false;\" >";
            html = html + "<img src=\"" + selectUserImg + "\" width=\"15\" height=\"15\" border=\"0\" alt=\"" + selectUserLab + "\" align=\"top\" title=\"" + selectUserLab + "\"/></a>";
            html = html + "&nbsp;<a href=\"#\" onclick=\"javascript:document." + pageContext.getFormName() + "." + fieldName + ".value='';" + "document." + pageContext.getFormName() + "." + fieldName + "$$name" + ".value='';return false;" + "\">";
            html = html + "<img src=\"" + deleteUserImg + "\" width=\"15\" height=\"15\" border=\"0\" alt=\"" + deleteUserLab + "\" align=\"top\" title=\"" + deleteUserLab + "\"/></a>";
            if (template.isMandatory() && pageContext.useMandatory()) {
                html = html + Util.getMandatorySnippet();
            }
        }
        out.println(html);
    }

    @Override
    public List<String> update(String newId, UserField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        if ("user".equals(field.getTypeName())) {
            if (!StringUtil.isDefined(newId)) {
                field.setNull();
            } else {
                field.setUserId(newId);
            }
        } else {
            throw new FormException("UserFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "user");
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pageContext) {
        return 2;
    }
}

