/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.fieldType;

import com.silverpeas.form.AbstractField;
import com.silverpeas.form.FormException;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class UserField
extends AbstractField {
    private static final long serialVersionUID = -861888647155176647L;
    public static final String TYPE = "user";
    private String userId = null;

    @Override
    public String getTypeName() {
        return TYPE;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        SilverTrace.info("form", "UserField.setUserId", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId);
        this.userId = userId;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getValue() {
        String theUserId = this.getUserId();
        SilverTrace.info("form", "UserField.getValue", "root.MSG_GEN_PARAM_VALUE", "userId = " + theUserId);
        if (!StringUtil.isDefined(theUserId)) {
            return theUserId;
        }
        UserDetail user = OrganisationControllerFactory.getOrganisationController().getUserDetail(this.getUserId());
        if (user == null) {
            return "user(" + this.getUserId() + ")";
        }
        return user.getDisplayedName();
    }

    @Override
    public String getValue(String language) {
        return this.getValue();
    }

    @Override
    public void setValue(String value) throws FormException {
    }

    @Override
    public void setValue(String value, String language) throws FormException {
    }

    @Override
    public boolean acceptValue(String value) {
        return false;
    }

    @Override
    public boolean acceptValue(String value, String language) {
        return false;
    }

    @Override
    public Object getObjectValue() {
        if (this.getUserId() == null) {
            return null;
        }
        return OrganisationControllerFactory.getOrganisationController().getUserDetail(this.getUserId());
    }

    @Override
    public void setObjectValue(Object value) throws FormException {
        if (value instanceof UserDetail) {
            this.setUserId(((UserDetail)value).getId());
        } else if (value == null) {
            this.setUserId("");
        } else {
            throw new FormException("UserField.setObjectValue", "form.EXP_NOT_AN_USER");
        }
    }

    @Override
    public boolean acceptObjectValue(Object value) {
        if (value instanceof UserDetail) {
            return !this.isReadOnly();
        }
        return false;
    }

    @Override
    public String getStringValue() {
        return this.getUserId();
    }

    @Override
    public void setStringValue(String value) {
        SilverTrace.info("form", "UserField.setStringValue", "root.MSG_GEN_ENTER_METHOD", "value = " + value);
        this.setUserId(value);
    }

    @Override
    public boolean acceptStringValue(String value) {
        return !this.isReadOnly();
    }

    @Override
    public boolean isNull() {
        return this.getUserId() == null;
    }

    @Override
    public void setNull() throws FormException {
        this.setUserId(null);
    }

    public boolean equals(Object o) {
        String s = this.getUserId();
        if (s == null) {
            s = "";
        }
        if (o instanceof UserField) {
            String t = ((UserField)o).getUserId();
            if (t == null) {
                t = "";
            }
            return s.equals(t);
        }
        return false;
    }

    @Override
    public int compareTo(Object o) {
        String s = this.getValue();
        if (s == null) {
            s = "";
        }
        if (o instanceof UserField) {
            String t = ((UserField)o).getValue();
            if (t == null) {
                t = "";
            }
            if (s.equals(t)) {
                s = this.getUserId();
                if (s == null) {
                    s = "";
                }
                if ((t = ((UserField)o).getUserId()) == null) {
                    t = "";
                }
            }
            return s.compareTo(t);
        }
        return -1;
    }

    public int hashCode() {
        String s = this.getUserId();
        return ("" + s).hashCode();
    }
}

