/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.form;

import com.silverpeas.form.AbstractForm;
import com.silverpeas.form.DataRecord;
import com.silverpeas.form.Field;
import com.silverpeas.form.FieldDisplayer;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.form.TypeManager;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.WysiwygFCKFieldDisplayer;
import com.silverpeas.form.record.GenericFieldTemplate;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspWriter;

public class XmlForm
extends AbstractForm {
    public XmlForm(RecordTemplate template) throws FormException {
        super(template);
    }

    public XmlForm(RecordTemplate template, boolean viewForm) throws FormException {
        super(template);
        this.setViewForm(viewForm);
    }

    @Override
    public String toString(PagesContext pagesContext, DataRecord record) {
        SilverTrace.info("form", "XmlForm.toString", "root.MSG_GEN_ENTER_METHOD");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        this.display(pw, pagesContext, record);
        return sw.toString();
    }

    private void display(PrintWriter out, PagesContext pageContext, DataRecord record) {
        SilverTrace.info("form", "XmlForm.display", "root.MSG_GEN_ENTER_METHOD");
        String language = pageContext.getLanguage();
        pageContext.setContentLanguage(record.getLanguage());
        String mode = "";
        if (pageContext.isDesignMode()) {
            mode = "mode-design";
        }
        out.println("<div class=\"forms " + this.getFormName() + " " + mode + "\">");
        if (record != null) {
            out.println("<input type=\"hidden\" name=\"id\" value=\"" + record.getId() + "\"/>");
        }
        if (pageContext.getPrintTitle() && StringUtil.isDefined(this.getTitle())) {
            out.println("<h2 class=\"form-title\">");
            out.println(this.getTitle());
            out.println("</h2>");
        }
        List<FieldTemplate> listFields = this.getFieldTemplates();
        boolean mandatory = false;
        if (listFields != null && !listFields.isEmpty()) {
            if (pageContext.isBorderPrinted()) {
                out.println("<ul class=\"fields form-border\">");
            } else {
                out.println("<ul class=\"fields\">");
            }
            out.flush();
            PagesContext pc = new PagesContext(pageContext);
            pc.setNbFields(listFields.size());
            if (record != null) {
                pc.incCurrentFieldIndex(1);
            }
            pc.setLastFieldIndex(this.getLastFieldIndex(pageContext, record, listFields));
            for (FieldTemplate fieldTemplate : listFields) {
                Map<String, String> parameters = fieldTemplate.getParameters(language);
                String fieldName = fieldTemplate.getFieldName();
                String fieldLabel = fieldTemplate.getLabel(language);
                String fieldType = fieldTemplate.getTypeName();
                String fieldDisplayerName = fieldTemplate.getDisplayerName();
                boolean isMandatory = fieldTemplate.isMandatory();
                boolean isDisabled = fieldTemplate.isDisabled();
                boolean isReadOnly = fieldTemplate.isReadOnly();
                boolean isHidden = fieldTemplate.isHidden();
                String fieldClass = "";
                if (parameters.containsKey("classLabel")) {
                    fieldClass = parameters.get("classLabel");
                }
                Field field = null;
                if (record != null) {
                    try {
                        field = record.getField(fieldName);
                    }
                    catch (FormException fe) {
                        SilverTrace.error("form", "XmlForm.display", "form.EXP_UNKNOWN_FIELD", null, fe);
                    }
                }
                boolean displayField = true;
                if (this.isViewForm() && !Util.isEmptyFieldsDisplayed() && (displayField = StringUtil.isDefined(field.getStringValue())) && field.getStringValue().startsWith("xmlWysiwygField_")) {
                    displayField = this.isWYSIWYGFieldDefined(fieldName, pageContext);
                }
                if (!displayField || record != null && (record == null || field == null)) continue;
                FieldDisplayer fieldDisplayer = null;
                try {
                    if (!StringUtil.isDefined(fieldDisplayerName)) {
                        fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
                    }
                    fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName);
                }
                catch (FormException fe) {
                    SilverTrace.error("form", "XmlForm.display", "form.EXP_UNKNOWN_DISPLAYER", null, fe);
                }
                if (fieldDisplayer != null) {
                    String aClass = "class=\"txtlibform\"";
                    if (StringUtil.isDefined(fieldClass)) {
                        aClass = "class=\"txtlibform " + fieldClass + "\"";
                    }
                    String technicalNameHelp = "";
                    if (pageContext.isDesignMode()) {
                        technicalNameHelp = " title=\"" + fieldName + "\"";
                    }
                    out.println("<li class=\"field field_" + fieldName + "\" id=\"form-row-" + fieldName + "\">");
                    out.println("<label for=\"" + fieldName + "\" " + aClass + technicalNameHelp + ">" + fieldLabel + "</label>");
                    out.println("<div class=\"fieldInput\">");
                    if (!fieldTemplate.isRepeatable()) {
                        field = this.getSureField(fieldTemplate, record, 0);
                        try {
                            fieldDisplayer.display(out, field, fieldTemplate, pc);
                        }
                        catch (FormException fe) {
                            SilverTrace.error("form", "XmlForm.display", "form.EX_CANT_GET_FORM", null, fe);
                        }
                    } else {
                        boolean isWriting = !"simpletext".equals(fieldTemplate.getDisplayerName()) && !fieldTemplate.isReadOnly();
                        String currentVisibility = "field-occurrence-shown";
                        int maxOccurrences = fieldTemplate.getMaximumNumberOfOccurrences();
                        Field lastNotEmptyField = this.getLastNotEmptyField(record, fieldName, maxOccurrences);
                        out.println("<ul class=\"repeatable-field-list\">");
                        for (int occ = 0; occ < maxOccurrences; ++occ) {
                            field = this.getSureField(fieldTemplate, record, occ);
                            if (occ > 0) {
                                ((GenericFieldTemplate)fieldTemplate).setMandatory(false);
                                currentVisibility = !isWriting ? (field.isNull() ? "field-occurrence-hidden" : "field-occurrence-shown") : (lastNotEmptyField == null || occ > lastNotEmptyField.getOccurrence() ? "field-occurrence-hidden" : "field-occurrence-shown");
                            }
                            out.println("<li class=\"" + currentVisibility + " repeatable-field-list-element" + occ + "\">");
                            try {
                                fieldDisplayer.display(out, field, fieldTemplate, pc);
                            }
                            catch (FormException fe) {
                                SilverTrace.error("form", "XmlForm.display", "form.EX_CANT_GET_FORM", null, fe);
                            }
                            out.println("</li>");
                        }
                        out.println("</ul>");
                        if (isWriting && (lastNotEmptyField == null || lastNotEmptyField.getOccurrence() < maxOccurrences - 1)) {
                            Util.printOneMoreInputSnippet(fieldName, pc, out);
                        }
                    }
                    if (pageContext.isDesignMode()) {
                        out.println("<span class=\"actions\">");
                        out.println("<a title=\"" + Util.getString("GML.modify", language) + "\" href=\"#\" onclick=\"editField('" + fieldName + "','" + fieldDisplayerName + "');return false;\"><img alt=\"" + Util.getString("GML.modify", language) + "\" src=\"/silverpeas/util/icons/update.gif\"/></a>");
                        out.println("<a title=\"" + Util.getString("GML.delete", language) + "\" href=\"#\" onclick=\"deleteField('" + fieldName + "');return false;\"><img alt=\"" + Util.getString("GML.delete", language) + "\" src=\"/silverpeas/util/icons/delete.gif\"/></a>");
                        out.println("</span>");
                    }
                    out.println("</div>");
                    out.println("</li>");
                }
                if (isMandatory && !isDisabled && !isHidden && fieldDisplayer.isDisplayedMandatory() && (!isReadOnly || "jdbcRef".equals(fieldType))) {
                    mandatory = true;
                }
                out.flush();
                pc.incCurrentFieldIndex(fieldDisplayer.getNbHtmlObjectsDisplayed(fieldTemplate, pc));
            }
        }
        out.println("</ul>");
        if (mandatory) {
            out.println("<div class=\"legend\">");
            out.println(Util.getMandatorySnippet() + "&nbsp;:&nbsp;" + Util.getString("GML.requiredField", language));
            out.println("</div>");
        }
        out.println("</div>");
        out.flush();
    }

    @Override
    public void display(JspWriter jw, PagesContext pageContext, DataRecord record) {
        PrintWriter out = new PrintWriter((Writer)jw, true);
        this.display(out, pageContext, record);
    }

    private int getLastFieldIndex(PagesContext pc, DataRecord record, List<FieldTemplate> listFields) {
        int lastFieldIndex = -1;
        lastFieldIndex += Integer.parseInt(pc.getCurrentFieldIndex());
        for (FieldTemplate fieldTemplate : listFields) {
            if (fieldTemplate == null) continue;
            String fieldName = fieldTemplate.getFieldName();
            String fieldType = fieldTemplate.getTypeName();
            String fieldDisplayerName = fieldTemplate.getDisplayerName();
            Field field = null;
            if (record != null) {
                try {
                    field = record.getField(fieldName);
                }
                catch (FormException fe) {
                    SilverTrace.error("form", "XmlForm.display", "form.EXP_UNKNOWN_FIELD", null, fe);
                }
            }
            if (record != null && (record == null || field == null)) continue;
            try {
                FieldDisplayer fieldDisplayer;
                if (!StringUtil.isDefined(fieldDisplayerName)) {
                    fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
                }
                if ((fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName)) == null) continue;
                lastFieldIndex += fieldDisplayer.getNbHtmlObjectsDisplayed(fieldTemplate, pc);
            }
            catch (FormException fe) {
                SilverTrace.error("form", "XmlForm.getLastFieldIndex", "form.EXP_UNKNOWN_DISPLAYER", null, fe);
            }
        }
        return lastFieldIndex;
    }

    private Field getLastNotEmptyField(DataRecord record, String fieldName, int nbOccurrences) {
        Field lastNotEmptyField = null;
        for (int occ = 0; occ < nbOccurrences; ++occ) {
            Field field = record.getField(fieldName, occ);
            if (field == null || field.isNull()) continue;
            lastNotEmptyField = field;
        }
        return lastNotEmptyField;
    }

    private TypeManager getTypeManager() {
        return TypeManager.getInstance();
    }

    private boolean isWYSIWYGFieldDefined(String fieldName, PagesContext pc) {
        String contentLanguage = I18NHelper.checkLanguage(pc.getContentLanguage());
        String content = WysiwygFCKFieldDisplayer.getContentFromFile(pc.getComponentId(), pc.getObjectId(), fieldName, contentLanguage);
        return StringUtil.isDefined(content);
    }
}

