/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.delayed.model;

import com.silverpeas.notification.delayed.model.DelayedNotificationUserSetting;
import com.silverpeas.notification.model.NotificationResourceData;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.notificationManager.NotificationParameters;
import com.stratelia.silverpeas.notificationManager.constant.NotifAction;
import com.stratelia.silverpeas.notificationManager.constant.NotifChannel;
import com.stratelia.silverpeas.notificationserver.NotificationData;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;

@Entity
@Table(name="st_delayednotification")
public class DelayedNotificationData
implements Serializable {
    private static final long serialVersionUID = 3477090528448919931L;
    @Id
    @TableGenerator(name="UNIQUE_ID_GEN", table="uniqueId", pkColumnName="tablename", valueColumnName="maxId", pkColumnValue="st_delayednotification", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="UNIQUE_ID_GEN")
    @Column(name="id")
    private Long id;
    @Column(name="userId", nullable=false)
    private Integer userId;
    @Column(name="fromUserId", nullable=false)
    private Integer fromUserId;
    @Column(name="channel", nullable=false)
    private Integer channel;
    @Column(name="action", nullable=false)
    private Integer action;
    @Column(name="language", nullable=false)
    private String language;
    @Column(name="creationDate", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;
    @Column(name="message", nullable=true)
    private String message;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="notificationResourceId", referencedColumnName="id", nullable=false)
    private NotificationResourceData resource;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="userId", referencedColumnName="userId", insertable=false, updatable=false), @JoinColumn(name="channel", referencedColumnName="channel", insertable=false, updatable=false)})
    private DelayedNotificationUserSetting delayedNotificationUserSetting;
    @Transient
    private boolean sendImmediately = false;
    @Transient
    private NotificationData notificationData;
    @Transient
    private NotificationParameters notificationParameters;

    public boolean isValid() {
        return this.getUserId() != null && this.getFromUserId() != null && this.getChannel() != null && this.getAction() != null && StringUtils.isNotBlank((String)this.getLanguage()) && this.getResource() != null && this.getResource().isValid();
    }

    @PrePersist
    public void beforePersist() {
        this.creationDate = new Date();
        if (!StringUtils.isNotBlank((String)this.language)) {
            this.language = I18NHelper.defaultLanguage;
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public void setUserId(String userId) {
        this.userId = new Integer(userId);
    }

    public Integer getFromUserId() {
        return this.fromUserId;
    }

    public void setFromUserId(Integer fromUserId) {
        this.fromUserId = fromUserId;
    }

    public NotifChannel getChannel() {
        return NotifChannel.decode(this.channel);
    }

    public void setChannel(NotifChannel channel) {
        this.channel = channel != null ? Integer.valueOf(channel.getId()) : null;
    }

    public NotifAction getAction() {
        return NotifAction.decode(this.action);
    }

    public void setAction(NotifAction action) {
        this.action = action != null ? Integer.valueOf(action.getId()) : null;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public NotificationResourceData getResource() {
        return this.resource;
    }

    public void setResource(NotificationResourceData resource) {
        this.resource = resource;
    }

    public DelayedNotificationUserSetting getDelayedNotificationUserSetting() {
        return this.delayedNotificationUserSetting;
    }

    public void setDelayedNotificationUserSetting(DelayedNotificationUserSetting delayedNotificationUserSetting) {
        this.delayedNotificationUserSetting = delayedNotificationUserSetting;
    }

    public boolean isSendImmediately() {
        return this.sendImmediately;
    }

    public void setSendImmediately(boolean sendImmediately) {
        this.sendImmediately = sendImmediately;
    }

    public NotificationData getNotificationData() {
        return this.notificationData;
    }

    public void setNotificationData(NotificationData notificationData) {
        this.notificationData = notificationData;
    }

    public NotificationParameters getNotificationParameters() {
        return this.notificationParameters;
    }

    public void setNotificationParameters(NotificationParameters notificationParameters) {
        this.notificationParameters = notificationParameters;
    }
}

