/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.jms.access;

import com.silverpeas.notification.jms.access.ConnectionFailureListener;
import com.silverpeas.notification.jms.access.SilverpeasTopicPublisher;
import com.silverpeas.notification.jms.access.SilverpeasTopicSubscriber;
import com.stratelia.webactiv.util.JNDINames;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;

@Named
public final class JMSAccessObject {
    private TopicConnection topicConnection;
    private TopicSession subscriptionSession;
    private TopicSession publishingSession;
    private ExceptionListener exceptionListener = new ConnectionExceptionListener();
    private Set<ConnectionFailureListener> listeners = new HashSet<ConnectionFailureListener>();
    static final String PREFIX_TOPIC_JNDI = "java:/topic/";

    public Topic getExistingTopic(String name) throws NamingException {
        try {
            return (Topic)InitialContext.doLookup(PREFIX_TOPIC_JNDI + name);
        }
        catch (NamingException ex) {
            NamingException namingException = new NamingException("No such topic '" + name + "' or its name doesn't match its JNDI name according to the pattern '" + PREFIX_TOPIC_JNDI + "TOPIC_NAME' with TOPIC_NAME the topic name");
            namingException.initCause(ex);
            throw namingException;
        }
    }

    public TopicSubscriber createTopicSubscriber(String topicName, String subscriberId, MessageListener listener) throws JMSException, NamingException {
        Topic topic = this.getExistingTopic(topicName);
        TopicSession session = this.getTopicSessionForSubscription();
        SilverpeasTopicSubscriber topicSubscriber = SilverpeasTopicSubscriber.decorateTopicSubscriber(session.createSubscriber(topic));
        topicSubscriber.setMessageListener(listener);
        topicSubscriber.setSession((Session)session);
        topicSubscriber.setId(subscriberId);
        return topicSubscriber;
    }

    public void disposeTopicSubscriber(TopicSubscriber subscriber) throws JMSException {
        SilverpeasTopicSubscriber silverpeasSubscriber = (SilverpeasTopicSubscriber)subscriber;
        Session session = silverpeasSubscriber.getSession();
        subscriber.close();
        this.releaseSession(session);
    }

    public TopicPublisher createTopicPublisher(String topicName) throws NamingException, JMSException {
        Topic topic = this.getExistingTopic(topicName);
        TopicSession session = this.getTopicSessionForPublishing();
        SilverpeasTopicPublisher topicPublisher = SilverpeasTopicPublisher.decorateTopicPublisher(session.createPublisher(topic));
        topicPublisher.setSession((Session)session);
        return topicPublisher;
    }

    public void disposeTopicPublisher(TopicPublisher publisher) throws JMSException {
        Session session = ((SilverpeasTopicPublisher)publisher).getSession();
        publisher.close();
        this.releaseSession(session);
    }

    public ObjectMessage createObjectMessageFor(TopicPublisher publisher) throws JMSException {
        SilverpeasTopicPublisher topicPublisher = (SilverpeasTopicPublisher)publisher;
        Session session = topicPublisher.getSession();
        return session.createObjectMessage();
    }

    public void addConnectionFailureListener(ConnectionFailureListener listener) {
        this.listeners.add(listener);
    }

    protected TopicSession getTopicSessionForPublishing() {
        return this.publishingSession;
    }

    protected TopicSession getTopicSessionForSubscription() {
        return this.subscriptionSession;
    }

    protected void releaseSession(Session session) throws JMSException {
        if (this.subscriptionSession != session && this.publishingSession != session) {
            session.close();
        }
    }

    @PostConstruct
    protected void openConnection() throws NamingException, JMSException {
        TopicConnectionFactory connectionFactory = (TopicConnectionFactory)InitialContext.doLookup(JNDINames.NOTIF_API_JMS);
        this.topicConnection = connectionFactory.createTopicConnection();
        this.topicConnection.setClientID("Silverpeas");
        this.topicConnection.setExceptionListener(this.exceptionListener);
        this.topicConnection.start();
        this.publishingSession = this.topicConnection.createTopicSession(false, 1);
        this.subscriptionSession = this.topicConnection.createTopicSession(false, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    protected void closeConnection() throws JMSException {
        try {
            this.subscriptionSession.close();
            this.publishingSession.close();
            this.topicConnection.stop();
            this.topicConnection.close();
        }
        finally {
            this.subscriptionSession = null;
            this.publishingSession = null;
        }
    }

    protected Set<ConnectionFailureListener> getConnectionFailureListeners() {
        return this.listeners;
    }

    public class ConnectionExceptionListener
    implements ExceptionListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(JMSException jmse) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.WARNING, "The connection with the remote JMS server was unexpectedly closed! I'm going to reopen it.");
            try {
                JMSAccessObject.this.closeConnection();
            }
            catch (Exception ex) {
                Logger.getLogger(JMSAccessObject.class.getName()).log(Level.SEVERE, ex.getMessage());
            }
            finally {
                try {
                    JMSAccessObject.this.openConnection();
                    this.informListeners();
                }
                catch (Exception ex) {
                    Logger.getLogger(JMSAccessObject.class.getName()).log(Level.SEVERE, ex.getMessage());
                }
            }
        }

        private void informListeners() {
            for (ConnectionFailureListener listener : JMSAccessObject.this.getConnectionFailureListeners()) {
                listener.onConnectionFailure();
            }
        }
    }
}

