/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.scheduler.trigger;

import com.silverpeas.scheduler.trigger.JobTriggerFactory;
import com.silverpeas.scheduler.trigger.JobTriggerVisitor;
import com.silverpeas.scheduler.trigger.TimeUnit;
import com.silverpeas.util.AssertArgument;
import java.text.ParseException;
import java.util.Date;

public abstract class JobTrigger {
    private Date startDate;

    public abstract void accept(JobTriggerVisitor var1);

    public Date getStartDate() {
        return this.startDate;
    }

    public static JobTrigger triggerEvery(int time, TimeUnit unit) {
        JobTriggerFactory triggerFactory = JobTriggerFactory.getFactory();
        return triggerFactory.getJobTriggerWithPeriodicity(time, unit);
    }

    public static JobTrigger triggerAt(String cron) throws ParseException {
        JobTriggerFactory triggerFactory = JobTriggerFactory.getFactory();
        return triggerFactory.getJobTriggerWithCronExpression(cron);
    }

    public JobTrigger startAt(Date startDate) {
        AssertArgument.assertNotNull(startDate, "Either the start date of the job is null or it is anterior at now!");
        this.startDate = startDate;
        return this;
    }
}

