/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.provider;

import com.silverpeas.calendar.Date;
import com.silverpeas.socialnetwork.SocialNetworkException;
import com.silverpeas.socialnetwork.model.SocialInformation;
import com.silverpeas.socialnetwork.model.SocialInformationType;
import com.silverpeas.socialnetwork.provider.ProviderSwitchInterface;
import com.silverpeas.socialnetwork.provider.SocialCommentGalleryInterface;
import com.silverpeas.socialnetwork.provider.SocialCommentPublicationsInterface;
import com.silverpeas.socialnetwork.provider.SocialCommentQuickInfosInterface;
import com.silverpeas.socialnetwork.provider.SocialEventsInterface;
import com.silverpeas.socialnetwork.provider.SocialGalleryInterface;
import com.silverpeas.socialnetwork.provider.SocialPublicationsInterface;
import com.silverpeas.socialnetwork.provider.SocialRelationShipsInterface;
import com.silverpeas.socialnetwork.provider.SocialStatusInterface;
import com.stratelia.webactiv.util.exception.SilverpeasException;
import java.util.ArrayList;
import java.util.List;

public class ProviderSwitch
implements ProviderSwitchInterface {
    private SocialEventsInterface socialEventsInterface;
    private SocialGalleryInterface socialGalleryInterface;
    private SocialCommentGalleryInterface socialCommentGalleryInterface;
    private SocialPublicationsInterface socialPublicationsInterface;
    private SocialCommentPublicationsInterface socialCommentPublicationsInterface;
    private SocialCommentQuickInfosInterface socialCommentQuickInfosInterface;
    private SocialStatusInterface socialStatusInterface;
    private SocialRelationShipsInterface socialRelationShipsInterface;

    @Override
    public SocialEventsInterface getSocialEventsInterface() {
        return this.socialEventsInterface;
    }

    @Override
    public void setSocialEventsInterface(SocialEventsInterface socialEventsInterface) {
        this.socialEventsInterface = socialEventsInterface;
    }

    @Override
    public SocialGalleryInterface getSocialGalleryInterface() {
        return this.socialGalleryInterface;
    }

    @Override
    public void setSocialGalleryInterface(SocialGalleryInterface socialGalleryInterface) {
        this.socialGalleryInterface = socialGalleryInterface;
    }

    @Override
    public SocialCommentGalleryInterface getSocialCommentGalleryInterface() {
        return this.socialCommentGalleryInterface;
    }

    @Override
    public void setSocialCommentGalleryInterface(SocialCommentGalleryInterface socialCommentGalleryInterface) {
        this.socialCommentGalleryInterface = socialCommentGalleryInterface;
    }

    @Override
    public List<SocialInformation> getSocialInformationsList(SocialInformationType socialInformationType, String userId, String classification, Date begin, Date end) throws SocialNetworkException {
        List<SocialInformation> listResult = new ArrayList<SocialInformation>();
        try {
            switch (socialInformationType) {
                case EVENT: {
                    listResult = this.getSocialEventsInterface().getSocialInformationsList(userId, classification, begin, end);
                    break;
                }
                case MEDIA: {
                    listResult = this.getSocialGalleryInterface().getSocialInformationsList(userId, begin, end);
                    List<SocialInformation> listCommentMedia = this.getSocialInformationsList(SocialInformationType.COMMENTMEDIA, userId, classification, begin, end);
                    if (listCommentMedia == null) break;
                    listResult.addAll(listCommentMedia);
                    break;
                }
                case COMMENTMEDIA: {
                    listResult = this.getSocialCommentGalleryInterface().getSocialInformationsList(userId, begin, end);
                    break;
                }
                case PUBLICATION: {
                    listResult = this.getSocialPublicationsInterface().getSocialInformationsList(userId, begin, end);
                    List<SocialInformation> listCommentPublication = this.getSocialInformationsList(SocialInformationType.COMMENTPUBLICATION, userId, classification, begin, end);
                    if (listCommentPublication == null) break;
                    listResult.addAll(listCommentPublication);
                    break;
                }
                case COMMENTPUBLICATION: {
                    listResult = this.getSocialCommentPublicationsInterface().getSocialInformationsList(userId, begin, end);
                    List<SocialInformation> listCommentNews = this.getSocialInformationsList(SocialInformationType.COMMENTNEWS, userId, classification, begin, end);
                    if (listCommentNews == null) break;
                    listResult.addAll(listCommentNews);
                    break;
                }
                case COMMENTNEWS: {
                    listResult = this.getSocialCommentQuickInfosInterface().getSocialInformationsList(userId, begin, end);
                    break;
                }
                case COMMENT: {
                    List<SocialInformation> listCommentGallery;
                    List<SocialInformation> listCommentKmeliaBlogQuickInfos = this.getSocialInformationsList(SocialInformationType.COMMENTPUBLICATION, userId, classification, begin, end);
                    if (listCommentKmeliaBlogQuickInfos != null) {
                        listResult.addAll(listCommentKmeliaBlogQuickInfos);
                    }
                    if ((listCommentGallery = this.getSocialInformationsList(SocialInformationType.COMMENTMEDIA, userId, classification, begin, end)) == null) break;
                    listResult.addAll(listCommentGallery);
                    break;
                }
                case STATUS: {
                    listResult = this.getSocialStatusInterface().getSocialInformationsList(userId, begin, end);
                    break;
                }
                case RELATIONSHIP: {
                    listResult = this.getSocialRelationShipsInterface().getSocialInformationsList(userId, begin, end);
                    break;
                }
                case LASTEVENT: {
                    listResult = this.getSocialEventsInterface().getMyLastSocialInformationsList(userId, begin, end);
                    break;
                }
                case ALL: {
                    for (SocialInformationType type : SocialInformationType.values()) {
                        List<SocialInformation> listAll;
                        if (SocialInformationType.ALL == type || SocialInformationType.EVENT == type || SocialInformationType.COMMENT == type || SocialInformationType.COMMENTPUBLICATION == type || SocialInformationType.COMMENTNEWS == type || SocialInformationType.COMMENTMEDIA == type || (listAll = this.getSocialInformationsList(type, userId, classification, begin, end)) == null) continue;
                        listResult.addAll(listAll);
                    }
                    break;
                }
            }
        }
        catch (SilverpeasException ex) {
            throw new SocialNetworkException("ProviderSwitch.getSocialInformationsList", 4, "root.EX_CANT_GET_REMOTE_OBJECT", ex);
        }
        return listResult;
    }

    @Override
    public SocialPublicationsInterface getSocialPublicationsInterface() {
        return this.socialPublicationsInterface;
    }

    @Override
    public void setSocialPublicationsInterface(SocialPublicationsInterface socialPublicationsInterface) {
        this.socialPublicationsInterface = socialPublicationsInterface;
    }

    @Override
    public SocialCommentPublicationsInterface getSocialCommentPublicationsInterface() {
        return this.socialCommentPublicationsInterface;
    }

    @Override
    public void setSocialCommentPublicationsInterface(SocialCommentPublicationsInterface socialCommentPublicationsInterface) {
        this.socialCommentPublicationsInterface = socialCommentPublicationsInterface;
    }

    @Override
    public SocialCommentQuickInfosInterface getSocialCommentQuickInfosInterface() {
        return this.socialCommentQuickInfosInterface;
    }

    @Override
    public void setSocialCommentQuickInfosInterface(SocialCommentQuickInfosInterface socialCommentQuickInfosInterface) {
        this.socialCommentQuickInfosInterface = socialCommentQuickInfosInterface;
    }

    @Override
    public SocialStatusInterface getSocialStatusInterface() {
        return this.socialStatusInterface;
    }

    @Override
    public void setSocialStatusInterface(SocialStatusInterface socialStatusInterface) {
        this.socialStatusInterface = socialStatusInterface;
    }

    @Override
    public void setSocialRelationShipsInterface(SocialRelationShipsInterface socialRelationShipsInterface) {
        this.socialRelationShipsInterface = socialRelationShipsInterface;
    }

    @Override
    public SocialRelationShipsInterface getSocialRelationShipsInterface() {
        return this.socialRelationShipsInterface;
    }

    @Override
    public List<SocialInformation> getSocialInformationsListOfMyContacts(SocialInformationType socialInformationType, String myId, List<String> myContactsIds, Date begin, Date end) throws SilverpeasException {
        List<SocialInformation> list = new ArrayList<SocialInformation>();
        try {
            switch (socialInformationType) {
                case EVENT: {
                    list = this.getSocialEventsInterface().getSocialInformationsListOfMyContacts(myId, myContactsIds, begin, end);
                    break;
                }
                case MEDIA: {
                    list = this.getSocialGalleryInterface().getSocialInformationsListOfMyContacts(myId, myContactsIds, begin, end);
                    List<SocialInformation> listCommentMedia = this.getSocialInformationsListOfMyContacts(SocialInformationType.COMMENTMEDIA, myId, myContactsIds, begin, end);
                    if (listCommentMedia == null) break;
                    list.addAll(listCommentMedia);
                    break;
                }
                case COMMENTMEDIA: {
                    list = this.getSocialCommentGalleryInterface().getSocialInformationsListOfMyContacts(myId, myContactsIds, begin, end);
                    break;
                }
                case PUBLICATION: {
                    list = this.getSocialPublicationsInterface().getSocialInformationsListOfMyContacts(myId, myContactsIds, begin, end);
                    List<SocialInformation> listCommentPublication = this.getSocialInformationsListOfMyContacts(SocialInformationType.COMMENTPUBLICATION, myId, myContactsIds, begin, end);
                    if (listCommentPublication == null) break;
                    list.addAll(listCommentPublication);
                    break;
                }
                case COMMENTPUBLICATION: {
                    list = this.getSocialCommentPublicationsInterface().getSocialInformationsListOfMyContacts(myId, myContactsIds, begin, end);
                    List<SocialInformation> listCommentNews = this.getSocialInformationsListOfMyContacts(SocialInformationType.COMMENTNEWS, myId, myContactsIds, begin, end);
                    if (listCommentNews == null) break;
                    list.addAll(listCommentNews);
                    break;
                }
                case COMMENTNEWS: {
                    list = this.getSocialCommentQuickInfosInterface().getSocialInformationsListOfMyContacts(myId, myContactsIds, begin, end);
                    break;
                }
                case COMMENT: {
                    List<SocialInformation> listCommentGallery;
                    List<SocialInformation> listCommentKmeliaBlogQuickInfos = this.getSocialInformationsListOfMyContacts(SocialInformationType.COMMENTPUBLICATION, myId, myContactsIds, begin, end);
                    if (listCommentKmeliaBlogQuickInfos != null) {
                        list.addAll(listCommentKmeliaBlogQuickInfos);
                    }
                    if ((listCommentGallery = this.getSocialInformationsListOfMyContacts(SocialInformationType.COMMENTMEDIA, myId, myContactsIds, begin, end)) == null) break;
                    list.addAll(listCommentGallery);
                    break;
                }
                case STATUS: {
                    list = this.getSocialStatusInterface().getSocialInformationsListOfMyContacts(myContactsIds, begin, end);
                    break;
                }
                case RELATIONSHIP: {
                    list = this.getSocialRelationShipsInterface().getSocialInformationsListOfMyContacts(myId, myContactsIds, begin, end);
                    break;
                }
                case LASTEVENT: {
                    list = this.getSocialEventsInterface().getLastSocialInformationsListOfMyContacts(myId, myContactsIds, begin, end);
                    break;
                }
                case ALL: {
                    for (SocialInformationType type : SocialInformationType.values()) {
                        List<SocialInformation> listAll;
                        if (SocialInformationType.ALL == type || SocialInformationType.EVENT == type || SocialInformationType.COMMENT == type || SocialInformationType.COMMENTPUBLICATION == type || SocialInformationType.COMMENTNEWS == type || SocialInformationType.COMMENTMEDIA == type || (listAll = this.getSocialInformationsListOfMyContacts(type, myId, myContactsIds, begin, end)) == null) continue;
                        list.addAll(listAll);
                    }
                    break;
                }
            }
        }
        catch (SilverpeasException ex) {
            throw new SocialNetworkException("ProviderSwitch.getSocialInformationsListOfMyContacts", 4, "root.EX_CANT_GET_REMOTE_OBJECT", ex);
        }
        return list;
    }
}

