/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.authentication.security;

import com.stratelia.silverpeas.authentication.security.SecurityData;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class SecurityCache {
    private static final String CACHE_NAME = "userIds";
    private static final int MAX_ELEMENTS = 1000000;
    private static final boolean USE_DISK_STORE = false;
    private static final boolean ETERNAL_ELEMENTS = false;
    private static final int TIME_TO_LIVE = 43200;
    private static final int TIME_TO_IDLE = 43200;
    private CacheManager manager = new CacheManager();

    public SecurityCache() {
        this.manager.addCache(new Cache(CACHE_NAME, 1000000, false, false, 43200L, 43200L));
    }

    public void addData(String sessionId, String userId, String domainId) {
        this.getCache().put(new Element((Object)sessionId, (Object)new SecurityData(userId, domainId)));
    }

    public SecurityData getData(String sessionId) {
        Element userElement = this.getCache().get((Serializable)((Object)sessionId));
        if (userElement != null) {
            if (userElement.isExpired()) {
                this.getCache().remove((Serializable)((Object)sessionId));
            } else {
                return (SecurityData)userElement.getObjectValue();
            }
        }
        return null;
    }

    public boolean isUserIdDefined(String sessionId) {
        Element userElement = this.getCache().get((Serializable)((Object)sessionId));
        return userElement != null && !userElement.isExpired();
    }

    private Cache getCache() {
        return this.manager.getCache(CACHE_NAME);
    }
}

