/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.domains.sqldriver;

import com.stratelia.silverpeas.domains.sqldriver.SQLSettings;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SQLGroupUserRelTable {
    SQLSettings drvSettings = new SQLSettings();

    public SQLGroupUserRelTable(SQLSettings ds) {
        this.drvSettings = ds;
    }

    public List<String> getDirectUserIdsOfGroup(Connection c, int groupId) throws AdminException {
        ResultSet rs = null;
        PreparedStatement statement = null;
        ArrayList<String> theResult = new ArrayList<String>();
        String theQuery = "select " + this.drvSettings.getRelUIDColumnName() + " from " + this.drvSettings.getRelTableName() + " where " + this.drvSettings.getRelGIDColumnName() + " = ?";
        try {
            SilverTrace.debug("admin", "SQLGroupUserRelTable.getDirectUserIdsOfGroup", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, groupId);
            rs = statement.executeQuery();
            while (rs.next()) {
                theResult.add(Integer.toString(rs.getInt(1)));
            }
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLGroupUserRelTable.getDirectUserIdsOfGroup", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close(rs, statement);
        return theResult;
    }

    public List<String> getDirectGroupIdsOfUser(Connection c, int userId) throws AdminException {
        ResultSet rs = null;
        PreparedStatement statement = null;
        ArrayList<String> theResult = new ArrayList<String>();
        String theQuery = "select " + this.drvSettings.getRelGIDColumnName() + " from " + this.drvSettings.getRelTableName() + " where " + this.drvSettings.getRelUIDColumnName() + " = ?";
        try {
            SilverTrace.debug("admin", "SQLGroupUserRelTable.getDirectGroupIdsOfUser", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, userId);
            rs = statement.executeQuery();
            while (rs.next()) {
                theResult.add(Integer.toString(rs.getInt(1)));
            }
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLGroupUserRelTable.getDirectGroupIdsOfUser", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close(rs, statement);
        return theResult;
    }

    public int createGroupUserRel(Connection c, int groupId, int userId) throws AdminException {
        int n;
        PreparedStatement statement = null;
        String theQuery = "insert into " + this.drvSettings.getRelTableName() + "(" + this.drvSettings.getRelGIDColumnName() + "," + this.drvSettings.getRelUIDColumnName() + ") " + " values (?,?)";
        try {
            SilverTrace.debug("admin", "SQLGroupUserRelTable.createGroupUserRel", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, groupId);
            statement.setInt(2, userId);
            n = statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLGroupUserRelTable.createGroupUserRel", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return n;
    }

    public int removeGroupUserRel(Connection c, int groupId, int userId) throws AdminException {
        int n;
        PreparedStatement statement = null;
        String theQuery = "delete from " + this.drvSettings.getRelTableName() + " where " + this.drvSettings.getRelGIDColumnName() + " = ?" + " and " + this.drvSettings.getRelUIDColumnName() + " = ?";
        try {
            SilverTrace.debug("admin", "SQLGroupUserRelTable.removeGroupUserRel", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, groupId);
            statement.setInt(2, userId);
            n = statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLGroupUserRelTable.removeGroupUserRel", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return n;
    }

    public int removeAllUserRel(Connection c, int userId) throws AdminException {
        int n;
        PreparedStatement statement = null;
        String theQuery = "delete from " + this.drvSettings.getRelTableName() + " where " + this.drvSettings.getRelUIDColumnName() + " = ?";
        try {
            SilverTrace.debug("admin", "SQLGroupUserRelTable.removeAllUserRel", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, userId);
            n = statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLGroupUserRelTable.removeAllUserRel", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return n;
    }

    public int removeAllGroupRel(Connection c, int groupId) throws AdminException {
        int n;
        PreparedStatement statement = null;
        String theQuery = "delete from " + this.drvSettings.getRelTableName() + " where " + this.drvSettings.getRelGIDColumnName() + " = ?";
        try {
            SilverTrace.debug("admin", "SQLGroupUserRelTable.removeAllGroupRel", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, groupId);
            n = statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLGroupUserRelTable.removeAllGroupRel", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return n;
    }

    public boolean isUserDirectlyInGroup(Connection c, int userId, int groupId) throws AdminException {
        boolean bl;
        ResultSet rs = null;
        PreparedStatement statement = null;
        String theQuery = "select " + this.drvSettings.getRelUIDColumnName() + " from " + this.drvSettings.getRelTableName() + " where " + this.drvSettings.getRelGIDColumnName() + " = ? AND " + this.drvSettings.getRelUIDColumnName() + " = ?";
        try {
            SilverTrace.debug("admin", "SQLGroupUserRelTable.isUserDirectlyInGroup", "root.MSG_QUERY", theQuery);
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, groupId);
            statement.setInt(2, userId);
            rs = statement.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new AdminException("SQLGroupUserRelTable.isUserDirectlyInGroup", 4, "root.EX_SQL_QUERY_FAILED", "Query = " + theQuery, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close(rs, statement);
        return bl;
    }
}

