/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import java.io.Serializable;
import org.silverpeas.admin.domain.DomainServiceFactory;
import org.silverpeas.admin.domain.quota.UserDomainQuotaKey;
import org.silverpeas.quota.exception.QuotaException;
import org.silverpeas.quota.exception.QuotaRuntimeException;
import org.silverpeas.quota.model.Quota;

public class Domain
implements Serializable {
    private static final long serialVersionUID = 7451639218436788229L;
    public static final String MIXED_DOMAIN_ID = "-1";
    private String id;
    private String name;
    private String description;
    private String driverClassName;
    private String propFileName;
    private String authenticationServer;
    private String theTimeStamp = "0";
    private String silverpeasServerURL = "";
    private Quota userDomainQuota;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTheTimeStamp() {
        return this.theTimeStamp;
    }

    public void setTheTimeStamp(String tt) {
        this.theTimeStamp = tt;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String className) {
        this.driverClassName = className;
    }

    public String getPropFileName() {
        return this.propFileName;
    }

    public void setPropFileName(String propFileName) {
        this.propFileName = propFileName;
    }

    public String getAuthenticationServer() {
        return this.authenticationServer;
    }

    public void setAuthenticationServer(String authenticationServer) {
        this.authenticationServer = authenticationServer;
    }

    public String getSilverpeasServerURL() {
        return this.silverpeasServerURL;
    }

    public void setSilverpeasServerURL(String silverpeasServerURL) {
        this.silverpeasServerURL = silverpeasServerURL;
    }

    private void loadUserDomainQuota() {
        try {
            this.userDomainQuota = DomainServiceFactory.getUserDomainQuotaService().get(UserDomainQuotaKey.from(this));
        }
        catch (QuotaException qe) {
            throw new QuotaRuntimeException("Domain", 4, "root.EX_CANT_GET_QUOTA", qe);
        }
    }

    public Quota getUserDomainQuota() {
        if (this.userDomainQuota == null) {
            this.loadUserDomainQuota();
        }
        return this.userDomainQuota;
    }

    public void setUserDomainQuotaMaxCount(String userDomainQuotaMaxCount) throws QuotaException {
        this.loadUserDomainQuota();
        this.userDomainQuota.setMaxCount(userDomainQuotaMaxCount);
        this.userDomainQuota.validateBounds();
    }

    public boolean isQuotaReached() {
        this.loadUserDomainQuota();
        return this.userDomainQuota.isReached();
    }

    public boolean isMixedOne() {
        return MIXED_DOMAIN_ID.equals(this.getId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Domain{id=");
        sb.append(this.id);
        sb.append(", name=");
        sb.append(this.name);
        sb.append(", description=");
        sb.append(this.description);
        sb.append(", driverClassName=");
        sb.append(this.driverClassName);
        sb.append(", propFileName=");
        sb.append(this.propFileName);
        sb.append(", authenticationServer=");
        sb.append(this.authenticationServer);
        sb.append(", theTimeStamp=");
        sb.append(this.theTimeStamp);
        sb.append(", silverpeasServerURL=");
        sb.append(this.silverpeasServerURL);
        if (this.userDomainQuota != null) {
            sb.append(", usersInDomainQuotaMaxCount=");
            sb.append(this.userDomainQuota.getMaxCount());
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Domain other = (Domain)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.driverClassName == null ? other.driverClassName != null : !this.driverClassName.equals(other.driverClassName)) {
            return false;
        }
        if (this.propFileName == null ? other.propFileName != null : !this.propFileName.equals(other.propFileName)) {
            return false;
        }
        if (this.authenticationServer == null ? other.authenticationServer != null : !this.authenticationServer.equals(other.authenticationServer)) {
            return false;
        }
        if (this.theTimeStamp == null ? other.theTimeStamp != null : !this.theTimeStamp.equals(other.theTimeStamp)) {
            return false;
        }
        return !(this.silverpeasServerURL == null ? other.silverpeasServerURL != null : !this.silverpeasServerURL.equals(other.silverpeasServerURL));
    }

    public int hashCode() {
        int hash = 5;
        hash = 73 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 73 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 73 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 73 * hash + (this.driverClassName != null ? this.driverClassName.hashCode() : 0);
        hash = 73 * hash + (this.propFileName != null ? this.propFileName.hashCode() : 0);
        hash = 73 * hash + (this.authenticationServer != null ? this.authenticationServer.hashCode() : 0);
        hash = 73 * hash + (this.theTimeStamp != null ? this.theTimeStamp.hashCode() : 0);
        hash = 73 * hash + (this.silverpeasServerURL != null ? this.silverpeasServerURL.hashCode() : 0);
        return hash;
    }
}

