/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.admin.components.WAComponent;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.CompoSpace;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.ComponentSearchCriteria;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.GroupsSearchCriteria;
import com.stratelia.webactiv.beans.admin.ObjectType;
import com.stratelia.webactiv.beans.admin.ProfileInst;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserDetailsSearchCriteria;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.apache.commons.lang3.ArrayUtils;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.util.ListSlice;

@Named(value="organizationController")
public class OrganizationController
implements OrganisationController {
    private static final long serialVersionUID = 3435241972671610107L;

    @Override
    public String[] getAllSpaceIds() {
        try {
            return AdminReference.getAdminService().getAllSpaceIds();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllSpaceIds", "admin.MSG_ERR_GET_ALL_SPACE_IDS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public String[] getAllSubSpaceIds(String sSpaceId) {
        try {
            String[] asSubSpaceIds = AdminReference.getAdminService().getAllSubSpaceIds(sSpaceId);
            return asSubSpaceIds;
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllSubSpaceIds", "admin.MSG_ERR_GET_SUBSPACE_IDS", "father space id: '" + sSpaceId + "'", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public String[] getSpaceNames(String[] asSpaceIds) {
        try {
            String[] asSpaceNames = AdminReference.getAdminService().getSpaceNames(asSpaceIds);
            return asSpaceNames;
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getSpaceNames", "admin.MSG_ERR_GET_SPACE_NAMES", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public SpaceInstLight getSpaceInstLightById(String spaceId) {
        try {
            SpaceInstLight spaceLight = AdminReference.getAdminService().getSpaceInstLightById(spaceId);
            return spaceLight;
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getSpaceInstLightById", "admin.MSG_ERR_GET_SPACE_BY_ID", "spaceId=" + spaceId, e);
            return null;
        }
    }

    @Override
    public String getGeneralSpaceId() {
        try {
            return AdminReference.getAdminService().getGeneralSpaceId();
        }
        catch (Exception e) {
            SilverTrace.fatal("admin", "OrganizationController.getGeneralSpaceId", "admin.MSG_FATAL_GET_GENERAL_SPACE_ID", e);
            return "";
        }
    }

    @Override
    public SpaceInst getSpaceInstById(String sSpaceId) {
        try {
            return AdminReference.getAdminService().getSpaceInstById(sSpaceId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getSpaceInstById", "admin.MSG_ERR_GET_SPACE", "space Id: '" + sSpaceId + "'", e);
            return null;
        }
    }

    @Override
    public String[] getAvailCompoIds(String sClientSpaceId, String sUserId) {
        try {
            return AdminReference.getAdminService().getAvailCompoIds(sClientSpaceId, sUserId);
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "OrganizationController.getAvailCompoIds", "admin.MSG_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", "space Id: '" + sClientSpaceId + "', user Id: '" + sUserId + "'", e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public String[] getAvailCompoIds(String sUserId) {
        try {
            return AdminReference.getAdminService().getAvailCompoIds(sUserId);
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "OrganizationController.getAvailCompoIds", "admin.MSG_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", "user Id: '" + sUserId + "'", e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public String[] getAvailCompoIdsAtRoot(String sClientSpaceId, String sUserId) {
        try {
            String[] asCompoIds = AdminReference.getAdminService().getAvailCompoIdsAtRoot(sClientSpaceId, sUserId);
            return asCompoIds;
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAvailCompoIdsAtRoot", "admin.MSG_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", "space Id: '" + sClientSpaceId + "', user Id: '" + sUserId + "'", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public Map<String, WAComponent> getAllComponents() {
        try {
            return AdminReference.getAdminService().getAllComponents();
        }
        catch (Exception e) {
            if (!(e instanceof AdminException) || !((AdminException)e).isAlreadyPrinted()) {
                SilverTrace.error("admin", "OrganizationController.getAvailDriverCompoIds", "admin.MSG_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", null, e);
            }
            return new HashMap<String, WAComponent>();
        }
    }

    @Override
    public Map<String, String> getAllComponentsNames() {
        try {
            return AdminReference.getAdminService().getAllComponentsNames();
        }
        catch (Exception e) {
            if (!(e instanceof AdminException) || !((AdminException)e).isAlreadyPrinted()) {
                SilverTrace.error("admin", "OrganizationController.getAvailDriverCompoIds", "admin.MSG_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", null, e);
            }
            return new HashMap<String, String>();
        }
    }

    @Override
    public String[] getAvailDriverCompoIds(String sClientSpaceId, String sUserId) {
        try {
            return AdminReference.getAdminService().getAvailDriverCompoIds(sClientSpaceId, sUserId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAvailDriverCompoIds", "admin.MSG_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", "space Id: '" + sClientSpaceId + "', user Id: '" + sUserId + "'", e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public CompoSpace[] getCompoForUser(String sUserId, String sCompoName) {
        try {
            return AdminReference.getAdminService().getCompoForUser(sUserId, sCompoName);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getCompoForUser", "admin.MSG_ERR_GET_USER_AVAILABLE_INSTANCES_OF_COMPONENT", "user Id : '" + sUserId + "', component name: '" + sCompoName + "'", e);
            return new CompoSpace[0];
        }
    }

    @Override
    public List<ComponentInstLight> getAvailComponentInstLights(String userId, String componentName) {
        try {
            return AdminReference.getAdminService().getAvailComponentInstLights(userId, componentName);
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "getAvailComponentInstLights", "admin.MSG_ERR_GET_USER_AVAILABLE_INSTANCES_OF_COMPONENT", "user Id : '" + userId + "', component name: '" + componentName + "'", e);
            return new ArrayList<ComponentInstLight>();
        }
    }

    @Override
    public String[] getComponentIdsForUser(String sUserId, String sCompoName) {
        try {
            return AdminReference.getAdminService().getComponentIdsByNameAndUserId(sUserId, sCompoName);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getComponentIdsForUser", "admin.MSG_ERR_GET_USER_AVAILABLE_INSTANCES_OF_COMPONENT", "user Id : '" + sUserId + "', component name: '" + sCompoName + "'", e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public String[] getCompoId(String sCompoName) {
        try {
            return AdminReference.getAdminService().getCompoId(sCompoName);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getCompoId", "admin.MSG_ERR_GET_AVAILABLE_INSTANCES_OF_COMPONENT", "component name: '" + sCompoName + "'", e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public String getComponentParameterValue(String sComponentId, String parameterName) {
        return AdminReference.getAdminService().getComponentParameterValue(sComponentId, parameterName);
    }

    @Override
    public ComponentInst getComponentInst(String sComponentId) {
        try {
            return AdminReference.getAdminService().getComponentInst(sComponentId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getComponentInst", "admin.MSG_ERR_GET_COMPONENT", "component Id : '" + sComponentId + "'", e);
            return null;
        }
    }

    @Override
    public List<SpaceInst> getSpacePath(String spaceId) {
        return this.getSpacePath(new ArrayList<SpaceInst>(), spaceId);
    }

    @Override
    public List<SpaceInst> getSpacePathToComponent(String componentId) {
        ComponentInstLight componentInstLight = this.getComponentInstLight(componentId);
        if (componentInstLight != null) {
            return this.getSpacePath(componentInstLight.getDomainFatherId());
        }
        return new ArrayList<SpaceInst>();
    }

    private List<SpaceInst> getSpacePath(List<SpaceInst> path, String spaceId) {
        try {
            SpaceInst spaceInst = AdminReference.getAdminService().getSpaceInstById(spaceId);
            if (spaceInst != null) {
                path.add(0, spaceInst);
                if (!spaceInst.isRoot()) {
                    path = this.getSpacePath(path, spaceInst.getDomainFatherId());
                }
            }
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getSpacePath", "admin.MSG_ERR_GET_SPACE", "spaceId = '" + spaceId + "'", e);
        }
        return path;
    }

    @Override
    public ComponentInstLight getComponentInstLight(String sComponentId) {
        try {
            return AdminReference.getAdminService().getComponentInstLight(sComponentId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getComponentInstLight", "admin.MSG_ERR_GET_COMPONENT", "component Id : '" + sComponentId + "'", e);
            return null;
        }
    }

    @Override
    public int getUserDBId(String sUserId) {
        return this.idAsInt(sUserId);
    }

    @Override
    public String getUserDetailByDBId(int id) {
        return OrganizationController.idAsString(id);
    }

    @Override
    public UserFull getUserFull(String sUserId) {
        try {
            return AdminReference.getAdminService().getUserFull(sUserId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getUserFull", "admin.EX_ERR_GET_USER_DETAIL", "user Id : '" + sUserId + "'", e);
            return null;
        }
    }

    @Override
    public UserDetail getUserDetail(String sUserId) {
        try {
            UserDetail userDetail = AdminReference.getAdminService().getUserDetail(sUserId);
            return userDetail;
        }
        catch (Exception e) {
            SilverTrace.warn("admin", "OrganizationController.getUserDetail", "admin.EX_ERR_GET_USER_DETAIL", "user Id : '" + sUserId + "'", e);
            return null;
        }
    }

    @Override
    public UserDetail[] getUserDetails(String[] asUserIds) {
        try {
            return AdminReference.getAdminService().getUserDetails(asUserIds);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getUserDetails", "admin.EX_ERR_GET_USER_DETAILS", e);
            return null;
        }
    }

    @Override
    public UserDetail[] getAllUsers(String sPrefixTableName, String sComponentName) {
        try {
            if (sComponentName != null) {
                return AdminReference.getAdminService().getUsers(true, null, sPrefixTableName, sComponentName);
            }
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllUsers", "admin.MSG_ERR_GET_USERS_FOR_PROFILE_AND_COMPONENT", "space Id: '" + sPrefixTableName + "' component Id: '" + sComponentName, e);
        }
        return null;
    }

    @Override
    public UserDetail[] getAllUsers(String componentId) {
        try {
            if (componentId != null) {
                return AdminReference.getAdminService().getUsers(true, null, null, componentId);
            }
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllUsers", "admin.MSG_ERR_GET_USERS_FOR_PROFILE_AND_COMPONENT", "componentId: '" + componentId, e);
        }
        return null;
    }

    @Override
    public UserDetail[] getAllUsersInDomain(String domainId) {
        try {
            if (domainId != null) {
                return AdminReference.getAdminService().getUsersOfDomain(domainId);
            }
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllUsersInDomain", "admin.EX_ERR_GET_USER_DETAILS", "domainId: '" + domainId, e);
        }
        return null;
    }

    @Override
    public List<UserDetail> getUsersOfDomains(List<String> domainIds) {
        try {
            return AdminReference.getAdminService().getUsersOfDomains(domainIds);
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "OrganizationController.getUsersOfDomains", "admin.EX_ERR_GET_USER_DETAILS", "domainIds = " + domainIds.toString(), e);
            return null;
        }
    }

    @Override
    public List<UserDetail> getUsersOfDomainsFromNewestToOldest(List<String> domainIds) {
        try {
            return AdminReference.getAdminService().getUsersOfDomainsFromNewestToOldest(domainIds);
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "OrganizationController.getUsersOfDomainsFromNewestToOldest", "admin.EX_ERR_GET_USER_DETAILS", "domainIds = " + domainIds.toString(), e);
            return null;
        }
    }

    @Override
    public ListSlice<UserDetail> searchUsers(UserDetailsSearchCriteria criteria) {
        try {
            return AdminReference.getAdminService().searchUsers(criteria);
        }
        catch (AdminException ex) {
            SilverTrace.error("admin", "OrganizationController.getUsersMatchingCriteria", "admin.EX_ERR_GET_USER_DETAILS", "criteria: '" + criteria.toString(), ex);
            return null;
        }
    }

    @Override
    public Group[] getAllRootGroupsInDomain(String domainId) {
        try {
            if (domainId != null) {
                return AdminReference.getAdminService().getRootGroupsOfDomain(domainId);
            }
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllUsersInDomain", "admin.EX_ERR_GET_USER_DETAILS", "domainId: '" + domainId, e);
        }
        return null;
    }

    @Override
    public UserDetail[] getFiltredDirectUsers(String sGroupId, String sUserLastNameFilter) {
        try {
            return AdminReference.getAdminService().getFiltredDirectUsers(sGroupId, sUserLastNameFilter);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getFiltredDirectUsers", "admin.EX_ERR_GET_USER_DETAILS", e);
            return null;
        }
    }

    @Override
    public UserDetail[] searchUsers(UserDetail modelUser, boolean isAnd) {
        try {
            return AdminReference.getAdminService().searchUsers(modelUser, isAnd);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.searchUsers", "admin.EX_ERR_GET_USER_DETAILS", e);
            return null;
        }
    }

    @Override
    public ListSlice<Group> searchGroups(GroupsSearchCriteria criteria) {
        try {
            return AdminReference.getAdminService().searchGroups(criteria);
        }
        catch (AdminException ex) {
            SilverTrace.error("admin", "OrganizationController.getGroupsMatchingCriteria", "admin.EX_ERR_GET_USER_DETAILS", "criteria: '" + criteria.toString(), ex);
            return null;
        }
    }

    @Override
    public Group[] searchGroups(Group modelGroup, boolean isAnd) {
        try {
            return AdminReference.getAdminService().searchGroups(modelGroup, isAnd);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.searchGroups", "admin.EX_ERR_GET_USER_DETAILS", e);
            return null;
        }
    }

    @Override
    public int getAllSubUsersNumber(String sGroupId) {
        try {
            return AdminReference.getAdminService().getAllSubUsersNumber(sGroupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllSubUsersNumber", "admin.EX_ERR_GET_USER_DETAILS", e);
            return 0;
        }
    }

    @Override
    public Group[] getAllSubGroups(String parentGroupId) {
        try {
            return AdminReference.getAdminService().getAllSubGroups(parentGroupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllSubGroups", "admin.EX_ERR_GET_USER_DETAILS", e);
            return new Group[0];
        }
    }

    @Override
    public UserDetail[] getAllUsers() {
        try {
            return AdminReference.getAdminService().getAllUsers().toArray(new UserDetail[0]);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllUsers", "admin.MSG_ERR_GET_ALL_USERS", e);
            return null;
        }
    }

    @Override
    public List<UserDetail> getAllUsersFromNewestToOldest() {
        try {
            return AdminReference.getAdminService().getAllUsersFromNewestToOldest();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllUsersFromNewestToOldest", "admin.MSG_ERR_GET_ALL_USERS", e);
            return null;
        }
    }

    @Override
    public UserDetail[] getUsers(String sPrefixTableName, String sComponentName, String sProfile) {
        try {
            UserDetail[] aUserDetail = null;
            if (sPrefixTableName != null && sComponentName != null) {
                aUserDetail = AdminReference.getAdminService().getUsers(false, sProfile, sPrefixTableName, sComponentName);
            }
            return aUserDetail;
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getUsers", "admin.MSG_ERR_GET_USERS_FOR_PROFILE_AND_COMPONENT", "profile: '" + sProfile + "', space Id: '" + sPrefixTableName + "' component Id: '" + sComponentName, e);
            return null;
        }
    }

    @Override
    public String[] getUserProfiles(String userId, String componentId) {
        try {
            return AdminReference.getAdminService().getCurrentProfiles(userId, componentId);
        }
        catch (Exception e) {
            if (!this.isToolAvailable(componentId)) {
                SilverTrace.error("admin", "OrganizationController.getUserProfiles", "admin.MSG_ERR_GET_PROFILES_FOR_USER_AND_COMPONENT", "userId: '" + userId + "', componentId: '" + componentId + "'", e);
            }
            return null;
        }
    }

    @Override
    public String[] getUserProfiles(String userId, String componentId, int objectId, ObjectType objectType) {
        try {
            return AdminReference.getAdminService().getProfilesByObjectAndUserId(objectId, objectType.getCode(), componentId, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getUserProfiles", "admin.MSG_ERR_GET_PROFILES_FOR_USER_AND_COMPONENT", "userId = " + userId + ", componentId = " + componentId + ", objectId = " + objectId, e);
            return null;
        }
    }

    @Override
    public Map<Integer, List<String>> getUserObjectProfiles(String userId, String componentId, ObjectType objectType) {
        try {
            return AdminReference.getAdminService().getProfilesByObjectTypeAndUserId(objectType.getCode(), componentId, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getUserProfiles", "admin.MSG_ERR_GET_PROFILES_FOR_USER_AND_COMPONENT", "userId = " + userId + ", componentId = " + componentId + ", objectType = " + (Object)((Object)objectType), e);
            return null;
        }
    }

    @Override
    public List<ProfileInst> getUserProfiles(String componentId, String objectId, String objectType) {
        try {
            return AdminReference.getAdminService().getProfilesByObject(objectId, objectType, componentId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getUserProfiles", "admin.MSG_ERR_GET_PROFILE", "componentId = " + componentId + ", objectId = " + objectType + objectId, e);
            return null;
        }
    }

    @Override
    public ProfileInst getUserProfile(String profileId) {
        try {
            return AdminReference.getAdminService().getProfileInst(profileId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getUserProfile", "admin.MSG_ERR_GET_PROFILE", "profileId: '" + profileId, e);
            return null;
        }
    }

    @Override
    public String[] getAdministratorUserIds(String fromUserId) {
        try {
            return AdminReference.getAdminService().getAdministratorUserIds(fromUserId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAdministratorUserIds", "admin.MSG_ERR_GET_ALL_ADMIN_IDS", e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public Group getGroup(String sGroupId) {
        try {
            Group group = AdminReference.getAdminService().getGroup(sGroupId);
            return group;
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getGroup", "admin.EX_ERR_GET_GROUP", "group Id : '" + sGroupId + "'", e);
            return null;
        }
    }

    @Override
    public Group[] getGroups(String[] groupsId) {
        Group[] retour = null;
        try {
            retour = AdminReference.getAdminService().getGroups(groupsId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getGroups", "admin.EX_ERR_GET_GROUP", "", e);
        }
        return retour;
    }

    @Override
    public Group[] getAllGroups() {
        try {
            Group[] aGroup = null;
            String[] asGroupIds = AdminReference.getAdminService().getAllGroupIds();
            if (asGroupIds != null) {
                aGroup = AdminReference.getAdminService().getGroups(asGroupIds);
            }
            return aGroup;
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllGroups", "admin.MSG_ERR_GET_ALL_GROUPS", e);
            return null;
        }
    }

    @Override
    public Group[] getAllRootGroups() {
        try {
            return AdminReference.getAdminService().getAllRootGroups();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllRootGroups", "admin.MSG_ERR_GET_ALL_GROUPS", e);
            return null;
        }
    }

    @Override
    public UserDetail[] getAllUsersOfGroup(String groupId) {
        SilverTrace.info("admin", "OrganizationController.getAllUsersOfGroup", "root.MSG_GEN_ENTER_METHOD", "groupId = " + groupId);
        try {
            return AdminReference.getAdminService().getAllUsersOfGroup(groupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllUsersOfGroup", "admin.MSG_ERR_GET_ALL_DOMAINS", e);
            return ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
        }
    }

    @Override
    public List<String> getPathToGroup(String groupId) {
        SilverTrace.info("admin", "OrganizationController.getPathToGroup", "root.MSG_GEN_ENTER_METHOD", "groupId = " + groupId);
        try {
            return AdminReference.getAdminService().getPathToGroup(groupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getPathToGroup", "admin.EX_ERR_GET_ALL_GROUPS", e);
            return new ArrayList<String>();
        }
    }

    private int idAsInt(String id) {
        if (id == null || id.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String idAsString(int id) {
        return Integer.toString(id);
    }

    @Override
    public String[] getAllSpaceIds(String sUserId) {
        try {
            return AdminReference.getAdminService().getAllSpaceIds(sUserId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllSpaceIds", "admin.MSG_ERR_GET_USER_AVAILABLE_SPACE_IDS", "user Id: '" + sUserId, e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public String[] getUserManageableSpaceIds(String sUserId) {
        try {
            String[] asSpaceIds = AdminReference.getAdminService().getUserManageableSpaceIds(sUserId);
            return asSpaceIds;
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getUserManageableSpaceIds", "admin.MSG_ERR_GET_USER_MANAGEABLE_SPACE_IDS", "user Id: '" + sUserId, e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public String[] getAllRootSpaceIds() {
        try {
            return AdminReference.getAdminService().getAllRootSpaceIds();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllSpaceIds", "admin.MSG_ERR_GET_USER_AVAILABLE_SPACE_IDS", e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public String[] getAllRootSpaceIds(String sUserId) {
        try {
            return AdminReference.getAdminService().getAllRootSpaceIds(sUserId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllSpaceIds", "admin.MSG_ERR_GET_USER_AVAILABLE_SPACE_IDS", "user Id: '" + sUserId, e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public String[] getAllSubSpaceIds(String sSpaceId, String sUserId) {
        try {
            return AdminReference.getAdminService().getAllSubSpaceIds(sSpaceId, sUserId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllSubSpaceIds", "admin.MSG_ERR_GET_USER_AVAILABLE_SUBSPACE_IDS", "user Id: '" + sUserId + "', father space id: '" + sSpaceId, e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public String[] getAllComponentIds(String sSpaceId) {
        try {
            return AdminReference.getAdminService().getAllComponentIds(sSpaceId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllComponentIds", "admin.MSG_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", "space id=" + sSpaceId, e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public String[] getAllComponentIdsRecur(String sSpaceId) {
        try {
            return AdminReference.getAdminService().getAllComponentIdsRecur(sSpaceId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllComponentIdsRecur", "admin.MSG_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", "spaceId = " + sSpaceId, e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public String[] getAllComponentIdsRecur(String sSpaceId, String sUserId, String sComponentRootName, boolean inCurrentSpace, boolean inAllSpaces) {
        try {
            return AdminReference.getAdminService().getAllComponentIdsRecur(sSpaceId, sUserId, sComponentRootName, inCurrentSpace, inAllSpaces);
        }
        catch (Exception e) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public List<SpaceInstLight> getRootSpacesContainingComponent(String userId, String componentName) {
        try {
            return AdminReference.getAdminService().getRootSpacesContainingComponent(userId, componentName);
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "OrganizationController.getRootSpacesContainingComponent", "admin.MSG_ERR_GET_ROOT_SPACES", "userId = " + userId + ", componentName = " + componentName, e);
            return new ArrayList<SpaceInstLight>();
        }
    }

    @Override
    public List<SpaceInstLight> getSubSpacesContainingComponent(String spaceId, String userId, String componentName) {
        try {
            return AdminReference.getAdminService().getSubSpacesContainingComponent(spaceId, userId, componentName);
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "OrganizationController.getSubSpacesContainingComponent", "admin.MSG_ERR_GET_SUB_SPACES", "spaceId = " + spaceId + ", userId = " + userId + ", componentName = " + componentName, e);
            return new ArrayList<SpaceInstLight>();
        }
    }

    @Override
    public boolean isAdminTool(String toolId) {
        return AdminReference.getAdminService().isAnAdminTool(toolId);
    }

    @Override
    public boolean isToolAvailable(String toolId) {
        boolean isToolAvailable;
        try {
            isToolAvailable = GeneralPropertiesManager.getStringCollection("availableToolIds").contains(toolId);
        }
        catch (Exception e) {
            isToolAvailable = false;
            SilverTrace.error("admin", "OrganizationController.isToolAvailable", "admin.MSG_ERR_GET_AVAILABLE_TOOL_IDS", "toolId: '" + toolId + "'");
        }
        return isToolAvailable;
    }

    @Override
    public boolean isComponentAvailable(String componentId, String userId) {
        try {
            return AdminReference.getAdminService().isComponentAvailable(componentId, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.isComponentAvailable", "admin.MSG_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", "user Id: '" + userId + "', componentId: '" + componentId + "'", e);
            return false;
        }
    }

    @Override
    public boolean isComponentExist(String componentId) {
        try {
            return AdminReference.getAdminService().getComponentInstLight(componentId) != null;
        }
        catch (AdminException ex) {
            SilverTrace.error("admin", "OrganizationController.isComponentExist", "admin.EX_ERR_GET_COMPONENT", "componentId: '" + componentId + "'", ex);
            return false;
        }
    }

    @Override
    public boolean isComponentManageable(String componentId, String userId) {
        try {
            return AdminReference.getAdminService().isComponentManageable(componentId, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.isComponentManageable", "admin.MSG_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", "user Id: '" + userId + "', componentId: '" + componentId + "'", e);
            return false;
        }
    }

    @Override
    public boolean isSpaceAvailable(String spaceId, String userId) {
        try {
            return AdminReference.getAdminService().isSpaceAvailable(userId, spaceId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.isSpaceAvailable", "admin.MSG_ERR_GET_USER_AVAILABLE_SPACE_IDS", "user Id: '" + userId + "', spaceId: '" + spaceId + "'", e);
            return false;
        }
    }

    @Override
    public boolean isObjectAvailable(int objectId, ObjectType objectType, String componentId, String userId) {
        try {
            return AdminReference.getAdminService().isObjectAvailable(componentId, objectId, objectType.getCode(), userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.isObjectAvailable", "admin.MSG_ERR_GET_USER_AVAILABLE_OBJECT", "userId = " + userId + ", componentId = " + componentId + ", objectId = " + objectId, e);
            return false;
        }
    }

    @Override
    public List<SpaceInstLight> getSpaceTreeview(String userId) {
        try {
            return AdminReference.getAdminService().getUserSpaceTreeview(userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getSpaceTreeview", "admin.MSG_ERR_GET_USER_AVAILABLE_SPACES", "user Id = " + userId, e);
            return new ArrayList<SpaceInstLight>();
        }
    }

    @Override
    public String[] getAllowedSubSpaceIds(String userId, String spaceFatherId) {
        try {
            return AdminReference.getAdminService().getAllowedSubSpaceIds(userId, spaceFatherId);
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "OrganizationController.getSpaceTreeview", "admin.MSG_ERR_GET_USER_AVAILABLE_SUBSPACE_IDS", "user Id = " + userId + ", spaceId = " + spaceFatherId, e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public SpaceInstLight getRootSpace(String spaceId) {
        try {
            return AdminReference.getAdminService().getRootSpace(spaceId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getRootSpace", "admin.MSG_ERR_GET_USER_AVAILABLE_SPACE", "spaceId = " + spaceId, e);
            return null;
        }
    }

    @Override
    public String[] getAllUsersIds() {
        try {
            return AdminReference.getAdminService().getAllUsersIds();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllUsersIds", "admin.MSG_ERR_GET_ALL_USERS", e);
            return null;
        }
    }

    @Override
    public String[] searchUsersIds(String groupId, String componentId, String[] profileId, UserDetail filterUser) {
        try {
            return AdminReference.getAdminService().searchUsersIds(groupId, componentId, profileId, filterUser);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.searchUsersIds", "admin.MSG_ERR_GET_ALL_USERS", e);
            return null;
        }
    }

    @Override
    public String[] getUsersIdsByRoleNames(String componentId, List<String> profileNames) {
        try {
            ComponentInst componentInst = this.getComponentInst(componentId);
            List<ProfileInst> profiles = componentInst.getAllProfilesInst();
            ArrayList<String> profileIds = new ArrayList<String>();
            for (ProfileInst profileInst : profiles) {
                if (!profileNames.contains(profileInst.getName())) continue;
                profileIds.add(profileInst.getId());
                SilverTrace.info("admin", "OrganizationController.getUsersIdsByRoleNames", "root.MSG_GEN_PARAM_VALUE", "profileName = " + profileInst.getName() + ", profileId = " + profileInst.getId());
            }
            if (!profileIds.isEmpty()) {
                Object[] pIds = profileIds.toArray(new String[profileIds.size()]);
                SilverTrace.info("admin", "OrganizationController.getUsersIdsByRoleNames", "root.MSG_GEN_PARAM_VALUE", "pIds = " + Arrays.toString(pIds));
                return AdminReference.getAdminService().searchUsersIds(null, null, (String[])pIds, new UserDetail());
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getUsersIdsByRoleNames", "admin.MSG_ERR_GET_ALL_USERS", e);
            return null;
        }
    }

    @Override
    public String[] getUsersIdsByRoleNames(String componentId, String objectId, ObjectType objectType, List<String> profileNames) {
        SilverTrace.info("admin", "OrganizationController.getUsersIdsByRoleNames", "root.MSG_GEN_ENTER_METHOD", "componentId = " + componentId + ", objectId = " + objectId);
        try {
            List<ProfileInst> profiles = AdminReference.getAdminService().getProfilesByObject(objectId, objectType.getCode(), componentId);
            ArrayList<String> profileIds = new ArrayList<String>();
            for (ProfileInst profile : profiles) {
                if (profile == null || !profileNames.contains(profile.getName())) continue;
                profileIds.add(profile.getId());
            }
            SilverTrace.info("admin", "OrganizationController.getUsersIdsByRoleNames", "root.MSG_GEN_PARAM_VALUE", "profileIds = " + ((Object)profileIds).toString());
            if (profileIds.isEmpty()) {
                return ArrayUtils.EMPTY_STRING_ARRAY;
            }
            return AdminReference.getAdminService().searchUsersIds(null, null, profileIds.toArray(new String[profileIds.size()]), new UserDetail());
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getUsersIdsByRoleNames", "admin.MSG_ERR_GET_ALL_USERS", e);
            return null;
        }
    }

    @Override
    public String[] searchGroupsIds(boolean isRootGroup, String componentId, String[] profileId, Group modelGroup) {
        try {
            return AdminReference.getAdminService().searchGroupsIds(isRootGroup, componentId, profileId, modelGroup);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.searchGroupsIds", "admin.MSG_ERR_GET_ALL_USERS", e);
            return null;
        }
    }

    @Override
    public Domain getDomain(String domainId) {
        try {
            return AdminReference.getAdminService().getDomain(domainId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getDomain", "admin.EX_ERR_GET_DOMAIN", e);
            return null;
        }
    }

    @Override
    public Domain[] getAllDomains() {
        try {
            return AdminReference.getAdminService().getAllDomains();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllDomain", "admin.EX_ERR_GET_DOMAIN", e);
            return null;
        }
    }

    @Override
    public String[] getDirectGroupIdsOfUser(String userId) {
        try {
            return AdminReference.getAdminService().getDirectGroupsIdsOfUser(userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getDirectGroupIdsOfUser", "admin.MSG_ERR_GET_ALL_GROUPS", e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    private ArrayList<String> recursiveMajListGroupId(String idGroup, ArrayList<String> listRes) {
        Group group = this.getGroup(idGroup);
        if (group.getSuperGroupId() != null) {
            listRes = this.recursiveMajListGroupId(group.getSuperGroupId(), listRes);
        }
        listRes.add(idGroup);
        return listRes;
    }

    @Override
    public String[] getAllGroupIdsOfUser(String userId) {
        try {
            String[] tabGroupIds;
            ArrayList<String> listRes = new ArrayList<String>();
            for (String groupId : tabGroupIds = AdminReference.getAdminService().getDirectGroupsIdsOfUser(userId)) {
                listRes = this.recursiveMajListGroupId(groupId, listRes);
            }
            return listRes.toArray(new String[listRes.size()]);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "OrganizationController.getAllGroupIdsOfUser", "admin.MSG_ERR_GET_ALL_GROUPS", e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public void reloadAdminCache() {
        AdminReference.getAdminService().reloadCache();
    }

    @Override
    public boolean isAnonymousAccessActivated() {
        return UserDetail.isAnonymousUserExist();
    }

    @Override
    public String[] getAllowedComponentIds(String userId) {
        try {
            return AdminReference.getAdminService().getAvailCompoIds(userId);
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "OrganizationController.getAllowedComponentIds", "admin.MSG_ERR_GET_AVAILABLE_COMPONENTIDS", e);
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public List<String> getSearchableComponentsByCriteria(ComponentSearchCriteria criteria) {
        ArrayList<String> componentIds = new ArrayList<String>();
        if (criteria.hasCriterionOnWorkspace()) {
            if (criteria.hasCriterionOnComponentInstance()) {
                componentIds.add(criteria.getComponentInstanceId());
            } else {
                String[] availableComponentIds;
                for (String aComponentId : availableComponentIds = this.getAvailCompoIds(criteria.getWorkspaceId(), criteria.getUser().getId())) {
                    if (!this.isSearchable(aComponentId, null)) continue;
                    componentIds.add(aComponentId);
                }
            }
        } else {
            String[] availableComponentIds = this.getAvailCompoIds(criteria.getUser().getId());
            List<String> excludedComponentIds = this.getComponentsExcludedFromGlobalSearch(criteria.getUser().getId());
            for (String aComponentId : availableComponentIds) {
                if (!this.isSearchable(aComponentId, excludedComponentIds)) continue;
                componentIds.add(aComponentId);
            }
        }
        return componentIds;
    }

    private boolean isSearchable(String componentId, List<String> exclusionList) {
        if (exclusionList != null && !exclusionList.isEmpty() && exclusionList.contains(componentId)) {
            return false;
        }
        if (componentId.startsWith("silverCrawler") || componentId.startsWith("gallery") || componentId.startsWith("kmelia")) {
            boolean isPrivateSearch = "yes".equalsIgnoreCase(this.getComponentParameterValue(componentId, "privateSearch"));
            return !isPrivateSearch;
        }
        return true;
    }

    private List<String> getComponentsExcludedFromGlobalSearch(String userId) {
        ArrayList<String> excluded = new ArrayList<String>();
        List<String> spaces = this.getItemsExcludedFromGlobalSearch("SpacesExcludedFromGlobalSearch");
        for (String space : spaces) {
            String[] availableComponentIds = this.getAvailCompoIds(space, userId);
            excluded.addAll(Arrays.asList(availableComponentIds));
        }
        List<String> components = this.getItemsExcludedFromGlobalSearch("ComponentsExcludedFromGlobalSearch");
        excluded.addAll(components);
        return excluded;
    }

    private List<String> getItemsExcludedFromGlobalSearch(String parameterName) {
        ResourceLocator searchSettings = new ResourceLocator("org.silverpeas.pdcPeas.settings.pdcPeasSettings", "");
        ArrayList<String> items = new ArrayList<String>();
        String param = searchSettings.getString(parameterName);
        if (StringUtil.isDefined(param)) {
            String[] componentIds = param.split(",");
            items.addAll(Arrays.asList(componentIds));
        }
        return items;
    }
}

