/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.Admin;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.ProfileInst;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.SpaceProfileInst;
import java.util.ArrayList;
import java.util.List;

public class Recover {
    private Admin admin = AdminReference.getAdminService();
    private static final String PARAM_MSG_KEY = "root.MSG_GEN_PARAM_VALUE";

    public void recoverRights() throws AdminException {
        String[] rootSpaceIds;
        int oldTraceLevel = SilverTrace.getTraceLevel("admin", false);
        SilverTrace.setTraceLevel("admin", 3);
        for (String spaceId : rootSpaceIds = this.admin.getAllRootSpaceIds()) {
            List<SpaceInstLight> subSpaces = this.admin.getSubSpaces(spaceId);
            for (SpaceInstLight subSpace : subSpaces) {
                this.recoverSpaceRights(subSpace.getFullId());
            }
        }
        SilverTrace.setTraceLevel("admin", oldTraceLevel);
    }

    public void recoverSpaceRights(String spaceId) throws AdminException {
        this.recoverSpaceRights(spaceId, true);
    }

    private void recoverSpaceRights(String spaceId, boolean firstAccess) throws AdminException {
        String[] subSpaceIds;
        SpaceInst space;
        int oldTraceLevel = 4;
        if (firstAccess) {
            oldTraceLevel = SilverTrace.getTraceLevel("admin", false);
            SilverTrace.setTraceLevel("admin", 3);
        }
        if (!(space = this.admin.getSpaceInstById(spaceId)).isRoot()) {
            if (space.isInheritanceBlocked()) {
                List<SpaceProfileInst> profiles = space.getInheritedProfiles();
                if (!profiles.isEmpty()) {
                    SilverTrace.warn("admin", "Recover.recoverSpaceRights", space.getName() + " does not inherit rights but still had inherit rights");
                    for (SpaceProfileInst profile : profiles) {
                        this.admin.deleteSpaceProfileInst(profile.getId(), null);
                    }
                }
            } else {
                this.admin.setSpaceProfilesToSubSpace(space, null, true, true);
            }
        }
        for (String subSpaceId : subSpaceIds = space.getSubSpaceIds()) {
            this.recoverSpaceRights(subSpaceId, false);
        }
        ArrayList<ComponentInst> components = space.getAllComponentsInst();
        for (ComponentInst component : components) {
            SilverTrace.info("admin", "admin.recoverSpaceRights()", PARAM_MSG_KEY, "component= " + component);
            this.recoverComponentRights(component, space);
        }
        if (firstAccess) {
            SilverTrace.setTraceLevel("admin", oldTraceLevel);
        }
    }

    private void recoverComponentRights(ComponentInst component, SpaceInst space) throws AdminException {
        if (component.isInheritanceBlocked()) {
            List<ProfileInst> profiles = component.getInheritedProfiles();
            if (!profiles.isEmpty()) {
                SilverTrace.warn("admin", "Recover.recoverComponentRights", component.getLabel() + " does not inherit rights but still had inherit rights");
                for (ProfileInst profile : profiles) {
                    this.admin.deleteProfileInst(profile.getId(), null);
                }
            }
        } else {
            SilverTrace.info("admin", "admin.recoverComponentRights()", PARAM_MSG_KEY, "component= " + component + " space=" + space);
            this.admin.setSpaceProfilesToComponent(component, space, true);
        }
    }
}

