/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin.cache;

import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.ProfileInst;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.SpaceProfileInst;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AdminCache {
    private static boolean m_bUseCache = true;
    private static boolean m_bUseSpaceInstCache = true;
    private static Map<String, SpaceInst> m_hSpaceInstCache = new ConcurrentHashMap<String, SpaceInst>();
    private static boolean m_bUseComponentInstCache = true;
    private static Map<String, ComponentInst> m_hComponentInstCache = new ConcurrentHashMap<String, ComponentInst>();
    private static boolean m_bUseProfileInstCache = true;
    private static Map<String, ProfileInst> m_hProfileInstCache = new ConcurrentHashMap<String, ProfileInst>();
    private static boolean m_bUseUserDetailCache = true;
    private static Map<String, UserDetail> m_hUserDetailCache = new ConcurrentHashMap<String, UserDetail>();
    private static boolean m_bUseManageableSpaceIdsCache = true;
    private static Map<String, String[]> m_hManageableSpaceIdsCache = new ConcurrentHashMap<String, String[]>();
    private static boolean m_bUseAvailCompoIdsCache = true;
    private static Map<String, Map<String, String[]>> m_hAvailCompoIdsCache = new ConcurrentHashMap<String, Map<String, String[]>>();
    private static boolean m_bUseProfileIdsCache = true;
    private static Map<String, String[]> m_hProfileIdsCache = new ConcurrentHashMap<String, String[]>();
    private static boolean m_bUseNodeProfileIdsCache = true;
    private static Map<String, String[]> m_hNodeProfileIdsCache = new ConcurrentHashMap<String, String[]>();

    public void setCacheAvailable(boolean useCache) {
        m_bUseCache = useCache;
    }

    public int getNbSpacesInCache() {
        return m_hSpaceInstCache.size();
    }

    public int getNbComponentsInCache() {
        return m_hComponentInstCache.size();
    }

    public int getNbProfilesInCache() {
        return m_hProfileInstCache.size();
    }

    public void resetCache() {
        SilverTrace.debug("admin", "AdminCache.resetCache", "root.MSG_GEN_ENTER_METHOD");
        m_hSpaceInstCache.clear();
        m_hComponentInstCache.clear();
        m_hProfileInstCache.clear();
        m_hUserDetailCache.clear();
        m_hManageableSpaceIdsCache.clear();
        m_hAvailCompoIdsCache.clear();
        m_hProfileIdsCache.clear();
    }

    public void resetSpaceInst() {
        if (m_bUseCache && m_bUseSpaceInstCache) {
            SilverTrace.debug("admin", "AdminCache.resetSpaceInst", "root.MSG_GEN_ENTER_METHOD");
            m_hSpaceInstCache.clear();
        }
    }

    public void putSpaceInst(SpaceInst spaceInst) {
        if (m_bUseCache && m_bUseSpaceInstCache) {
            SilverTrace.debug("admin", "AdminCache.putSpaceInst", "root.MSG_GEN_ENTER_METHOD", "spaceId = " + spaceInst.getId());
            m_hSpaceInstCache.put(spaceInst.getId(), spaceInst);
        }
    }

    public void removeSpaceInst(String spaceId) {
        if (m_bUseCache && m_bUseSpaceInstCache) {
            m_hSpaceInstCache.remove(spaceId);
        }
    }

    public SpaceInst getSpaceInst(String spaceId) {
        if (m_bUseCache && m_bUseSpaceInstCache && StringUtil.isDefined(spaceId)) {
            return m_hSpaceInstCache.get(spaceId);
        }
        return null;
    }

    protected void removeUserInSpaceInst(String userId) {
        this.removeTokenInSpaceInst(userId, false);
    }

    protected void removeGroupInSpaceInst(String groupId) {
        this.removeTokenInSpaceInst(groupId, true);
    }

    protected void removeTokenInSpaceInst(String tokenId, boolean isGroup) {
        for (SpaceInst theSpace : m_hSpaceInstCache.values()) {
            Iterator<SpaceProfileInst> itSpaceProfile = theSpace.getAllSpaceProfilesInst().iterator();
            while (itSpaceProfile.hasNext()) {
                if (isGroup) {
                    itSpaceProfile.next().removeGroup(tokenId);
                    continue;
                }
                itSpaceProfile.next().removeUser(tokenId);
            }
            for (ComponentInst theComponent : theSpace.getAllComponentsInst()) {
                Iterator<ProfileInst> itProfile = theComponent.getAllProfilesInst().iterator();
                while (itProfile.hasNext()) {
                    if (isGroup) {
                        itProfile.next().removeGroup(tokenId);
                        continue;
                    }
                    itProfile.next().removeUser(tokenId);
                }
            }
        }
    }

    public void resetComponentInst() {
        if (m_bUseCache && m_bUseComponentInstCache) {
            SilverTrace.debug("admin", "AdminCache.resetComponentInst", "root.MSG_GEN_ENTER_METHOD");
            m_hComponentInstCache.clear();
        }
    }

    public void putComponentInst(ComponentInst componentInst) {
        if (m_bUseCache && m_bUseComponentInstCache) {
            SilverTrace.debug("admin", "AdminCache.putComponentInst", "root.MSG_GEN_ENTER_METHOD", "ComponentId = " + componentInst.getId());
            m_hComponentInstCache.put(componentInst.getId(), componentInst);
        }
    }

    public void removeComponentInst(ComponentInst componentInst) {
        if (m_bUseCache && m_bUseComponentInstCache) {
            SilverTrace.debug("admin", "AdminCache.removeComponentInst", "root.MSG_GEN_ENTER_METHOD", "ComponentId = " + componentInst.getId());
            m_hComponentInstCache.remove(componentInst.getId());
        }
    }

    public ComponentInst getComponentInst(String componentId) {
        if (m_bUseCache && m_bUseComponentInstCache) {
            return m_hComponentInstCache.get(componentId);
        }
        return null;
    }

    protected void removeUserInComponentInst(String userId) {
        this.removeTokenInComponentInst(userId, false);
    }

    protected void removeGroupInComponentInst(String groupId) {
        this.removeTokenInComponentInst(groupId, true);
    }

    protected void removeTokenInComponentInst(String tokenId, boolean isGroup) {
        for (ComponentInst theComponent : m_hComponentInstCache.values()) {
            Iterator<ProfileInst> itProfile = theComponent.getAllProfilesInst().iterator();
            while (itProfile.hasNext()) {
                if (isGroup) {
                    itProfile.next().removeGroup(tokenId);
                    continue;
                }
                itProfile.next().removeUser(tokenId);
            }
        }
    }

    protected void removeSpaceComponentsInst(String spaceId) {
        ComponentInst[] theComponents;
        for (ComponentInst theComponent : theComponents = m_hComponentInstCache.values().toArray(new ComponentInst[m_hComponentInstCache.size()])) {
            if (!spaceId.equals(this.getShortSpaceId(theComponent.getDomainFatherId()))) continue;
            this.removeComponentsProfilesInst(theComponent.getId());
            this.removeComponentInst(theComponent);
        }
    }

    public void resetProfileInst() {
        if (m_bUseCache && m_bUseProfileInstCache) {
            SilverTrace.debug("admin", "AdminCache.resetProfileInst", "root.MSG_GEN_ENTER_METHOD");
            m_hProfileInstCache.clear();
        }
    }

    public void putProfileInst(ProfileInst profileInst) {
        if (m_bUseCache && m_bUseProfileInstCache) {
            SilverTrace.debug("admin", "AdminCache.putProfileInst", "root.MSG_GEN_ENTER_METHOD", "ProfileId = " + profileInst.getId());
            m_hProfileInstCache.put(profileInst.getId(), profileInst);
        }
    }

    public void removeProfileInst(ProfileInst profileInst) {
        if (m_bUseCache && m_bUseProfileInstCache) {
            SilverTrace.debug("admin", "AdminCache.removeProfileInst", "root.MSG_GEN_ENTER_METHOD", "ProfileId = " + profileInst.getId());
            m_hProfileInstCache.remove(profileInst.getId());
        }
    }

    public ProfileInst getProfileInst(String profileId) {
        if (m_bUseCache && m_bUseProfileInstCache) {
            return m_hProfileInstCache.get(profileId);
        }
        return null;
    }

    protected void removeUserInProfileInst(String userId) {
        this.removeTokenInProfileInst(userId, false);
    }

    protected void removeGroupInProfileInst(String groupId) {
        this.removeTokenInProfileInst(groupId, true);
    }

    protected void removeTokenInProfileInst(String tokenId, boolean isGroup) {
        Iterator<ProfileInst> itProfile = m_hProfileInstCache.values().iterator();
        while (itProfile.hasNext()) {
            if (isGroup) {
                itProfile.next().removeGroup(tokenId);
                continue;
            }
            itProfile.next().removeUser(tokenId);
        }
    }

    protected void removeComponentsProfilesInst(String componentId) {
        ProfileInst[] theProfiles;
        for (ProfileInst theProfile : theProfiles = m_hProfileInstCache.values().toArray(new ProfileInst[m_hProfileInstCache.size()])) {
            if (!componentId.equals(theProfile.getComponentFatherId())) continue;
            this.removeProfileInst(theProfile);
        }
    }

    public void resetUserDetail() {
        SilverTrace.debug("admin", "AdminCache.resetUserDetail", "root.MSG_GEN_ENTER_METHOD");
        m_hUserDetailCache.clear();
    }

    public void putUserDetail(String userId, UserDetail userDetail) {
        if (m_bUseCache && m_bUseUserDetailCache) {
            SilverTrace.debug("admin", "AdminCache.putUserDetail", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId);
            m_hUserDetailCache.put(userId, userDetail);
        }
    }

    public void removeUserDetail(String userId) {
        if (m_bUseCache && m_bUseUserDetailCache) {
            SilverTrace.debug("admin", "AdminCache.removeUserDetail", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId);
            m_hUserDetailCache.remove(userId);
        }
    }

    public UserDetail getUserDetail(String userId) {
        if (m_bUseCache && m_bUseUserDetailCache) {
            return m_hUserDetailCache.get(userId);
        }
        return null;
    }

    public void resetManageableSpaceIds() {
        SilverTrace.debug("admin", "AdminCache.resetManageableSpaceIds", "root.MSG_GEN_ENTER_METHOD");
        m_hManageableSpaceIdsCache.clear();
    }

    public void putManageableSpaceIds(String userId, String[] spaceIds) {
        if (m_bUseCache && m_bUseManageableSpaceIdsCache) {
            SilverTrace.debug("admin", "AdminCache.putManageableSpaceIds", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId);
            m_hManageableSpaceIdsCache.put(userId, spaceIds);
        }
    }

    public void removeManageableSpaceIds(String userId) {
        if (m_bUseCache && m_bUseManageableSpaceIdsCache) {
            SilverTrace.debug("admin", "AdminCache.removeManageableSpaceIds", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId);
            m_hManageableSpaceIdsCache.remove(userId);
        }
    }

    public String[] getManageableSpaceIds(String userId) {
        if (m_bUseCache && m_bUseManageableSpaceIdsCache) {
            return m_hManageableSpaceIdsCache.get(userId);
        }
        return null;
    }

    public void resetAvailCompoIds() {
        SilverTrace.debug("admin", "AdminCache.resetAvailCompoIds", "root.MSG_GEN_ENTER_METHOD");
        m_hAvailCompoIdsCache.clear();
    }

    public void putAvailCompoIds(String spaceId, String userId, String[] compoIds) {
        if (m_bUseCache && m_bUseAvailCompoIdsCache) {
            SilverTrace.debug("admin", "AdminCache.putAvailCompoIds", "root.MSG_GEN_ENTER_METHOD", "spaceId = " + spaceId + " userId = " + userId);
            Map<String, String[]> spaceTable = m_hAvailCompoIdsCache.get(spaceId);
            if (spaceTable == null) {
                spaceTable = new ConcurrentHashMap<String, String[]>();
                m_hAvailCompoIdsCache.put(spaceId, spaceTable);
            }
            spaceTable.put(userId, compoIds);
        }
    }

    public void removeAvailCompoIds(String spaceId, String userId) {
        if (m_bUseCache && m_bUseAvailCompoIdsCache) {
            SilverTrace.debug("admin", "AdminCache.removeAvailCompoIds", "root.MSG_GEN_ENTER_METHOD", "spaceId = " + spaceId + " userId = " + userId);
            Map<String, String[]> spaceTable = m_hAvailCompoIdsCache.get(spaceId);
            if (spaceTable != null) {
                spaceTable.remove(userId);
            }
        }
    }

    public void removeAvailCompoIdsForUser(String userId) {
        if (m_bUseCache && m_bUseAvailCompoIdsCache) {
            SilverTrace.debug("admin", "AdminCache.removeAvailCompoIdsForUser", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId);
            for (Map<String, String[]> spaceTable : m_hAvailCompoIdsCache.values()) {
                spaceTable.remove(userId);
            }
        }
    }

    public void removeAvailCompoIdsForSpace(String spaceId) {
        if (m_bUseCache && m_bUseAvailCompoIdsCache) {
            SilverTrace.debug("admin", "AdminCache.removeAvailCompoIdsForSpace", "root.MSG_GEN_ENTER_METHOD", "spaceUserId = " + spaceId);
            m_hAvailCompoIdsCache.remove(spaceId);
        }
    }

    public String[] getAvailCompoIds(String spaceId, String userId) {
        Map<String, String[]> spaceTable;
        if (m_bUseCache && m_bUseAvailCompoIdsCache && (spaceTable = m_hAvailCompoIdsCache.get(spaceId)) != null) {
            return spaceTable.get(userId);
        }
        return null;
    }

    public void resetProfileIds() {
        SilverTrace.debug("admin", "AdminCache.resetProfileIds", "root.MSG_GEN_ENTER_METHOD");
        m_hProfileIdsCache.clear();
    }

    public void putProfileIds(String userId, String[] profileIds) {
        if (m_bUseCache && m_bUseProfileIdsCache) {
            SilverTrace.debug("admin", "AdminCache.putProfileIds", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId);
            m_hProfileIdsCache.put(userId, profileIds);
        }
    }

    public void putNodeProfileIds(String userId, String[] profileIds) {
        if (m_bUseCache && m_bUseNodeProfileIdsCache) {
            SilverTrace.debug("admin", "AdminCache.putNodeProfileIds", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId);
            m_hNodeProfileIdsCache.put(userId, profileIds);
        }
    }

    public void removeProfileIds(String userId) {
        if (m_bUseCache && m_bUseProfileIdsCache) {
            SilverTrace.debug("admin", "AdminCache.removeProfileIds", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId);
            m_hProfileIdsCache.remove(userId);
        }
    }

    public String[] getProfileIds(String userId) {
        if (m_bUseCache && m_bUseProfileIdsCache) {
            return m_hProfileIdsCache.get(userId);
        }
        return null;
    }

    public String[] getNodeProfileIds(String userId) {
        if (m_bUseCache && m_bUseNodeProfileIdsCache) {
            return m_hNodeProfileIdsCache.get(userId);
        }
        return null;
    }

    public void opAddSpace(SpaceInst theSpace) {
        SpaceInst theFather;
        if (theSpace.getDomainFatherId() != null && theSpace.getDomainFatherId().length() > 0 && !theSpace.getDomainFatherId().equals("0") && (theFather = this.getSpaceInst(this.getShortSpaceId(theSpace.getDomainFatherId()))) != null) {
            String[] allChilds = theFather.getSubSpaceIds();
            if (allChilds == null) {
                allChilds = ArrayUtil.EMPTY_STRING_ARRAY;
            }
            String[] newChilds = new String[allChilds.length + 1];
            System.arraycopy(allChilds, 0, newChilds, 0, allChilds.length);
            newChilds[allChilds.length] = this.getShortSpaceId(theSpace.getId());
            theFather.setSubSpaceIds(newChilds);
        }
    }

    public void opUpdateSpace(SpaceInst theSpace) {
        this.opResetSpace(theSpace);
    }

    public void opRemoveSpace(SpaceInst theSpace) {
        SpaceInst theFather;
        if (theSpace.getDomainFatherId() != null && theSpace.getDomainFatherId().length() > 0 && !theSpace.getDomainFatherId().equals("0") && (theFather = this.getSpaceInst(this.getShortSpaceId(theSpace.getDomainFatherId()))) != null) {
            String[] allChilds = theFather.getSubSpaceIds();
            String theSpaceId = this.getShortSpaceId(theSpace.getId());
            List<String> newChilds = CollectionUtil.asList(allChilds);
            newChilds.remove(theSpaceId);
            theFather.setSubSpaceIds(newChilds.toArray(new String[newChilds.size()]));
        }
        this.opResetSpace(theSpace);
    }

    protected void opResetSpace(SpaceInst theSpace) {
        this.removeSpaceComponentsInst(theSpace.getId());
        this.removeSpaceInst(theSpace.getId());
        this.resetProfileIds();
        this.resetAvailCompoIds();
        this.resetManageableSpaceIds();
    }

    public void opAddComponent(ComponentInst component) {
        this.opResetComponent(component);
    }

    public void opUpdateComponent(ComponentInst component) {
        this.opResetComponent(component);
    }

    public void opRemoveComponent(ComponentInst component) {
        this.opResetComponent(component);
    }

    protected void opResetComponent(ComponentInst component) {
        this.removeComponentsProfilesInst(component.getId());
        SpaceInst theSpace = this.getSpaceInst(this.getShortSpaceId(component.getDomainFatherId()));
        if (theSpace != null) {
            this.removeSpaceInst(theSpace.getId());
        }
        this.removeComponentInst(component);
        this.resetProfileIds();
        this.resetAvailCompoIds();
    }

    public void opAddProfile(ProfileInst profile) {
        this.opResetProfile(profile);
    }

    public void opUpdateProfile(ProfileInst profile) {
        this.opResetProfile(profile);
    }

    public void opRemoveProfile(ProfileInst profile) {
        this.opResetProfile(profile);
    }

    protected void opResetProfile(ProfileInst profile) {
        ComponentInst theComponent = this.getComponentInst(profile.getComponentFatherId());
        if (theComponent != null) {
            SpaceInst theSpace = this.getSpaceInst(this.getShortSpaceId(theComponent.getDomainFatherId()));
            if (theSpace != null) {
                this.removeSpaceInst(theSpace.getId());
            }
            this.removeComponentInst(theComponent);
        }
        this.removeProfileInst(profile);
        this.resetProfileIds();
        this.resetAvailCompoIds();
    }

    public void opAddSpaceProfile(SpaceProfileInst profile) {
        SpaceInst theSpace = this.getSpaceInst(this.getShortSpaceId(profile.getSpaceFatherId()));
        if (theSpace != null) {
            theSpace.addSpaceProfileInst(profile);
        }
        this.resetManageableSpaceIds();
    }

    public void opUpdateSpaceProfile(SpaceProfileInst profile) {
        SpaceInst theSpace = this.getSpaceInst(this.getShortSpaceId(profile.getSpaceFatherId()));
        if (theSpace != null) {
            theSpace.deleteSpaceProfileInst(profile);
            theSpace.addSpaceProfileInst(profile);
        }
        this.resetManageableSpaceIds();
    }

    public void opRemoveSpaceProfile(SpaceProfileInst profile) {
        SpaceInst theSpace = this.getSpaceInst(this.getShortSpaceId(profile.getSpaceFatherId()));
        if (theSpace != null) {
            theSpace.deleteSpaceProfileInst(profile);
        }
        this.resetManageableSpaceIds();
    }

    public void opAddGroup(Group group) {
        if (StringUtil.isDefined(group.getSuperGroupId())) {
            String[] uids;
            for (String uid : uids = group.getUserIds()) {
                this.opResetUserRights(uid);
            }
        }
    }

    public void opUpdateGroup(Group group) {
        this.resetProfileIds();
        this.resetAvailCompoIds();
        this.resetManageableSpaceIds();
    }

    public void opRemoveGroup(Group group) {
        String groupId = group.getId();
        this.removeGroupInSpaceInst(groupId);
        this.removeGroupInComponentInst(groupId);
        this.removeGroupInProfileInst(groupId);
        this.resetProfileIds();
        this.resetAvailCompoIds();
        this.resetManageableSpaceIds();
    }

    public void opAddUserInGroup(String userId, String groupId) {
        this.opResetUserRights(userId);
    }

    public void opRemoveUserFromGroup(String userId, String groupId) {
        this.opResetUserRights(userId);
    }

    public void opAddUser(UserDetail user) {
    }

    public void opUpdateUser(UserDetail user) {
        this.removeUserDetail(user.getId());
    }

    public void opRemoveUser(UserDetail user) {
        String userId = user.getId();
        this.removeUserDetail(userId);
        this.removeProfileIds(userId);
        this.removeManageableSpaceIds(userId);
        this.removeAvailCompoIdsForUser(userId);
        this.removeUserInSpaceInst(userId);
        this.removeUserInComponentInst(userId);
        this.removeUserInProfileInst(userId);
    }

    protected void opResetUserRights(String userId) {
        this.removeProfileIds(userId);
        this.removeManageableSpaceIds(userId);
        this.removeAvailCompoIdsForUser(userId);
    }

    protected String getShortSpaceId(String spaceId) {
        if (spaceId != null && spaceId.startsWith("WA")) {
            return spaceId.substring(2);
        }
        return spaceId == null ? "" : spaceId;
    }
}

