/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin.dao;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.PaginationPage;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.dao.UserSearchCriteriaForDAO;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.silverpeas.admin.user.constant.UserAccessLevel;
import org.silverpeas.admin.user.constant.UserState;
import org.silverpeas.util.ListSlice;

public class UserDAO {
    private static final String USER_COLUMNS = "DISTINCT(id),specificId,domainId,login,firstName,lastName,loginMail,email,accessLevel,loginQuestion,loginAnswer,creationDate,saveDate,version,tosAcceptanceDate,lastLoginDate,nbSuccessfulLoginAttempts,lastLoginCredentialUpdateDate,expirationDate,state,stateSaveDate, notifManualReceiverLimit";
    private static final String SELECT_DOMAINS_BY_LOGIN = "SELECT DISTINCT(domainId) AS domain FROM st_user WHERE state NOT IN ('DELETED', 'UNKNOWN', 'BLOCKED', 'DEACTIVATED', 'EXPIRED') AND login = ? ORDER BY domainId";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDomainsContainingLogin(Connection connection, String login) throws SQLException {
        ArrayList<String> arrayList;
        ArrayList<String> domainIds = new ArrayList<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(SELECT_DOMAINS_BY_LOGIN);
            statement.setString(1, login);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                domainIds.add(resultSet.getString("domain"));
            }
            arrayList = domainIds;
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet, statement);
            throw throwable;
        }
        DBUtil.close(resultSet, statement);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListSlice<UserDetail> getUsersByCriteria(Connection connection, UserSearchCriteriaForDAO criteria) throws SQLException {
        ListSlice<UserDetail> users;
        ResultSet resultSet;
        PreparedStatement statement;
        block3: {
            statement = null;
            resultSet = null;
            try {
                String query = criteria.toSQLQuery(USER_COLUMNS);
                statement = connection.prepareStatement(query, 1004, 1007);
                resultSet = statement.executeQuery();
                if (criteria.isPaginationSet()) {
                    PaginationPage page = criteria.getPagination();
                    int start = (page.getPageNumber() - 1) * page.getPageSize();
                    int end = start + page.getPageSize();
                    users = UserDAO.theUserDetailsFrom(resultSet, start, end);
                    break block3;
                }
                users = new ListSlice<UserDetail>((Collection<UserDetail>)UserDAO.theUserDetailsFrom(resultSet));
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet, statement);
                throw throwable;
            }
        }
        DBUtil.close(resultSet, statement);
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUserCountByCriteria(Connection connection, UserSearchCriteriaForDAO criteria) throws SQLException {
        int n;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            String query = criteria.toSQLQuery("COUNT(DISTINCT id)");
            statement = connection.prepareStatement(query);
            resultSet = statement.executeQuery();
            resultSet.next();
            n = resultSet.getInt(1);
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet, statement);
            throw throwable;
        }
        DBUtil.close(resultSet, statement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserDetail> getUsersOfGroups(Connection con, List<String> groupIds) throws SQLException {
        List<UserDetail> list;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT DISTINCT(id),specificId,domainId,login,firstName,lastName,loginMail,email,accessLevel,loginQuestion,loginAnswer,creationDate,saveDate,version,tosAcceptanceDate,lastLoginDate,nbSuccessfulLoginAttempts,lastLoginCredentialUpdateDate,expirationDate,state,stateSaveDate, notifManualReceiverLimit FROM st_user u, st_group_user_rel g WHERE g.userid = u.id AND g.groupid IN (" + StringUtil.join(groupIds, (char)',') + ")" + " AND state <> 'DELETED' ORDER BY lastName";
            stmt = con.createStatement();
            rs = stmt.executeQuery(query);
            list = UserDAO.theUserDetailsFrom(rs);
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUserIdsOfGroups(Connection con, List<String> groupIds) throws SQLException {
        ArrayList<String> arrayList;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT DISTINCT(u.id), u.lastname FROM st_user u, st_group_user_rel g WHERE g.userid = u.id AND g.groupid IN (" + StringUtil.join(groupIds, (char)',') + ")" + " AND u.state <> 'DELETED' ORDER BY u.lastName";
            stmt = con.createStatement();
            rs = stmt.executeQuery(query);
            ArrayList<String> ids = new ArrayList<String>();
            while (rs.next()) {
                ids.add(Integer.toString(rs.getInt(1)));
            }
            arrayList = ids;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    public List<UserDetail> getAllUsers(Connection con) throws SQLException {
        return this.getAllUsers(con, null, null);
    }

    public List<UserDetail> getAllUsersFromNewestToOldest(Connection con) throws SQLException {
        return this.getAllUsers(con, null, "id DESC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UserDetail> getAllUsers(Connection con, List<String> domainIds, String orderBy) throws SQLException {
        List<UserDetail> list;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT DISTINCT(id),specificId,domainId,login,firstName,lastName,loginMail,email,accessLevel,loginQuestion,loginAnswer,creationDate,saveDate,version,tosAcceptanceDate,lastLoginDate,nbSuccessfulLoginAttempts,lastLoginCredentialUpdateDate,expirationDate,state,stateSaveDate, notifManualReceiverLimit FROM st_user WHERE state <> 'DELETED' ";
            if (domainIds != null && !domainIds.isEmpty()) {
                query = query + " AND domainId IN (" + StringUtil.join(domainIds, (char)',') + ")";
            }
            query = StringUtil.isDefined(orderBy) ? query + " ORDER BY " + orderBy : query + " ORDER BY lastName";
            stmt = con.createStatement();
            rs = stmt.executeQuery(query);
            list = UserDAO.theUserDetailsFrom(rs);
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return list;
    }

    public List<UserDetail> getUsersOfDomains(Connection con, List<String> domainIds) throws SQLException {
        return this.getAllUsers(con, domainIds, null);
    }

    public List<UserDetail> getUsersOfDomainsFromNewestToOldest(Connection con, List<String> domainIds) throws SQLException {
        return this.getAllUsers(con, domainIds, "id DESC");
    }

    private static List<UserDetail> theUserDetailsFrom(ResultSet resultSet) throws SQLException {
        ArrayList<UserDetail> users = new ArrayList<UserDetail>();
        while (resultSet.next()) {
            users.add(UserDAO.fetchUser(resultSet));
        }
        return users;
    }

    private static ListSlice<UserDetail> theUserDetailsFrom(ResultSet rs, int start, int end) throws SQLException {
        ListSlice<UserDetail> users = new ListSlice<UserDetail>(start, end);
        if (start > 0) {
            rs.next();
            rs.relative(start - 1);
        }
        int i = start;
        while (rs.next()) {
            if (i < end) {
                users.add(UserDAO.fetchUser(rs));
            }
            ++i;
        }
        users.setOriginalListSize(i);
        return users;
    }

    private static UserDetail fetchUser(ResultSet rs) throws SQLException {
        UserDetail u = new UserDetail();
        u.setId(Integer.toString(rs.getInt(1)));
        u.setSpecificId(rs.getString(2));
        u.setDomainId(Integer.toString(rs.getInt(3)));
        u.setLogin(rs.getString(4));
        u.setFirstName(rs.getString(5));
        u.setLastName(rs.getString(6));
        u.seteMail(rs.getString(8));
        u.setAccessLevel(UserAccessLevel.fromCode(rs.getString(9)));
        u.setLoginQuestion(rs.getString(10));
        u.setLoginAnswer(rs.getString(11));
        u.setCreationDate(rs.getTimestamp(12));
        u.setSaveDate(rs.getTimestamp(13));
        u.setVersion(rs.getInt(14));
        u.setTosAcceptanceDate(rs.getTimestamp(15));
        u.setLastLoginDate(rs.getTimestamp(16));
        u.setNbSuccessfulLoginAttempts(rs.getInt(17));
        u.setLastLoginCredentialUpdateDate(rs.getTimestamp(18));
        u.setExpirationDate(rs.getTimestamp(19));
        u.setState(UserState.from(rs.getString(20)));
        u.setStateSaveDate(rs.getTimestamp(21));
        if (StringUtil.isInteger(rs.getString(22))) {
            u.setNotifManualReceiverLimit(rs.getInt(22));
        }
        return u;
    }
}

