/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.stratelia.webactiv.organization.AccessLevelRow;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.OrganizationSchema;
import com.stratelia.webactiv.organization.Table;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class AccessLevelTable
extends Table<AccessLevelRow> {
    private static final String SELECT_ALL_ACCESSLEVELS = "SELECT id, name FROM ST_AccessLevel";
    private static final String SELECT_ACCESSLEVEL_BY_ID = "SELECT id, name FROM  ST_AccessLevel WHERE id = ?";

    public AccessLevelTable(OrganizationSchema organization) {
        super(organization, "ST_AccessLevel");
    }

    protected AccessLevelRow fetchAccessLevel(ResultSet rs) throws SQLException {
        AccessLevelRow a = new AccessLevelRow();
        a.id = rs.getString("id");
        a.name = rs.getString("name");
        return a;
    }

    public AccessLevelRow[] getAllAccessLevels() throws AdminPersistenceException {
        return this.getRows(SELECT_ALL_ACCESSLEVELS).toArray(new AccessLevelRow[this.getRows(SELECT_ALL_ACCESSLEVELS).size()]);
    }

    public AccessLevelRow getAccessLevel(String id) throws AdminPersistenceException {
        return (AccessLevelRow)this.getUniqueRow(SELECT_ACCESSLEVEL_BY_ID, id);
    }

    @Override
    protected AccessLevelRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchAccessLevel(rs);
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, AccessLevelRow row) {
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, AccessLevelRow row) {
    }
}

