/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.stratelia.silverpeas.silverpeasinitialize.CallBackManager;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.ComponentInstanceRow;
import com.stratelia.webactiv.organization.OrganizationSchema;
import com.stratelia.webactiv.organization.SpaceRow;
import com.stratelia.webactiv.organization.Table;
import com.stratelia.webactiv.organization.UserRoleRow;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

public class ComponentInstanceTable
extends Table<ComponentInstanceRow> {
    private final CallBackManager callBackManager = CallBackManager.get();
    private static final String INSTANCE_COLUMNS = "id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked";
    private static final String SELECT_INSTANCE_BY_ID = "select id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked from ST_ComponentInstance where id = ?";
    private static final String SELECT_USERROLE_INSTANCE = "select " + Table.aliasColumns("i", "id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked") + " from ST_ComponentInstance i, ST_UserRole us" + " where i.id = us.instanceId and us.id = ?";
    private static final String SELECT_ALL_SPACE_INSTANCES = "select id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked from ST_ComponentInstance where spaceId = ? and componentStatus is null order by orderNum";
    private static final String SELECT_ALL_SPACE_INSTANCE_IDS = "select id from ST_ComponentInstance where spaceId = ? and componentStatus is null order by orderNum";
    private static final String SELECT_REMOVED_COMPONENTS = "select id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked from ST_ComponentInstance where componentStatus = 'R' order by removeTime desc";
    private static final String INSERT_INSTANCE = "insert into ST_ComponentInstance(id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_COMPONENT_ORDER = "update ST_ComponentInstance set orderNum = ? where id = ?";
    private static final String UPDATE_COMPONENT_INHERITANCE = "update ST_ComponentInstance set isInheritanceBlocked = ? where id = ?";
    private static final String UPDATE_INSTANCE = "update ST_ComponentInstance set name = ?, description = ?, createdBy = ?, orderNum = ?, updateTime = ?, updatedBy = ?, componentStatus = ?, isPublic = ?, isHidden = ?, lang = ?, isInheritanceBlocked = ? where id = ?";
    private static final String IS_COMPONENT_INTO_BASKET = "select * from ST_ComponentInstance where name = ? and spaceId = ? and componentStatus = ? ";
    private static final String SEND_COMPONENT_IN_BASKET = "update ST_ComponentInstance set name = ?, removedBy = ?, removeTime = ?, componentStatus = ? where id = ?";
    private static final String RESTORE_COMPONENT_FROM_BASKET = "update ST_ComponentInstance set removedBy = ?, removeTime = ?, componentStatus = ? where id = ?";
    private static final String MOVE_COMPONENT_INSTANCE = "update ST_ComponentInstance set spaceId = ? where id = ?";
    private static final String DELETE_INSTANCE = "delete from ST_ComponentInstance where id = ?";
    private OrganizationSchema organization = null;

    public ComponentInstanceTable(OrganizationSchema organization) {
        super(organization, "ST_ComponentInstance");
        this.organization = organization;
    }

    protected ComponentInstanceRow fetchComponentInstance(ResultSet rs) throws SQLException {
        ComponentInstanceRow i = new ComponentInstanceRow();
        i.id = rs.getInt(1);
        i.spaceId = rs.getInt(2);
        i.name = rs.getString(3);
        i.componentName = rs.getString(4);
        i.description = Table.getNotNullString(rs.getString(5));
        i.createdBy = rs.getInt(6);
        if (rs.wasNull()) {
            i.createdBy = -1;
        }
        i.orderNum = rs.getInt(7);
        if (rs.wasNull()) {
            i.orderNum = -1;
        }
        i.createTime = rs.getString(8);
        i.updateTime = rs.getString(9);
        i.removeTime = rs.getString(10);
        i.status = rs.getString(11);
        i.updatedBy = rs.getInt(12);
        if (rs.wasNull()) {
            i.updatedBy = -1;
        }
        i.removedBy = rs.getInt(13);
        if (rs.wasNull()) {
            i.removedBy = -1;
        }
        i.publicAccess = rs.getInt(14);
        i.hidden = rs.getInt(15);
        i.lang = rs.getString(16);
        i.inheritanceBlocked = rs.getInt(17);
        return i;
    }

    public ComponentInstanceRow getComponentInstance(int id) throws AdminPersistenceException {
        return (ComponentInstanceRow)this.getUniqueRow(SELECT_INSTANCE_BY_ID, id);
    }

    public ComponentInstanceRow getComponentInstanceOfUserRole(int userRoleId) throws AdminPersistenceException {
        return (ComponentInstanceRow)this.getUniqueRow(SELECT_USERROLE_INSTANCE, userRoleId);
    }

    public ComponentInstanceRow[] getAllComponentInstancesInSpace(int spaceId) throws AdminPersistenceException {
        List<ComponentInstanceRow> rows = this.getRows(SELECT_ALL_SPACE_INSTANCES, spaceId);
        return rows.toArray(new ComponentInstanceRow[rows.size()]);
    }

    public String[] getAllComponentInstanceIdsInSpace(int spaceId) throws AdminPersistenceException {
        List<String> ids = this.getIds(SELECT_ALL_SPACE_INSTANCE_IDS, spaceId);
        return ids.toArray(new String[ids.size()]);
    }

    public ComponentInstanceRow[] getRemovedComponents() throws AdminPersistenceException {
        List<ComponentInstanceRow> rows = this.getRows(SELECT_REMOVED_COMPONENTS);
        return rows.toArray(new ComponentInstanceRow[rows.size()]);
    }

    public ComponentInstanceRow[] getAllMatchingComponentInstances(ComponentInstanceRow sampleInstance) throws AdminPersistenceException {
        String[] columns = new String[]{"componentName", "name", "description"};
        String[] values = new String[]{sampleInstance.componentName, sampleInstance.name, sampleInstance.description};
        List<ComponentInstanceRow> rows = this.getMatchingRows(INSTANCE_COLUMNS, columns, values);
        return rows.toArray(new ComponentInstanceRow[rows.size()]);
    }

    public void createComponentInstance(ComponentInstanceRow instance) throws AdminPersistenceException {
        SpaceRow space = this.organization.space.getSpace(instance.spaceId);
        if (space == null) {
            throw new AdminPersistenceException("ComponentInstanceTable.createComponentInstance", 4, "admin.EX_ERR_SPACE_NOT_FOUND");
        }
        this.insertRow(INSERT_INSTANCE, instance);
        this.callBackManager.invoke(6, instance.id, null, null);
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, ComponentInstanceRow row) throws SQLException {
        if (row.id == -1) {
            row.id = this.getNextId();
        }
        insert.setInt(1, row.id);
        insert.setInt(2, row.spaceId);
        insert.setString(3, Table.truncate(row.name, 100));
        insert.setString(4, Table.truncate(row.componentName, 100));
        insert.setString(5, Table.truncate(row.description, 500));
        if (row.createdBy == -1) {
            insert.setNull(6, 4);
        } else {
            insert.setInt(6, row.createdBy);
        }
        insert.setInt(7, row.orderNum);
        insert.setString(8, String.valueOf(new Date().getTime()));
        insert.setString(9, null);
        insert.setString(10, null);
        insert.setString(11, row.status);
        insert.setNull(12, 4);
        insert.setNull(13, 4);
        insert.setInt(14, row.publicAccess);
        insert.setInt(15, row.hidden);
        insert.setString(16, row.lang);
        insert.setInt(17, row.inheritanceBlocked);
    }

    public void updateComponentOrder(int componentId, int orderNum) throws AdminPersistenceException {
        int[] values = new int[]{orderNum, componentId};
        this.updateRelation(UPDATE_COMPONENT_ORDER, values);
    }

    public void updateComponentInheritance(int componentId, boolean inheritanceBlocked) throws AdminPersistenceException {
        int iInheritance = 0;
        if (inheritanceBlocked) {
            iInheritance = 1;
        }
        int[] values = new int[]{iInheritance, componentId};
        this.updateRelation(UPDATE_COMPONENT_INHERITANCE, values);
    }

    public void updateComponentInstance(ComponentInstanceRow instance) throws AdminPersistenceException {
        this.updateRow(UPDATE_INSTANCE, instance);
    }

    public boolean isComponentIntoBasket(int spaceId, String name) throws AdminPersistenceException {
        boolean bl;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.organization.getStatement(IS_COMPONENT_INTO_BASKET);
            statement.setString(1, name);
            statement.setInt(2, spaceId);
            statement.setString(3, "R");
            rs = statement.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new AdminPersistenceException("ComponentInstanceTable.isComponentIntoBasket", 4, "admin.EX_ERR_SELECT", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close(rs, statement);
        return bl;
    }

    public void sendComponentToBasket(int id, String tempLabel, String userId) throws AdminPersistenceException {
        PreparedStatement statement = null;
        try {
            statement = this.organization.getStatement(SEND_COMPONENT_IN_BASKET);
            statement.setString(1, tempLabel);
            statement.setInt(2, Integer.parseInt(userId));
            statement.setString(3, Long.toString(new Date().getTime()));
            statement.setString(4, "R");
            statement.setInt(5, id);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new AdminPersistenceException("ComponentInstanceTable.sendComponentToBasket", 4, "admin.EX_ERR_UPDATE", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
    }

    public void restoreComponentFromBasket(int id) throws AdminPersistenceException {
        PreparedStatement statement = null;
        try {
            statement = this.organization.getStatement(RESTORE_COMPONENT_FROM_BASKET);
            statement.setNull(1, 4);
            statement.setNull(2, 12);
            statement.setNull(3, 12);
            statement.setInt(4, id);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new AdminPersistenceException("ComponentInstanceTable.restoreComponentFromBasket", 4, "admin.EX_ERR_UPDATE", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
    }

    public void moveComponentInstance(int spaceId, int componentId) throws AdminPersistenceException {
        int[] param = new int[]{spaceId, componentId};
        this.callBackManager.invoke(7, componentId, null, null);
        this.updateRelation(MOVE_COMPONENT_INSTANCE, param);
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, ComponentInstanceRow row) throws SQLException {
        update.setString(1, Table.truncate(row.name, 100));
        update.setString(2, Table.truncate(row.description, 500));
        if (row.createdBy == -1) {
            update.setNull(3, 4);
        } else {
            update.setInt(3, row.createdBy);
        }
        update.setInt(4, row.orderNum);
        update.setString(5, String.valueOf(new Date().getTime()));
        if (row.updatedBy == -1) {
            update.setNull(6, 4);
        } else {
            update.setInt(6, row.updatedBy);
        }
        update.setString(7, row.status);
        update.setInt(8, row.publicAccess);
        update.setInt(9, row.hidden);
        update.setString(10, row.lang);
        update.setInt(11, row.inheritanceBlocked);
        update.setInt(12, row.id);
    }

    public void removeComponentInstance(int id) throws AdminPersistenceException {
        UserRoleRow[] roles;
        ComponentInstanceRow instance = this.getComponentInstance(id);
        if (instance == null) {
            return;
        }
        this.callBackManager.invoke(7, id, instance.componentName + id, null);
        for (UserRoleRow role : roles = this.organization.userRole.getAllUserRolesOfInstance(id)) {
            this.organization.userRole.removeUserRole(role.id);
        }
        this.organization.instanceData.removeInstanceData(id);
        this.updateRelation(DELETE_INSTANCE, id);
    }

    @Override
    protected ComponentInstanceRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchComponentInstance(rs);
    }
}

