/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util;

import com.silverpeas.calendar.DateTime;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.exception.MultilangMessage;
import com.stratelia.webactiv.util.exception.UtilException;
import com.stratelia.webactiv.util.pool.ConnectionPool;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.lang3.tuple.Pair;

public class DBUtil {
    private static DBUtil instance;
    private Connection connectionForTest;
    private volatile int textFieldLength = 1000;
    private volatile int textAreaLength = 2000;
    private volatile int textMaxiLength = 4000;
    private volatile int dateFieldLength = 10;
    private InitialContext ic = null;
    private static Map<String, DataSource> dsStock;
    private static final String TABLE_NAME = "TABLE_NAME";

    public static int getDateFieldLength() {
        return DBUtil.getInstance().dateFieldLength;
    }

    public static int getTextMaxiLength() {
        return DBUtil.getInstance().textMaxiLength;
    }

    public static int getTextAreaLength() {
        return DBUtil.getInstance().textAreaLength;
    }

    public static int getTextFieldLength() {
        return DBUtil.getInstance().textFieldLength;
    }

    private DBUtil(Connection connectionForTest) {
        this.connectionForTest = connectionForTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBUtil getInstance() {
        Class<DBUtil> clazz = DBUtil.class;
        synchronized (DBUtil.class) {
            if (instance == null) {
                instance = new DBUtil(null);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBUtil getInstanceForTest(Connection connectionForTest) {
        DBUtil.clearTestInstance();
        Class<DBUtil> clazz = DBUtil.class;
        synchronized (DBUtil.class) {
            if (connectionForTest != null) {
                instance = new DBUtil(connectionForTest);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTestInstance() {
        Class<DBUtil> clazz = DBUtil.class;
        synchronized (DBUtil.class) {
            if (instance != null) {
                DBUtil.close(DBUtil.instance.connectionForTest);
            }
            instance = new DBUtil(null);
            dsStock.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Connection makeConnection(String dbName) {
        return DBUtil.getInstance().openConnection(dbName);
    }

    private synchronized Connection openConnection(String dbName) {
        SilverTrace.debug("util", "DBUtil makeConnection", "DBUtil : makeConnection : entree");
        DataSource ds = null;
        if (this.ic == null) {
            try {
                this.ic = new InitialContext();
            }
            catch (NamingException e) {
                throw new UtilException("DBUtil.makeConnection", "util.MSG_CANT_GET_INITIAL_CONTEXT", e);
            }
        }
        try {
            ds = dsStock.get(dbName);
            if (ds == null) {
                ds = (DataSource)this.ic.lookup(dbName);
                dsStock.put(dbName, ds);
            }
        }
        catch (NamingException e) {
            throw new UtilException("DBUtil.makeConnection", new MultilangMessage("util.MSG_BDD_REF_NOT_FOUND", dbName).toString(), e);
        }
        try {
            return ds.getConnection();
        }
        catch (SQLException e) {
            throw new UtilException("DBUtil.makeConnection", new MultilangMessage("util.MSG_BDD_REF_CANT_GET_CONNECTION", dbName).toString(), e);
        }
    }

    public static String getUniqueId() {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getNextId(String tableName, String idName) throws UtilException {
        Connection privateConnection = null;
        boolean testingMode = false;
        try {
            Class<DBUtil> clazz = DBUtil.class;
            synchronized (DBUtil.class) {
                if (DBUtil.getInstance().connectionForTest != null) {
                    privateConnection = DBUtil.getInstance().connectionForTest;
                    testingMode = true;
                } else {
                    privateConnection = ConnectionPool.getConnection();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                privateConnection.setAutoCommit(false);
                int n = DBUtil.getNextId(privateConnection, tableName, idName);
                return n;
            }
        }
        catch (Exception ex) {
            SilverTrace.debug("util", "DBUtil.getNextId", "impossible de recup\u00e9rer le prochain id", ex);
            if (privateConnection != null) {
                DBUtil.rollback(privateConnection);
            }
            throw new UtilException("DBUtil.getNextId", new MultilangMessage("util.MSG_CANT_GET_A_NEW_UNIQUE_ID", tableName, idName).toString(), ex);
        }
        finally {
            try {
                if (privateConnection != null && !testingMode) {
                    privateConnection.close();
                }
            }
            catch (SQLException e) {
                SilverTrace.error("util", "DBUtil.getNextId", "root.EX_CONNECTION_CLOSE_FAILED", e);
            }
        }
    }

    public static synchronized int getNextId(Connection connection, String tableName, String idName) throws SQLException {
        return DBUtil.getMaxId(connection, tableName, idName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getMaxId(Connection privateConnection, String tableName, String idName) throws SQLException {
        SilverTrace.debug("util", "DBUtil.getNextId", "dBName = " + tableName);
        try {
            int max = DBUtil.updateMaxFromTable(privateConnection, tableName);
            privateConnection.commit();
            return max;
        }
        catch (Exception e) {
            int n;
            SilverTrace.debug("util", "DBUtil.getNextId", "impossible d'updater, if faut recuperer la valeur initiale", e);
            int max = DBUtil.getMaxFromTable(privateConnection, tableName, idName);
            PreparedStatement createStmt = null;
            try {
                String createStatement = "INSERT INTO UniqueId (maxId, tableName) VALUES (?, ?)";
                createStmt = privateConnection.prepareStatement(createStatement);
                createStmt.setInt(1, max);
                createStmt.setString(2, tableName.toLowerCase());
                createStmt.executeUpdate();
                privateConnection.commit();
                n = max;
            }
            catch (Exception e2) {
                try {
                    SilverTrace.debug("util", "DBUtil.getNextId", "impossible de creer, if faut reessayer l'update", e2);
                    DBUtil.rollback(privateConnection);
                }
                catch (Throwable throwable) {
                    DBUtil.close(createStmt);
                    throw throwable;
                }
                DBUtil.close(createStmt);
            }
            DBUtil.close(createStmt);
            return n;
            max = DBUtil.updateMaxFromTable(privateConnection, tableName);
            privateConnection.commit();
            return max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateMaxFromTable(Connection connection, String tableName) throws SQLException {
        block9: {
            String table = tableName.toLowerCase(Locale.ROOT);
            int max = 0;
            PreparedStatement prepStmt = null;
            int count = 0;
            try {
                prepStmt = connection.prepareStatement("UPDATE UniqueId SET maxId = maxId + 1 WHERE tableName = ?");
                prepStmt.setString(1, table);
                count = prepStmt.executeUpdate();
                connection.commit();
            }
            catch (SQLException sqlex) {
                DBUtil.rollback(connection);
                throw sqlex;
            }
            finally {
                DBUtil.close(prepStmt);
            }
            if (count != 1) break block9;
            PreparedStatement selectStmt = null;
            ResultSet rs = null;
            try {
                selectStmt = connection.prepareStatement("SELECT maxId FROM UniqueId WHERE tableName = ?");
                selectStmt.setString(1, table);
                rs = selectStmt.executeQuery();
                if (!rs.next()) {
                    SilverTrace.error("util", "DBUtil.getNextId", "util.MSG_NO_RECORD_FOUND");
                    throw new RuntimeException("Erreur Interne DBUtil.getNextId()");
                }
                max = rs.getInt(1);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, selectStmt);
                throw throwable;
            }
            DBUtil.close(rs, selectStmt);
            return max;
        }
        throw new SQLException("Update impossible : Ligne non existante");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxFromTable(Connection con, String tableName, String idName) {
        if (!StringUtil.isDefined(tableName) || !StringUtil.isDefined(idName)) {
            return 1;
        }
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            int maxFromTable = 0;
            String nextPKStatement = "SELECT MAX(" + idName + ") " + "FROM " + tableName;
            prepStmt = con.prepareStatement(nextPKStatement);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                maxFromTable = rs.getInt(1);
            }
            int n = maxFromTable + 1;
            DBUtil.close(rs, prepStmt);
            return n;
        }
        catch (SQLException ex) {
            DBUtil.rollback(con);
            int n = 1;
            return n;
        }
        finally {
            DBUtil.close(rs, prepStmt);
        }
    }

    public static void close(ResultSet rs, Statement st) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                SilverTrace.error("util", "DBUtil.close", "util.CAN_T_CLOSE_RESULTSET", e);
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                SilverTrace.error("util", "DBUtil.close", "util.CAN_T_CLOSE_STATEMENT", e);
            }
        }
    }

    public static void close(Statement st) {
        DBUtil.close(null, st);
    }

    public static void close(ResultSet rs) {
        DBUtil.close(rs, null);
    }

    public static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                SilverTrace.error("util", "DBUtil.close", "util.CAN_T_CLOSE_CONNECTION", e);
            }
        }
    }

    public static void rollback(Connection connection) {
        if (connection != null) {
            try {
                if (!connection.getAutoCommit() && !connection.isClosed()) {
                    connection.rollback();
                }
            }
            catch (SQLException e) {
                SilverTrace.error("util", "DBUtil.close", "util.CAN_T_ROLLBACK_CONNECTION", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> getAllTableNames() {
        Connection privateConnection = null;
        ResultSet tables_rs = null;
        boolean testingMode = false;
        LinkedHashSet<String> tableNames = new LinkedHashSet<String>();
        try {
            Class<DBUtil> clazz = DBUtil.class;
            synchronized (DBUtil.class) {
                if (DBUtil.getInstance().connectionForTest != null) {
                    privateConnection = DBUtil.getInstance().connectionForTest;
                    testingMode = true;
                } else {
                    privateConnection = ConnectionPool.getConnection();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                DatabaseMetaData dbMetaData = privateConnection.getMetaData();
                tables_rs = dbMetaData.getTables(null, null, null, null);
                tables_rs.getMetaData();
                while (tables_rs.next()) {
                    tableNames.add(tables_rs.getString(TABLE_NAME));
                }
                DBUtil.close(tables_rs);
                if (privateConnection == null) return tableNames;
                if (testingMode) return tableNames;
            }
        }
        catch (Exception e) {
            SilverTrace.debug("util", "DBUtil.getAllTableNames", "database error ...", e);
            return tableNames;
        }
        {
            DBUtil.close(privateConnection);
            return tableNames;
        }
        finally {
            DBUtil.close(tables_rs);
            if (privateConnection != null && !testingMode) {
                DBUtil.close(privateConnection);
            }
        }
    }

    public static boolean isSqlDefined(String sqlValue) {
        return StringUtil.isDefined(sqlValue) && !sqlValue.trim().equals("-1") && !sqlValue.trim().equals("unknown");
    }

    public static <O> long selectCount(Connection con, String selectCountQuery, O idParam) throws SQLException {
        return DBUtil.selectCount(con, selectCountQuery, Arrays.asList(idParam));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <O> long selectCount(Connection con, String selectCountQuery, Collection<O> params) throws SQLException {
        long l;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(selectCountQuery);
            DBUtil.setParameters(prepStmt, params);
            rs = prepStmt.executeQuery();
            rs.next();
            long count = rs.getLong(1);
            if (rs.next()) {
                throw new IllegalArgumentException("select count execution error");
            }
            l = count;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, prepStmt);
            throw throwable;
        }
        DBUtil.close(rs, prepStmt);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <ROW_ENTITY> List<ROW_ENTITY> select(Connection con, String updateQuery, Object parameters, SelectResultRowProcessor<ROW_ENTITY> rowProcess) throws SQLException {
        ArrayList<ROW_ENTITY> arrayList;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement(updateQuery);
            Collection<Object> sqlParams = parameters instanceof Object[] ? Arrays.asList((Object[])parameters) : (parameters instanceof Collection ? (Collection)parameters : Arrays.asList(parameters));
            DBUtil.setParameters(st, sqlParams);
            rs = st.executeQuery();
            ArrayList<ROW_ENTITY> entities = new ArrayList<ROW_ENTITY>();
            int i = 0;
            while (rs.next() && (((SelectResultRowProcessor)rowProcess).limit <= 0 || entities.size() < ((SelectResultRowProcessor)rowProcess).limit)) {
                ROW_ENTITY entity = rowProcess.currentRow(i, rs);
                if (entity != null) {
                    entities.add(entity);
                }
                ++i;
            }
            arrayList = entities;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, st);
            throw throwable;
        }
        DBUtil.close(rs, st);
        return arrayList;
    }

    public static <ENTITY> ENTITY unique(List<ENTITY> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() == 1) {
            return entities.get(0);
        }
        throw new IllegalArgumentException("wanted to get a unique entity from a list that contains more than one...");
    }

    public static <O> long executeUpdate(Connection con, List<Pair<String, List<O>>> updateQueries) throws SQLException {
        long nbUpdate = 0L;
        for (Pair<String, List<O>> updateQuery : updateQueries) {
            nbUpdate += DBUtil.executeUpdate(con, (String)updateQuery.getLeft(), updateQuery.getRight());
        }
        return nbUpdate;
    }

    public static long executeUpdate(Connection con, String updateQuery, Object ... parameters) throws SQLException {
        return DBUtil.executeUpdate(con, updateQuery, (Object)parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long executeUpdate(Connection con, String updateQuery, Object parameters) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(updateQuery);
            Collection<Object> sqlParams = parameters instanceof Object[] ? Arrays.asList((Object[])parameters) : (parameters instanceof Collection ? (Collection)parameters : Arrays.asList(parameters));
            DBUtil.setParameters(prepStmt, sqlParams);
            long l = prepStmt.executeUpdate();
            return l;
        }
        finally {
            DBUtil.close(prepStmt);
        }
    }

    public static <O> StringBuilder appendSaveParameter(StringBuilder sqlQuery, String paramName, O paramValue, boolean isInsert, Collection<O> parameters) {
        if (parameters.size() > 0) {
            sqlQuery.append(", ");
        }
        sqlQuery.append(paramName);
        if (!isInsert) {
            sqlQuery.append(" = ?");
        }
        parameters.add(paramValue);
        return sqlQuery;
    }

    public static <O> StringBuilder appendParameter(StringBuilder sqlQuery, String sqlPart, O paramValue, Collection<O> parameters) {
        parameters.add(paramValue);
        return sqlQuery.append(sqlPart);
    }

    public static StringBuilder appendListOfParameters(StringBuilder sqlQuery, Collection<?> parameters) {
        return DBUtil.appendListOfParameters(sqlQuery, parameters, null);
    }

    public static StringBuilder appendListOfParameters(StringBuilder sqlQuery, Collection<?> parameters, Collection<?> allParameters) {
        StringBuilder params = new StringBuilder();
        if (parameters != null) {
            for (Object ignored : parameters) {
                if (params.length() > 0) {
                    params.append(",");
                }
                params.append("?");
            }
            if (allParameters != null) {
                allParameters.addAll(parameters);
            }
        }
        return sqlQuery.append("(").append(params.toString()).append(")");
    }

    public static <O> void setParameters(PreparedStatement preparedStatement, Collection<O> parameters) throws SQLException {
        int paramIndex = 1;
        for (O parameter : parameters) {
            if (parameter == null) {
                preparedStatement.setObject(paramIndex, null);
            } else if (parameter instanceof String) {
                preparedStatement.setString(paramIndex, (String)parameter);
            } else if (parameter instanceof Enum) {
                preparedStatement.setString(paramIndex, ((Enum)parameter).name());
            } else if (parameter instanceof Integer) {
                preparedStatement.setInt(paramIndex, (Integer)parameter);
            } else if (parameter instanceof Long) {
                preparedStatement.setLong(paramIndex, (Long)parameter);
            } else if (parameter instanceof Timestamp) {
                preparedStatement.setTimestamp(paramIndex, (Timestamp)parameter);
            } else if (parameter instanceof DateTime) {
                preparedStatement.setTimestamp(paramIndex, new Timestamp(((java.util.Date)parameter).getTime()));
            } else if (parameter instanceof java.util.Date) {
                preparedStatement.setDate(paramIndex, new Date(((java.util.Date)parameter).getTime()));
            } else if (parameter instanceof UserDetail) {
                preparedStatement.setString(paramIndex, ((UserDetail)parameter).getId());
            } else {
                throw new IllegalArgumentException("SQL parameter type not handled: " + parameter.getClass());
            }
            ++paramIndex;
        }
    }

    public static Long getLong(ResultSet resultSet, int index) throws SQLException {
        if (resultSet.getObject(index) != null) {
            return resultSet.getLong(index);
        }
        return null;
    }

    public static java.util.Date getDateFromLong(ResultSet resultSet, int index) throws SQLException {
        Long dateIntoLongFormat = DBUtil.getLong(resultSet, index);
        if (dateIntoLongFormat != null) {
            return new java.util.Date(dateIntoLongFormat);
        }
        return null;
    }

    static {
        dsStock = new HashMap<String, DataSource>(5);
    }

    public static abstract class SelectResultRowProcessor<ROW_ENTITY> {
        private final int limit;

        protected SelectResultRowProcessor() {
            this(0);
        }

        protected SelectResultRowProcessor(int limit) {
            this.limit = limit;
        }

        protected abstract ROW_ENTITY currentRow(int var1, ResultSet var2) throws SQLException;
    }
}

