/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.util.URLUtils;

public class FileServerUtils {
    public static final String COMPONENT_ID_PARAMETER = "ComponentId";
    public static final String SOURCE_FILE_PARAMETER = "SourceFile";
    public static final String DIRECTORY_PARAMETER = "Directory";
    public static final String ARCHIVE_IT_PARAMETER = "ArchiveIt";
    public static final String DIR_TYPE_PARAMETER = "DirType";
    public static final String USER_ID_PARAMETER = "UserId";
    public static final String MIME_TYPE_PARAMETER = "MimeType";
    public static final String TYPE_UPLOAD_PARAMETER = "TypeUpload";
    public static final String NODE_ID_PARAMETER = "NodeId";
    public static final String PUBLICATION_ID_PARAMETER = "PubId";
    public static final String SIZE_PARAMETER = "Size";
    private static final ResourceLocator lookSettings = new ResourceLocator("org.silverpeas.lookAndFeel.generalLook", "");

    public static String replaceSpecialChars(String toParse) {
        String newLogicalName = toParse.replace("#", "%23");
        newLogicalName = newLogicalName.replace("%", "%25");
        newLogicalName = newLogicalName.replace("&", "%26");
        newLogicalName = newLogicalName.replace(";", "%3B");
        return newLogicalName;
    }

    public static String replaceAccentChars(String toParse) {
        String newLogicalName = toParse.replace('\u00e9', 'e');
        newLogicalName = newLogicalName.replace('\u00e8', 'e');
        newLogicalName = newLogicalName.replace('\u00eb', 'e');
        newLogicalName = newLogicalName.replace('\u00ea', 'e');
        newLogicalName = newLogicalName.replace('\u00f6', 'o');
        newLogicalName = newLogicalName.replace('\u00f4', 'o');
        newLogicalName = newLogicalName.replace('\u00f5', 'o');
        newLogicalName = newLogicalName.replace('\u00f2', 'o');
        newLogicalName = newLogicalName.replace('\u00ef', 'i');
        newLogicalName = newLogicalName.replace('\u00ee', 'i');
        newLogicalName = newLogicalName.replace('\u00ec', 'i');
        newLogicalName = newLogicalName.replace('\u00f1', 'n');
        newLogicalName = newLogicalName.replace('\u00fc', 'u');
        newLogicalName = newLogicalName.replace('\u00fb', 'u');
        newLogicalName = newLogicalName.replace('\u00f9', 'u');
        newLogicalName = newLogicalName.replace('\u00e7', 'c');
        newLogicalName = newLogicalName.replace('\u00e0', 'a');
        newLogicalName = newLogicalName.replace('\u00e4', 'a');
        newLogicalName = newLogicalName.replace('\u00e3', 'a');
        newLogicalName = newLogicalName.replace('\u00e2', 'a');
        newLogicalName = newLogicalName.replace('\u00b0', '_');
        return newLogicalName;
    }

    public static String getWebUrl(String componentId, String logicalName, String physicalName, String mimeType, String subDirectory) {
        StringBuilder url = new StringBuilder();
        String newLogicalName = URLUtils.encodePathParamValue(logicalName);
        url.append(newLogicalName).append("?ComponentId=").append(componentId).append("&SourceFile=").append(physicalName).append("&MimeType=").append(mimeType).append("&Directory=").append(subDirectory);
        return url.toString();
    }

    public static String getUrl(String componentId, String logicalName) {
        StringBuilder url = new StringBuilder();
        String newLogicalName = URLUtils.encodePathSegment(logicalName);
        url.append(FileServerUtils.getApplicationContext()).append("/FileServer/").append(newLogicalName).append("?ComponentId=").append(componentId);
        return url.toString();
    }

    public static String getUrl(String componentId, String logicalName, String physicalName, String mimeType, String subDirectory) {
        StringBuilder url = new StringBuilder();
        String newLogicalName = URLUtils.encodePathSegment(logicalName);
        url.append(FileServerUtils.getApplicationContext()).append("/FileServer/").append(newLogicalName).append("?ComponentId=").append(componentId).append("&SourceFile=").append(physicalName).append("&MimeType=").append(mimeType).append("&Directory=").append(subDirectory);
        return url.toString();
    }

    public static String getOnlineURL(String componentId, String logicalName, String physicalName, String mimeType, String subDirectory) {
        StringBuilder url = new StringBuilder();
        String newLogicalName = URLUtils.encodePathSegment(logicalName);
        url.append(FileServerUtils.getApplicationContext()).append("/OnlineFileServer/").append(newLogicalName).append("?ComponentId=").append(componentId).append("&SourceFile=").append(physicalName).append("&MimeType=").append(mimeType).append("&Directory=").append(subDirectory);
        return url.toString();
    }

    public static String getAttachmentURL(String componentId, String logicalName, String attachmentId, String lang) {
        String newLogicalName = URLUtils.encodePathSegment(logicalName);
        SilverTrace.debug("util", "FileServerUtils.getRestAttachmentURL", "root.MSG_GEN_ENTER_METHOD", "componentId = " + componentId + ", logicalName = " + newLogicalName + ", attachmentId = " + attachmentId + ", lang = " + lang);
        StringBuilder url = new StringBuilder();
        String language = lang;
        if (language == null) {
            language = I18NHelper.defaultLanguage;
        }
        SilverTrace.debug("util", "FileServerUtils.getRestAttachmentURL", "root.MSG_GEN_PARAM_VALUE", "language = " + language);
        url.append("/attached_file/").append("componentId/").append(URLUtils.encodePathSegment(componentId)).append("/attachmentId/").append(URLUtils.encodePathSegment(attachmentId)).append("/lang/").append(URLUtils.encodePathSegment(language)).append("/name/").append(newLogicalName);
        return url.toString();
    }

    public static String getImageURL(String originalImageURL, String sizeParams) {
        String resizedImagePath = originalImageURL;
        String size = sizeParams;
        if (StringUtil.isDefined(originalImageURL) && StringUtil.isDefined(sizeParams)) {
            if (sizeParams.startsWith("image.size.")) {
                size = lookSettings.getString(sizeParams);
            }
            if (StringUtil.isDefined(size) && size.length() > 1 && size.contains("x")) {
                if (originalImageURL.contains("/FileServer/") || originalImageURL.contains("/GalleryInWysiwyg/")) {
                    resizedImagePath = originalImageURL + "&Size=" + size;
                } else {
                    int lastSepIndex = originalImageURL.lastIndexOf("/");
                    if (originalImageURL.contains("/attached_file/")) {
                        size = "size/" + size;
                        lastSepIndex = originalImageURL.substring(0, lastSepIndex).lastIndexOf("/");
                    }
                    resizedImagePath = lastSepIndex == -1 ? size + "/" + originalImageURL : originalImageURL.substring(0, lastSepIndex + 1) + size + originalImageURL.substring(lastSepIndex);
                }
            }
        }
        return resizedImagePath;
    }

    public static String getAliasURL(String componentId, String logicalName, String attachmentId) {
        StringBuilder url = new StringBuilder();
        String newLogicalName = URLUtils.encodePathSegment(logicalName);
        url.append(FileServerUtils.getApplicationContext()).append("/AliasFileServer/").append(newLogicalName).append("?ComponentId=").append(componentId).append("&AttachmentId=").append(attachmentId);
        return url.toString();
    }

    public static Map<String, String> getMappedUrl(String spaceId, String componentId, String logicalName, String physicalName, String mimeType, String subDirectory) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("SpaceId", spaceId);
        parameters.put(COMPONENT_ID_PARAMETER, componentId);
        parameters.put(SOURCE_FILE_PARAMETER, physicalName);
        parameters.put(MIME_TYPE_PARAMETER, mimeType);
        parameters.put(DIRECTORY_PARAMETER, subDirectory);
        return parameters;
    }

    public static String getUrl(String componentId, String name, String mimeType, String subDirectory) {
        String url = FileServerUtils.getUrl(componentId, name, name, mimeType, subDirectory);
        return url;
    }

    public static String getUrl(String logicalName, String physicalName, String mimeType) {
        StringBuilder url = new StringBuilder();
        String newLogicalName = URLUtils.encodePathSegment(logicalName);
        url.append(FileServerUtils.getApplicationContext()).append("/FileServer/").append(newLogicalName).append("?SourceFile=").append(physicalName).append("&TypeUpload=link&MimeType=").append(mimeType);
        return url.toString();
    }

    public static String getUrl(String componentId, String userId, String logicalName, String physicalName, String mimeType, boolean archiveIt, int pubId, int nodeId, String subDirectory) {
        StringBuilder url = new StringBuilder();
        char archiveItStr = 'N';
        if (archiveIt) {
            archiveItStr = 'Y';
        }
        String newLogicalName = URLUtils.encodePathSegment(logicalName);
        url.append(FileServerUtils.getApplicationContext()).append("/FileServer/").append(newLogicalName).append("?ComponentId=").append(componentId).append("&UserId=").append(userId).append("&SourceFile=").append(URLUtils.encodePathParamValue(physicalName)).append("&MimeType=").append(mimeType).append("&ArchiveIt=").append(archiveItStr).append("&PubId=").append(pubId).append("&NodeId=").append(nodeId).append("&Directory=").append(subDirectory);
        return url.toString();
    }

    public static String getUrlToTempDir(String logicalName) {
        StringBuilder path = new StringBuilder();
        path.append(FileServerUtils.getApplicationContext()).append("/TempFileServer/").append(URLUtils.encodePathSegment(logicalName));
        try {
            URI uri = new URI(null, null, path.toString(), null);
            return uri.toString();
        }
        catch (URISyntaxException ex) {
            path = new StringBuilder();
            String newLogicalName = URLUtils.encodePathSegment(logicalName);
            path.append(FileServerUtils.getApplicationContext()).append("/TempFileServer/").append(newLogicalName);
            return path.toString();
        }
    }

    public static String replaceInvalidPathChars(String toParse) {
        String newLogicalName = toParse.replace('\'', '_');
        newLogicalName = newLogicalName.replace('/', '_');
        newLogicalName = newLogicalName.replace(':', '_');
        newLogicalName = newLogicalName.replace('*', '_');
        newLogicalName = newLogicalName.replace('?', '_');
        newLogicalName = newLogicalName.replace('\"', '_');
        newLogicalName = newLogicalName.replace('<', '_');
        newLogicalName = newLogicalName.replace('>', '_');
        newLogicalName = newLogicalName.replace('|', '_');
        return newLogicalName;
    }

    public static String getApplicationContext() {
        String applicationContext = URLManager.getApplicationURL();
        if (applicationContext.endsWith("/")) {
            applicationContext = applicationContext.substring(0, applicationContext.length() - 1);
        }
        return applicationContext;
    }
}

