/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.exception;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.exception.FromModule;
import com.stratelia.webactiv.util.exception.WithNested;

public abstract class SilverpeasRuntimeException
extends RuntimeException
implements WithNested,
FromModule {
    public static final int FATAL = 5;
    public static final int ERROR = 4;
    public static final int WARNING = 3;
    private int errorLevel = 4;
    private Throwable nested = null;
    private String extraParams = "";
    private String callingClass = "NoClass";

    public SilverpeasRuntimeException(String callingClass, int errorLevel, String message) {
        this(callingClass, errorLevel, message, null, null);
    }

    public SilverpeasRuntimeException(String callingClass, int errorLevel, String message, String extraParams) {
        this(callingClass, errorLevel, message, extraParams, null);
    }

    public SilverpeasRuntimeException(String callingClass, int errorLevel, String message, Exception nested) {
        this(callingClass, errorLevel, message, null, nested);
    }

    public SilverpeasRuntimeException(String callingClass, int errorLevel, String message, String extraParams, Throwable nested) {
        super(message, nested);
        this.callingClass = callingClass;
        this.errorLevel = errorLevel;
        this.extraParams = extraParams;
        this.nested = nested;
        if (errorLevel == 5) {
            SilverTrace.fatal(this.getModule(), callingClass, message, extraParams, this);
        } else {
            SilverTrace.info(this.getModule(), callingClass, message, extraParams, this);
        }
    }

    @Override
    public Throwable getNested() {
        return this.nested;
    }

    @Override
    public String getMessageLang() {
        return SilverTrace.getTraceMessage(this.getMessage());
    }

    @Override
    public String getMessageLang(String language) {
        return SilverTrace.getTraceMessage(this.getMessage(), language);
    }

    @Override
    public void traceException() {
        switch (this.errorLevel) {
            case 5: {
                SilverTrace.fatal(this.getModule(), this.callingClass, this.getMessage(), this.extraParams, this);
                break;
            }
            case 4: {
                SilverTrace.error(this.getModule(), this.callingClass, this.getMessage(), this.extraParams, this);
                break;
            }
            case 3: {
                SilverTrace.warn(this.getModule(), this.callingClass, this.getMessage(), this.extraParams, this);
            }
        }
    }

    @Override
    public int getErrorLevel() {
        return this.errorLevel;
    }
}

