/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication.password;

import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.util.ResourceLocator;
import javax.mail.MessagingException;
import org.silverpeas.authentication.password.ForgottenPasswordMailParameters;
import org.silverpeas.mail.MailAddress;
import org.silverpeas.mail.MailSending;

public class ForgottenPasswordMailManager {
    private static final String PREFIX_RESET_PASSWORD_REQUEST = "resetPasswordRequest";
    private static final String PREFIX_NEW_PASSWORD = "newPassword";
    private static final String PREFIX_ERROR = "error";
    private static final String PREFIX_ADMIN = "admin";
    private static final String CONTENT = "content";
    private static final String SUBJECT = "subject";
    private ResourceLocator resource = new ResourceLocator("com.silverpeas.authentication.multilang.forgottenPasswordMail", "");
    private String fromAddress;
    private String fromName;
    private String adminEmail;

    public ForgottenPasswordMailManager() {
        this.initFromAddress();
    }

    private void initFromAddress() {
        ResourceLocator mailSettings = new ResourceLocator("com.silverpeas.authentication.settings.forgottenPasswordMail", "");
        this.adminEmail = mailSettings.getString("admin.mail", AdminReference.getAdminService().getAdministratorEmail());
        this.fromAddress = mailSettings.getString("fromAddress", this.adminEmail);
        this.fromName = mailSettings.getString("fromName", "Silverpeas");
    }

    public void sendResetPasswordRequestMail(ForgottenPasswordMailParameters parameters) throws MessagingException {
        this.sendMail(parameters, PREFIX_RESET_PASSWORD_REQUEST);
    }

    public void sendNewPasswordMail(ForgottenPasswordMailParameters parameters) throws MessagingException {
        this.sendMail(parameters, PREFIX_NEW_PASSWORD);
    }

    public void sendErrorMail(ForgottenPasswordMailParameters parameters) throws MessagingException {
        parameters.setToAddress(this.adminEmail);
        this.sendMail(parameters, PREFIX_ERROR);
    }

    public void sendAdminMail(ForgottenPasswordMailParameters parameters) throws MessagingException {
        parameters.setToAddress(this.adminEmail);
        this.sendMail(parameters, PREFIX_ADMIN);
    }

    private void sendMail(ForgottenPasswordMailParameters parameters, String resourcePrefix) throws MessagingException {
        parameters.setSubject(this.resource.getString(resourcePrefix + "." + SUBJECT));
        parameters.setContent(this.resource.getString(resourcePrefix + "." + CONTENT));
        MailSending.from(MailAddress.eMail(this.fromAddress).withName(this.fromName)).to(MailAddress.eMail(parameters.getToAddress())).withSubject(parameters.getSubject()).withContent(parameters.getFilledContent()).send();
    }
}

