/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.chart;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.silverpeas.chart.AbstractChartItem;

public abstract class AbstractAxisChartItem<XAXIS_DATA_TYPE, YAXIS_DATA_TYPE, ITEM_TYPE extends AbstractAxisChartItem<XAXIS_DATA_TYPE, YAXIS_DATA_TYPE, ITEM_TYPE>>
extends AbstractChartItem<ITEM_TYPE> {
    private final XAXIS_DATA_TYPE x;
    private List<YAXIS_DATA_TYPE> yValues = new ArrayList<YAXIS_DATA_TYPE>();

    protected AbstractAxisChartItem(XAXIS_DATA_TYPE x) {
        this.x = x;
    }

    public XAXIS_DATA_TYPE getX() {
        return this.x;
    }

    public List<YAXIS_DATA_TYPE> getYValues() {
        return this.yValues;
    }

    public ITEM_TYPE add(YAXIS_DATA_TYPE y) {
        this.getYValues().add(y);
        return (ITEM_TYPE)this;
    }

    @Override
    protected void computeDataAsJson(JSONObject itemAsJson) {
        JSONArray datasetsAsJson = new JSONArray();
        itemAsJson.put("x", (Object)this.computeXAsJson(this.getX()));
        for (YAXIS_DATA_TYPE yValue : this.getYValues()) {
            datasetsAsJson.put(this.computeYValueAsJson(yValue));
        }
        itemAsJson.put("y", (Object)datasetsAsJson);
    }

    protected abstract JSONObject computeXAsJson(XAXIS_DATA_TYPE var1);

    protected abstract <T> T computeYValueAsJson(YAXIS_DATA_TYPE var1);
}

