/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dateReminder.persistent.service;

import com.silverpeas.annotation.Service;
import java.util.Collection;
import java.util.Date;
import javax.inject.Inject;
import org.silverpeas.EntityReference;
import org.silverpeas.dateReminder.exception.DateReminderException;
import org.silverpeas.dateReminder.persistent.DateReminderDetail;
import org.silverpeas.dateReminder.persistent.PersistentResourceDateReminder;
import org.silverpeas.dateReminder.persistent.repository.PersistentResourceDateReminderRepository;
import org.silverpeas.dateReminder.persistent.service.PersistentDateReminderService;
import org.silverpeas.persistence.repository.OperationContext;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="persistentDateReminderService")
public class DefaultDateReminderService
implements PersistentDateReminderService {
    @Inject
    private PersistentResourceDateReminderRepository dateReminderRepository;

    @Override
    public PersistentResourceDateReminder get(EntityReference resource) {
        return this.bind(this.dateReminderRepository.getByTypeAndResourceId(resource.getType(), resource.getId()));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public PersistentResourceDateReminder create(EntityReference resource, DateReminderDetail dateReminderDetail) throws DateReminderException {
        PersistentResourceDateReminder dateReminder = new PersistentResourceDateReminder();
        dateReminder.setResource(resource);
        dateReminder.setDateReminder(dateReminderDetail);
        dateReminder.validate();
        PersistentResourceDateReminder savedDateReminder = this.dateReminderRepository.save(OperationContext.fromUser(dateReminder.getCreatedBy()), dateReminder);
        return savedDateReminder;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public PersistentResourceDateReminder set(EntityReference resource, DateReminderDetail dateReminderDetail) throws DateReminderException {
        PersistentResourceDateReminder dateReminder = this.get(resource);
        dateReminder.setDateReminder(dateReminderDetail);
        dateReminder.validate();
        PersistentResourceDateReminder savedDateReminder = this.dateReminderRepository.save(OperationContext.fromUser(dateReminder.getLastUpdatedBy()), dateReminder);
        return savedDateReminder;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void remove(EntityReference resource) {
        PersistentResourceDateReminder dateReminder = this.get(resource);
        if (dateReminder.exists()) {
            this.dateReminderRepository.delete(new PersistentResourceDateReminder[]{dateReminder});
        }
    }

    private PersistentResourceDateReminder bind(PersistentResourceDateReminder dateReminder) {
        if (dateReminder == null) {
            return PersistentResourceDateReminder.NONEDATEREMINDER;
        }
        return dateReminder;
    }

    @Override
    public Collection<PersistentResourceDateReminder> listAllDateReminderMaturing(Date deadLine) {
        Collection<PersistentResourceDateReminder> listResourceDateReminder = this.dateReminderRepository.getByDeadLine(deadLine);
        return listResourceDateReminder;
    }
}

